/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class CirclesMixVis {
    static int maxN = 1000;
    static int minN = 20;
    static int border = 1000;
    int N;
    int H;
    int W;
    int[][] givenImage;
    int[] imgArg;
    int Nc;
    int[][] drawnImage;
    static String exec;
    static boolean vis;
    static boolean debug;
    static Process proc;
    InputStream is;
    OutputStream os;
    BufferedReader br;

    String generate(String string) {
        try {
            int n;
            int n2;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            long l = Long.parseLong(string);
            secureRandom.setSeed(l);
            this.N = secureRandom.nextInt(maxN - minN + 1) + minN;
            if (l == 1L) {
                this.N = minN;
            } else if (l == 2L) {
                this.N = maxN;
            }
            BufferedImage bufferedImage = ImageIO.read(new File("images//" + string + ".jpg"));
            this.H = bufferedImage.getHeight();
            this.W = bufferedImage.getWidth();
            this.givenImage = new int[this.H][this.W];
            for (n2 = 0; n2 < this.H; ++n2) {
                for (n = 0; n < this.W; ++n) {
                    this.givenImage[n2][n] = bufferedImage.getRGB(n, n2) & 0xFFFFFF;
                }
            }
            this.imgArg = new int[this.H * this.W];
            for (n2 = 0; n2 < this.H; ++n2) {
                for (n = 0; n < this.W; ++n) {
                    this.imgArg[n2 * this.W + n] = this.givenImage[n2][n];
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("H = " + this.H + '\n');
            stringBuffer.append("W = " + this.W + '\n');
            stringBuffer.append("N = " + this.N + '\n');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
            return "";
        }
    }

    int comp(int n, int n2) {
        return n >> 8 * n2 & 0xFF;
    }

    int getDiff(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 3; ++i) {
            n3 += Math.abs(this.comp(n, i) - this.comp(n2, i));
        }
        return n3;
    }

    int drawOver(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 3; ++i) {
            n3 += (this.comp(n, i) + this.comp(n2, i)) / 2 << 8 * i;
        }
        return n3;
    }

    int p2(int n) {
        return n * n;
    }

    public double runTest(String string) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            int[] nArray4;
            String string2 = this.generate(string);
            if (debug) {
                System.out.println(string2);
            }
            if (proc != null) {
                int[] nArray5;
                try {
                    nArray5 = this.drawImage(this.H, this.imgArg, this.N);
                }
                catch (Exception exception) {
                    this.addFatalError("Failed to get result from drawImage.");
                    return -1.0;
                }
                if (nArray5.length % 4 != 0) {
                    this.addFatalError("The number of elements in your return must be divisible by 4, and your return contained " + nArray5.length + ".");
                    return -1.0;
                }
                if (nArray5.length > 4 * this.N) {
                    this.addFatalError("Your return can have at most " + 4 * this.N + " elements, and it contained " + nArray5.length + ".");
                    return -1.0;
                }
                this.Nc = nArray5.length / 4;
                nArray4 = new int[this.Nc];
                nArray3 = new int[this.Nc];
                nArray2 = new int[this.Nc];
                nArray = new int[this.Nc];
                for (n4 = 0; n4 < this.Nc; ++n4) {
                    nArray4[n4] = nArray5[4 * n4];
                    nArray3[n4] = nArray5[4 * n4 + 1];
                    nArray2[n4] = nArray5[4 * n4 + 2];
                    nArray[n4] = nArray5[4 * n4 + 3];
                    if (nArray4[n4] < -border || nArray4[n4] > this.H - 1 + border) {
                        this.addFatalError("Center of circle " + n4 + " must have center at row between " + -border + " and " + (this.H - 1 + border) + ", inclusive.");
                        return -1.0;
                    }
                    if (nArray3[n4] < -border || nArray3[n4] > this.W - 1 + border) {
                        this.addFatalError("Center of circle " + n4 + " must have center at column between " + -border + " and " + (this.W - 1 + border) + ", inclusive.");
                        return -1.0;
                    }
                    if (nArray2[n4] < 0 || nArray2[n4] > border) {
                        this.addFatalError("Radius of circle " + n4 + " must be between 0 and " + border + ".");
                        return -1.0;
                    }
                    if (nArray[n4] >= 0 && nArray[n4] <= 0xFFFFFF) continue;
                    this.addFatalError("Circle " + n4 + " can only have color between 0 and 0xFFFFFF.");
                    return -1.0;
                }
            } else {
                this.Nc = 0;
                nArray4 = new int[this.Nc];
                nArray3 = new int[this.Nc];
                nArray2 = new int[this.Nc];
                nArray = new int[this.Nc];
            }
            this.drawnImage = new int[this.H][this.W];
            for (n3 = 0; n3 < this.H; ++n3) {
                Arrays.fill(this.drawnImage[n3], 0);
            }
            for (n3 = 0; n3 < this.Nc; ++n3) {
                for (n4 = Math.max(nArray4[n3] - nArray2[n3], 0); n4 <= Math.min(nArray4[n3] + nArray2[n3], this.H - 1); ++n4) {
                    n2 = (int)Math.sqrt(this.p2(nArray2[n3]) - this.p2(nArray4[n3] - n4));
                    for (n = Math.max(nArray3[n3] - n2, 0); n <= Math.min(nArray3[n3] + n2, this.W - 1); ++n) {
                        if (this.p2(nArray4[n3] - n4) + this.p2(nArray3[n3] - n) > this.p2(nArray2[n3])) continue;
                        this.drawnImage[n4][n] = this.drawOver(this.drawnImage[n4][n], nArray[n3]);
                    }
                }
            }
            if (vis) {
                BufferedImage bufferedImage = new BufferedImage(this.W, this.H, 1);
                for (n4 = 0; n4 < this.H; ++n4) {
                    for (n2 = 0; n2 < this.W; ++n2) {
                        bufferedImage.setRGB(n2, n4, this.drawnImage[n4][n2]);
                    }
                }
                ImageIO.write((RenderedImage)bufferedImage, "png", new File(string + ".png"));
            }
            double d = 0.0;
            for (n2 = 0; n2 < this.H; ++n2) {
                for (n = 0; n < this.W; ++n) {
                    d += (double)this.getDiff(this.givenImage[n2][n], this.drawnImage[n2][n]);
                }
            }
            return d;
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to process your program's results.");
            exception.printStackTrace();
            return 0.0;
        }
    }

    int[] drawImage(int n, int[] nArray, int n2) throws IOException {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append('\n');
        stringBuffer.append(nArray.length).append('\n');
        for (n3 = 0; n3 < nArray.length; ++n3) {
            stringBuffer.append(nArray[n3]).append('\n');
        }
        stringBuffer.append(n2).append('\n');
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        int n4 = Integer.parseInt(this.br.readLine());
        int[] nArray2 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray2[n3] = Integer.parseInt(this.br.readLine());
        }
        return nArray2;
    }

    public CirclesMixVis(String string) {
        Thread thread = null;
        if (exec != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                proc = runtime.exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.is));
                thread = new ErrorReader(proc.getErrorStream());
                thread.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        double d = this.runTest(string);
        if (thread != null) {
            try {
                thread.join(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + d);
        if (proc != null) {
            try {
                proc.destroy();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (!stringArray[i].equals("-debug")) continue;
            debug = true;
        }
        CirclesMixVis circlesMixVis = new CirclesMixVis(string);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }
}

