/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class CakeSharingVis {
    static int minS = 10;
    static int maxS = 80;
    static int minN = 5;
    static final int invalidScore = -1;
    int H;
    int W;
    int N;
    int NR;
    char[][] roses;
    volatile List<ArrayList<Point>> pieces;
    volatile List<Double> areas;
    volatile List<Integer> rosesInside;
    volatile List<Point> centers;
    volatile List<Polygon> polygons;
    volatile List<Cut> cuts;
    volatile List<Cut> redos;
    int[][] rosesPiecesIdx;
    final Object lock = new Object();
    double score = 0.0;
    static String seed;
    JFrame jf;
    Vis v;
    static String exec;
    static boolean vis;
    static boolean manual;
    static boolean debug;
    static boolean plain;
    static boolean save;
    static boolean showColors;
    static boolean showPoints;
    static boolean showValues;
    static Process proc;
    InputStream is;
    OutputStream os;
    BufferedReader br;
    static int SZ;
    static int res;
    volatile boolean manualReady;
    volatile Point pStart;
    volatile Point pMoving;
    volatile Color[] pieceColors;
    volatile Color[] roseColors;

    boolean isInside(Point point) {
        return point.y >= 0 && point.y <= this.H && point.x >= 0 && point.x <= this.W;
    }

    int isOnPieceEdge(ArrayList<Point> arrayList, Point point) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).equals(point)) continue;
            return i;
        }
        return -1;
    }

    int gcd(int n, int n2) {
        return n2 == 0 ? n : this.gcd(n2, n % n2);
    }

    void addPointsOnCut(ArrayList<Point> arrayList, int n, Point point, Point point2) {
        int n2 = point2.x - point.x;
        int n3 = point2.y - point.y;
        int n4 = Math.abs(this.gcd(n2, n3));
        if (n4 == 1) {
            return;
        }
        for (int i = 1; i < n4; ++i) {
            arrayList.add(n + i - 1, new Point(point.x + n2 / n4 * i, point.y + n3 / n4 * i));
        }
    }

    boolean isRoseInsidePiece(ArrayList<Point> arrayList, Point point) {
        boolean bl = false;
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            Point point2 = arrayList.get(i);
            Point point3 = arrayList.get(i + 1);
            int n = Math.abs(point2.y - point3.y);
            if (2 * point2.y > point.y == 2 * point3.y > point.y || (point.x - 2 * point2.x) * n >= (point3.x - point2.x) * (point.y - 2 * point2.y) * n / (point3.y - point2.y)) continue;
            bl = !bl;
        }
        return bl;
    }

    int updateRosesInsidePiece(ArrayList<Point> arrayList, int n) {
        int n2 = 0;
        for (int i = 0; i < this.H; ++i) {
            for (int j = 0; j < this.W; ++j) {
                if (this.roses[i][j] != 'R' || !this.isRoseInsidePiece(arrayList, new Point(2 * j + 1, 2 * i + 1))) continue;
                if (vis) {
                    this.rosesPiecesIdx[i][j] = n;
                }
                ++n2;
            }
        }
        return n2;
    }

    double getPieceArea(ArrayList<Point> arrayList) {
        double d = 0.0;
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            Point point = arrayList.get(i);
            Point point2 = arrayList.get(i + 1);
            d += (double)((point2.x - point.x) * (point.y + point2.y));
        }
        return Math.abs(d) / 2.0;
    }

    String generate(String string) {
        try {
            int n;
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            long l = Long.parseLong(string);
            secureRandom.setSeed(l);
            this.H = secureRandom.nextInt(maxS - minS + 1) + minS;
            this.W = secureRandom.nextInt(maxS - minS + 1) + minS;
            int n2 = 2 * (this.W + this.H);
            this.N = secureRandom.nextInt(n2 - minN + 1) + minN;
            int n3 = secureRandom.nextInt(81) + 10;
            if (l == 1L) {
                this.W = this.H = minS;
                this.N = minN;
                n3 = 7;
            } else if (l == 2L) {
                this.W = this.H = (minS + maxS) / 2;
                this.N = 10;
            } else if (l == 3L) {
                this.W = this.H = maxS;
                this.N = 2 * (this.W + this.H);
            }
            this.roses = new char[this.H][this.W];
            this.NR = 0;
            for (int i = 0; i < this.H; ++i) {
                for (n = 0; n < this.W; ++n) {
                    int n4 = secureRandom.nextInt(100);
                    int n5 = this.roses[i][n] = n4 < n3 ? 82 : 46;
                    if (this.roses[i][n] != 'R') continue;
                    ++this.NR;
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("H = ").append(this.H).append('\n');
            stringBuffer.append("W = ").append(this.W).append('\n');
            stringBuffer.append("Number of pieces N = ").append(this.N).append('\n');
            stringBuffer.append("Probability of a rose = ").append(n3).append('\n');
            stringBuffer.append("Number of roses = ").append(this.NR).append('\n');
            for (n = 0; n < this.H; ++n) {
                stringBuffer.append(new String(this.roses[n])).append('\n');
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while generating test case.");
            exception.printStackTrace();
            return "";
        }
    }

    String toString(ArrayList<Point> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(arrayList.get(i));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String makeCut(Point object, Point point) {
        Object object2 = this.lock;
        synchronized (object2) {
            int n;
            int n2;
            ArrayList<Point> arrayList;
            int n3;
            if (((Point)object).equals(point)) {
                return "The cut must have non-zero length.";
            }
            if (!this.isInside((Point)object) || !this.isInside(point)) {
                return "The cut can not start or end outside the cake.";
            }
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            for (n3 = 0; n3 < this.pieces.size(); ++n3) {
                arrayList = this.pieces.get(n3);
                n5 = this.isOnPieceEdge(arrayList, (Point)object);
                if (n5 == -1) continue;
                n6 = this.isOnPieceEdge(arrayList, point);
                if (n6 == -1) {
                    n5 = -1;
                    continue;
                }
                n4 = n3;
                break;
            }
            if (n4 == -1) {
                return "The cut must divide one piece in two pieces.";
            }
            if (n5 > n6) {
                n3 = n6;
                n6 = n5;
                n5 = n3;
                arrayList = point;
                point = object;
                object = arrayList;
            }
            ArrayList<Point> arrayList2 = this.pieces.get(n4);
            arrayList = new ArrayList<Point>();
            for (int i = n5; i <= n6; ++i) {
                arrayList.add(arrayList2.get(i));
            }
            this.addPointsOnCut(arrayList, arrayList.size(), point, (Point)object);
            arrayList.add((Point)object);
            double d = this.getPieceArea(arrayList);
            if (d < 0.25) {
                return "The pieces produced by the cut must have non-zero area.";
            }
            ArrayList<Point> arrayList3 = new ArrayList<Point>();
            for (n2 = 0; n2 <= n5; ++n2) {
                arrayList3.add(arrayList2.get(n2));
            }
            this.addPointsOnCut(arrayList3, arrayList3.size(), (Point)object, point);
            for (n2 = n6; n2 < arrayList2.size(); ++n2) {
                arrayList3.add(arrayList2.get(n2));
            }
            double d2 = this.getPieceArea(arrayList3);
            if (d2 < 0.25) {
                return "The pieces produced by the cut must have non-zero area.";
            }
            this.pieces.add(arrayList);
            this.areas.add(d);
            if (vis) {
                this.centers.add(this.getPieceCenter(arrayList));
                this.polygons.add(this.getPiecePolygon(arrayList));
            }
            this.pieces.set(n4, arrayList3);
            this.areas.set(n4, d2);
            if (vis) {
                this.centers.set(n4, this.getPieceCenter(arrayList3));
                this.polygons.set(n4, this.getPiecePolygon(arrayList3));
            }
            Cut cut = new Cut((Point)object, point);
            this.cuts.add(cut);
            if (debug) {
                System.out.println("Pieces after cut " + cut + ":");
                for (n = 0; n < this.pieces.size(); ++n) {
                    System.out.println(this.toString(this.pieces.get(n)) + ", area " + this.areas.get(n));
                }
                System.out.println();
            }
            if (((Point)object).x != point.x && ((Point)object).y != point.y) {
                int n7;
                int n8;
                int n9;
                if (((Point)object).x < point.x) {
                    n = ((Point)object).x;
                    n9 = ((Point)object).y;
                    n8 = point.x;
                    n7 = point.y;
                } else {
                    n = point.x;
                    n9 = point.y;
                    n8 = ((Point)object).x;
                    n7 = ((Point)object).y;
                }
                int n10 = n8 - n;
                int n11 = n7 - n9;
                for (int i = n; i < n8; ++i) {
                    int n12 = n9 + ((2 * (i - n) + 1) * n11 / n10 - 1) / 2;
                    if ((2 * (n12 - n9) + 1) * n10 != (2 * (i - n) + 1) * n11 || this.roses[n12][i] != 'R') continue;
                    this.roses[n12][i] = 68;
                    --this.NR;
                    if (!debug) continue;
                    System.out.println("Destroyed a rose at (" + n12 + ", " + i + ")");
                }
            }
            this.rosesInside.set(n4, this.updateRosesInsidePiece(arrayList3, n4));
            this.rosesInside.add(this.updateRosesInsidePiece(arrayList, this.rosesInside.size()));
            this.getScore();
        }
        return "";
    }

    void initBoard() {
        this.pieces = new ArrayList<ArrayList<Point>>();
        this.areas = new ArrayList<Double>();
        this.rosesInside = new ArrayList<Integer>();
        for (int i = 0; i < this.H; ++i) {
            for (int j = 0; j < this.W; ++j) {
                if (this.roses[i][j] != 'D') continue;
                this.roses[i][j] = 82;
                ++this.NR;
            }
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Point point = new Point(0, 0);
        Point point2 = new Point(this.W, 0);
        Point point3 = new Point(this.W, this.H);
        Point point4 = new Point(0, this.H);
        arrayList.add(point);
        this.addPointsOnCut(arrayList, arrayList.size(), point, point2);
        arrayList.add(point2);
        this.addPointsOnCut(arrayList, arrayList.size(), point2, point3);
        arrayList.add(point3);
        this.addPointsOnCut(arrayList, arrayList.size(), point3, point4);
        arrayList.add(point4);
        this.addPointsOnCut(arrayList, arrayList.size(), point4, point);
        arrayList.add(point);
        this.pieces.add(arrayList);
        this.areas.add(this.getPieceArea(arrayList));
        this.rosesInside.add(this.NR);
        this.cuts = new ArrayList<Cut>();
        if (vis) {
            this.centers = new ArrayList<Point>();
            this.centers.add(this.getPieceCenter(arrayList));
            this.polygons = new ArrayList<Polygon>();
            this.polygons.add(this.getPiecePolygon(arrayList));
            this.rosesPiecesIdx = new int[this.H][this.W];
        }
        this.getScore();
    }

    double getScore() {
        this.score = 0.0;
        if (this.pieces.size() == 1) {
            return this.score;
        }
        double d = (double)(this.H * this.W) * 1.0 / (double)this.pieces.size();
        double d2 = 0.0;
        for (int i = 0; i < this.pieces.size(); ++i) {
            d2 += Math.pow(d - this.areas.get(i), 2.0);
        }
        d2 = Math.sqrt(d2 / (double)this.pieces.size());
        double d3 = (double)this.NR * 1.0 / (double)this.pieces.size();
        double d4 = 0.0;
        for (int i = 0; i < this.pieces.size(); ++i) {
            d4 += Math.pow(d3 - (double)this.rosesInside.get(i).intValue(), 2.0);
        }
        d4 = Math.sqrt(d4 / (double)this.pieces.size());
        this.score = (1.0 + d2) * (1.0 + d4);
        return this.score;
    }

    public double runTest(String string) {
        try {
            String[] stringArray;
            int n;
            int n2;
            String[] stringArray2;
            String string2 = this.generate(string);
            if (debug) {
                System.out.println(string2);
            }
            this.redos = new ArrayList<Cut>();
            if (vis) {
                this.jf.setVisible(true);
                stringArray2 = this.jf.getInsets();
                n2 = stringArray2.left + stringArray2.right + 8;
                n = stringArray2.top + stringArray2.bottom + 8;
                stringArray = Toolkit.getDefaultToolkit();
                Dimension dimension = stringArray.getScreenSize();
                Insets insets = stringArray.getScreenInsets(this.jf.getGraphicsConfiguration());
                dimension.width -= insets.left + insets.right;
                dimension.height -= insets.top + insets.bottom;
                res = Math.max(800, Math.min(dimension.width, dimension.height)) / 100;
                if (SZ == 0) {
                    SZ = (int)Math.min((double)(dimension.width - n2 - 120) / ((double)this.W + 0.5), (double)((dimension.height - n) / (this.H + 1)));
                    if (!plain && SZ < 20) {
                        plain = true;
                    }
                }
                Dimension dimension2 = this.v.getVisDimension();
                this.v.setPreferredSize(dimension2);
                this.jf.setSize(Math.min(dimension2.width + n2, dimension.width), Math.min(dimension2.height + n, dimension.height));
                this.manualReady = false;
                this.pieceColors = new Color[this.N];
                this.roseColors = new Color[this.N];
                Random random = new Random(Long.parseLong(string));
                for (int i = 0; i < this.N; ++i) {
                    float f = i < 14 ? (float)(i * 5 % 14) / 14.0f : random.nextFloat();
                    float f2 = i < 14 ? 0.1f : random.nextFloat() * 0.1f + 0.1f;
                    float f3 = i < 14 ? 1.0f : random.nextFloat() * 0.1f + 0.9f;
                    this.pieceColors[i] = new Color(Color.HSBtoRGB(f, f2, f3));
                    this.roseColors[i] = new Color(Color.HSBtoRGB(f, f2 + 0.2f, f3 - 0.1f));
                }
            }
            this.initBoard();
            if (vis) {
                this.draw();
            }
            if (proc != null) {
                String[] stringArray3;
                stringArray2 = new String[this.H];
                for (n2 = 0; n2 < this.H; ++n2) {
                    stringArray2[n2] = new String(this.roses[n2]);
                }
                try {
                    stringArray3 = this.cut(stringArray2, this.N);
                }
                catch (Exception exception) {
                    this.addFatalError("Failed to get result from cut.");
                    return -1.0;
                }
                if (stringArray3 == null) {
                    this.addFatalError("Your return contained invalid number of elements.");
                    return -1.0;
                }
                if (stringArray3.length != this.N - 1) {
                    this.addFatalError("Your return must contain exactly " + (this.N - 1) + " elements, and it contains " + stringArray3.length + ".");
                    return -1.0;
                }
                for (n = 0; n < stringArray3.length; ++n) {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    stringArray = stringArray3[n].split(" ");
                    if (stringArray.length != 4) {
                        this.addFatalError("Cut " + n + ": Each element of your return must be formatted as \"X1 Y1 X2 Y2\"");
                        return -1.0;
                    }
                    try {
                        n6 = Integer.parseInt(stringArray[0]);
                        n5 = Integer.parseInt(stringArray[1]);
                        n4 = Integer.parseInt(stringArray[2]);
                        n3 = Integer.parseInt(stringArray[3]);
                    }
                    catch (Exception exception) {
                        this.addFatalError("Cut " + n + ": all elements in each element of your return must be integers.");
                        return -1.0;
                    }
                    Point point = new Point(n6, n5);
                    Point point2 = new Point(n4, n3);
                    String string3 = this.makeCut(point, point2);
                    if (string3.equals("")) continue;
                    this.addFatalError("Cut " + n + ": " + string3);
                    return -1.0;
                }
                if (vis) {
                    this.draw();
                }
            }
            if (manual) {
                this.addFatalError("Manual play on");
                while (!this.manualReady) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (this.pieces.size() != this.N) {
                this.addFatalError("You must cut the cake into exactly " + this.N + " pieces.");
                return -1.0;
            }
            return this.getScore();
        }
        catch (Exception exception) {
            this.addFatalError("An exception occurred while trying to get your program's results.");
            exception.printStackTrace();
            return -1.0;
        }
    }

    String[] cut(String[] stringArray, int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray.length).append("\n");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringBuffer.append(stringArray[n2]).append("\n");
        }
        stringBuffer.append(n).append("\n");
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        n2 = Integer.parseInt(this.br.readLine());
        String[] stringArray2 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray2[i] = this.br.readLine();
        }
        return stringArray2;
    }

    void draw() {
        if (!vis) {
            return;
        }
        this.v.repaint();
    }

    Point getPieceCenter(ArrayList<Point> arrayList) {
        List<Point> list = this.convexHull(arrayList);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            n += list.get((int)i).x;
            n2 += list.get((int)i).y;
            ++n3;
        }
        return new Point(n * SZ / n3, n2 * SZ / n3);
    }

    Polygon getPiecePolygon(ArrayList<Point> arrayList) {
        List<Point> list = this.convexHull(arrayList);
        int[] nArray = new int[list.size()];
        int[] nArray2 = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = list.get((int)i).x * SZ;
            nArray2[i] = list.get((int)i).y * SZ;
        }
        return new Polygon(nArray, nArray2, nArray.length);
    }

    List<Point> convexHull(List<Point> list) {
        if (list == null) {
            return null;
        }
        if (list.size() < 3) {
            return null;
        }
        Point point = list.get(0);
        for (Point point2 : list) {
            if (point2.y >= point.y && (point2.y != point.y || point2.x <= point.x)) continue;
            point = point2;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(point);
        double d = -1.0;
        while (true) {
            Point point3 = null;
            double d2 = Math.PI * 3;
            Point point4 = (Point)arrayList.get(arrayList.size() - 1);
            for (Point point5 : list) {
                if (point5.equals(point4)) continue;
                double d3 = Math.atan2(point5.y - point4.y, point5.x - point4.x);
                if (d3 < 0.0) {
                    d3 += Math.PI * 2;
                }
                if (!(d3 <= d2) || !(d3 >= d)) continue;
                d2 = d3;
                point3 = point5;
            }
            d = d2;
            if (point3 == null || point3.equals(point)) break;
            arrayList.add(point3);
        }
        return arrayList;
    }

    boolean isValidEndPoint(Point point) {
        for (int i = 0; i < this.pieces.size(); ++i) {
            ArrayList<Point> arrayList = this.pieces.get(i);
            for (int j = 0; j < arrayList.size() - 1; ++j) {
                Point point2 = arrayList.get(j);
                if (!point2.equals(point)) continue;
                return true;
            }
        }
        return false;
    }

    public CakeSharingVis(String string) {
        try {
            Object object;
            if (vis) {
                this.jf = new JFrame();
                this.jf.setTitle("Seed " + string);
                this.v = new Vis();
                object = new JScrollPane(this.v);
                this.jf.getContentPane().add((Component)object);
            }
            if (exec != null) {
                try {
                    object = Runtime.getRuntime();
                    proc = ((Runtime)object).exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(string));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        seed = "1";
        vis = true;
        manual = false;
        SZ = 0;
        plain = false;
        save = false;
        showColors = false;
        showPoints = true;
        showValues = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                seed = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (stringArray[i].equals("-manual")) {
                manual = true;
            }
            if (stringArray[i].equals("-size")) {
                SZ = Integer.parseInt(stringArray[++i]);
            }
            if (stringArray[i].equals("-debug")) {
                debug = true;
            }
            if (stringArray[i].equals("-plain")) {
                plain = true;
            }
            if (stringArray[i].equals("-save")) {
                save = true;
            }
            if (stringArray[i].equals("-color")) {
                showColors = true;
            }
            if (stringArray[i].equals("-nopoints")) {
                showPoints = false;
            }
            if (!stringArray[i].equals("-novalues")) continue;
            showValues = true;
        }
        if (exec == null) {
            manual = true;
        }
        if (manual) {
            vis = true;
        }
        CakeSharingVis cakeSharingVis = new CakeSharingVis(seed);
    }

    void addFatalError(String string) {
        System.out.println(string);
    }

    public class Vis
    extends JPanel
    implements MouseListener,
    WindowListener,
    MouseMotionListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Dimension dimension = this.getVisDimension();
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(new Color(0xDDDDDD));
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            graphics2D.translate(SZ / 2, SZ / 2);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, CakeSharingVis.this.W * SZ, CakeSharingVis.this.H * SZ);
            graphics2D.setBackground(Color.WHITE);
            Object object = CakeSharingVis.this.lock;
            synchronized (object) {
                int n;
                int n2;
                int n3;
                int n4;
                Serializable serializable;
                int n5;
                if (showColors && !plain) {
                    for (n5 = 0; n5 < CakeSharingVis.this.pieces.size(); ++n5) {
                        serializable = CakeSharingVis.this.polygons.get(n5);
                        graphics2D.setColor(CakeSharingVis.this.pieceColors[n5]);
                        graphics2D.fillPolygon((Polygon)serializable);
                    }
                }
                if (showColors && plain) {
                    Color color = new Color(230, 250, 230);
                    serializable = new Color(250, 230, 230);
                    for (n4 = 0; n4 < CakeSharingVis.this.H; ++n4) {
                        for (n3 = 0; n3 < CakeSharingVis.this.W; ++n3) {
                            if (CakeSharingVis.this.roses[n4][n3] == '.') continue;
                            int n6 = n3 * SZ;
                            n2 = n4 * SZ;
                            graphics2D.setColor((Color)(CakeSharingVis.this.roses[n4][n3] == 'R' ? color : serializable));
                            graphics2D.fillRect(n6 + 1, n2 + 1, SZ - 1, SZ - 1);
                        }
                    }
                }
                graphics2D.setStroke(new BasicStroke(1.0f));
                graphics2D.setColor(Color.LIGHT_GRAY);
                for (n5 = 1; n5 < CakeSharingVis.this.H; ++n5) {
                    graphics2D.drawLine(0, n5 * SZ, CakeSharingVis.this.W * SZ, n5 * SZ);
                }
                for (n5 = 1; n5 < CakeSharingVis.this.W; ++n5) {
                    graphics2D.drawLine(n5 * SZ, 0, n5 * SZ, CakeSharingVis.this.H * SZ);
                }
                if (showPoints) {
                    n5 = Math.min(Math.max(4, res * 2 / 3), SZ / 2);
                    graphics2D.setStroke(new BasicStroke(1.0f));
                    graphics2D.setColor(Color.BLUE);
                    for (int i = 0; i < CakeSharingVis.this.pieces.size(); ++i) {
                        ArrayList<Point> arrayList = CakeSharingVis.this.pieces.get(i);
                        for (n3 = 0; n3 < arrayList.size() - 1; ++n3) {
                            Point point = arrayList.get(n3);
                            if (CakeSharingVis.this.pStart != null && point.equals(CakeSharingVis.this.pStart)) {
                                graphics2D.fillOval(point.x * SZ - n5 / 2, point.y * SZ - n5 / 2, n5, n5);
                                continue;
                            }
                            graphics2D.drawOval(point.x * SZ - n5 / 2, point.y * SZ - n5 / 2, n5, n5);
                        }
                    }
                }
                graphics2D.setStroke(new BasicStroke(SZ > 50 ? 2.0f : 1.0f));
                Color color = new Color(240, 240, 240);
                for (n = 0; n < CakeSharingVis.this.H; ++n) {
                    for (n4 = 0; n4 < CakeSharingVis.this.W; ++n4) {
                        if (CakeSharingVis.this.roses[n][n4] == '.') continue;
                        n3 = n4 * SZ + SZ / 2;
                        int n7 = n * SZ + SZ / 2;
                        n2 = Math.max(4, SZ / 5);
                        if (plain) {
                            graphics2D.setColor(CakeSharingVis.this.roses[n][n4] == 'R' ? Color.BLACK : Color.LIGHT_GRAY);
                            graphics2D.fillOval(n3 - n2 / 2, n7 - n2 / 2, n2, n2);
                            continue;
                        }
                        if (showColors) {
                            graphics2D.setColor(CakeSharingVis.this.roses[n][n4] == 'R' ? CakeSharingVis.this.roseColors[CakeSharingVis.this.rosesPiecesIdx[n][n4]] : color);
                            graphics2D.fillOval(n3 - n2 / 2 - n2, n7 - n2 / 2, n2, n2);
                            graphics2D.fillOval(n3 - n2 / 2, n7 - n2 / 2 - n2, n2, n2);
                            graphics2D.fillOval(n3 - n2 / 2 + n2, n7 - n2 / 2, n2, n2);
                            graphics2D.fillOval(n3 - n2 / 2, n7 - n2 / 2 + n2, n2, n2);
                            graphics2D.fillOval(n3 - n2 / 2, n7 - n2 / 2, n2, n2);
                        }
                        graphics2D.setColor(CakeSharingVis.this.roses[n][n4] == 'R' ? Color.BLACK : Color.LIGHT_GRAY);
                        graphics2D.drawOval(n3 - n2 / 2 - n2, n7 - n2 / 2, n2, n2);
                        graphics2D.drawOval(n3 - n2 / 2, n7 - n2 / 2 - n2, n2, n2);
                        graphics2D.drawOval(n3 - n2 / 2 + n2, n7 - n2 / 2, n2, n2);
                        graphics2D.drawOval(n3 - n2 / 2, n7 - n2 / 2 + n2, n2, n2);
                        graphics2D.drawOval(n3 - n2 / 2, n7 - n2 / 2, n2, n2);
                        graphics2D.fillOval(n3 - n2 / 4, n7 - n2 / 4, n2 / 2, n2 / 2);
                    }
                }
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawLine(0, 0, CakeSharingVis.this.W * SZ, 0);
                graphics2D.drawLine(0, CakeSharingVis.this.H * SZ, CakeSharingVis.this.W * SZ, CakeSharingVis.this.H * SZ);
                graphics2D.drawLine(CakeSharingVis.this.W * SZ, 0, CakeSharingVis.this.W * SZ, CakeSharingVis.this.H * SZ);
                graphics2D.drawLine(0, 0, 0, CakeSharingVis.this.H * SZ);
                for (n = 0; n < CakeSharingVis.this.cuts.size(); ++n) {
                    Cut cut = CakeSharingVis.this.cuts.get(n);
                    graphics2D.drawLine(cut.start.x * SZ, cut.start.y * SZ, cut.end.x * SZ, cut.end.y * SZ);
                }
                if (showValues) {
                    graphics2D.setFont(new Font("Arial", 1, res + 1));
                    graphics2D.setColor(new Color(17629));
                    for (n = 0; n < CakeSharingVis.this.pieces.size(); ++n) {
                        Point point = CakeSharingVis.this.centers.get(n);
                        this.drawString(graphics2D, String.format("%.1f", CakeSharingVis.this.areas.get(n)), point.x - 10, point.y - res * 2 / 3, 20, 10, 0, true);
                        this.drawString(graphics2D, String.format("%d", CakeSharingVis.this.rosesInside.get(n)), point.x - 10, point.y + res / 2, 20, 10, 0, true);
                    }
                }
                if (CakeSharingVis.this.pStart != null && CakeSharingVis.this.pMoving != null) {
                    graphics2D.setColor(new Color(0, 0, 255, 100));
                    graphics2D.drawLine(CakeSharingVis.this.pStart.x * SZ, CakeSharingVis.this.pStart.y * SZ, CakeSharingVis.this.pMoving.x, CakeSharingVis.this.pMoving.y);
                }
                graphics2D.setFont(new Font("Arial", 1, 13));
                graphics2D.setStroke(new BasicStroke(1.0f));
                graphics2D.setColor(Color.BLACK);
                n = SZ * CakeSharingVis.this.W + 10;
                n4 = 100;
                n3 = 10;
                int n8 = 30;
                n2 = 20;
                int n9 = 10;
                if (CakeSharingVis.this.manualReady) {
                    graphics2D.clearRect(n, n3, n4, n8);
                }
                this.drawString(graphics2D, "READY", n, n3, n4, n8, 0);
                graphics2D.drawRect(n, n3, n4, n8);
                n3 += n8 + n9;
                if (plain) {
                    graphics2D.clearRect(n, n3, n4, n8);
                }
                this.drawString(graphics2D, "PLAIN", n, n3, n4, n8, 0);
                graphics2D.drawRect(n, n3, n4, n8);
                n3 += n8 + n9;
                if (showPoints) {
                    graphics2D.clearRect(n, n3, n4, n8);
                }
                this.drawString(graphics2D, "POINTS", n, n3, n4, n8, 0);
                graphics2D.drawRect(n, n3, n4, n8);
                n3 += n8 + n9;
                if (showColors) {
                    graphics2D.clearRect(n, n3, n4, n8);
                }
                this.drawString(graphics2D, "COLOR", n, n3, n4, n8, 0);
                graphics2D.drawRect(n, n3, n4, n8);
                n3 += n8 + n9;
                if (showValues) {
                    graphics2D.clearRect(n, n3, n4, n8);
                }
                this.drawString(graphics2D, "VALUES", n, n3, n4, n8, 0);
                graphics2D.drawRect(n, n3, n4, n8);
                graphics2D.setColor(!manual || CakeSharingVis.this.manualReady || CakeSharingVis.this.cuts.isEmpty() ? Color.LIGHT_GRAY : Color.BLACK);
                this.drawString(graphics2D, "UNDO", n, n3 += n8 + n9, n4, n8, 0);
                graphics2D.drawRect(n, n3, n4, n8);
                graphics2D.setColor(!manual || CakeSharingVis.this.manualReady || CakeSharingVis.this.redos.isEmpty() ? Color.LIGHT_GRAY : Color.BLACK);
                this.drawString(graphics2D, "REDO", n, n3 += n8 + n9, n4, n8, 0);
                graphics2D.drawRect(n, n3, n4, n8);
                graphics2D.setColor(!manual || CakeSharingVis.this.manualReady || CakeSharingVis.this.cuts.isEmpty() ? Color.LIGHT_GRAY : Color.BLACK);
                this.drawString(graphics2D, "CLEAR", n, n3 += n8 + n9, n4, n8, 0);
                graphics2D.drawRect(n, n3, n4, n8);
                n3 += n8 + n9;
                graphics2D.setColor(Color.BLACK);
                this.drawString(graphics2D, "SCORE", n, n3 += n2, n4, n2, 0);
                n3 += n2;
                if (CakeSharingVis.this.pieces.size() != CakeSharingVis.this.N) {
                    graphics2D.setColor(Color.RED);
                }
                this.drawString(graphics2D, String.format("%.3f", CakeSharingVis.this.score), n, n3, n4, n2, 0);
                graphics2D.setColor(Color.BLACK);
                this.drawString(graphics2D, "PIECES", n, n3 += n2 * 2, n4, n2, 0);
                this.drawString(graphics2D, CakeSharingVis.this.pieces.size() + " / " + CakeSharingVis.this.N, n, n3 += n2, n4, n2, 0);
                n3 += n2 * 2;
            }
            if (save) {
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", new File(seed + ".png"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            graphics.drawImage(bufferedImage, 0, 0, null);
        }

        void drawString(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4, int n5) {
            this.drawString(graphics2D, string, n, n2, n3, n4, n5, false);
        }

        void drawString(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4, int n5, boolean bl) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
            int n6 = (int)rectangle2D.getHeight();
            int n7 = (int)rectangle2D.getWidth();
            if (n5 == 0) {
                n += (n3 - n7) / 2;
            } else if (n5 > 0) {
                n = n + n3 - n7;
            }
            if (bl) {
                Color color = graphics2D.getColor();
                graphics2D.setColor(new Color(255, 255, 255, 120));
                graphics2D.fillRect(n - 1, n2 - n6 / 3 - 1, n7 + 2, n6 + 2);
                graphics2D.setColor(color);
            }
            n2 = n2 + (n4 - n6) / 2 + fontMetrics.getAscent();
            graphics2D.drawString(string, n, n2);
        }

        public Vis() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            CakeSharingVis.this.jf.addWindowListener(this);
        }

        public Dimension getVisDimension() {
            return new Dimension(CakeSharingVis.this.W * SZ + SZ / 2 + 126, Math.max((CakeSharingVis.this.H + 1) * SZ + 1, 550));
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() - SZ / 2 - SZ * CakeSharingVis.this.W - 10;
            int n2 = mouseEvent.getY() - 10 - SZ / 2;
            int n3 = n2 / 40;
            if (n < 0 || n > 100 || n2 < 0 || n2 % 40 > 30) {
                n3 = -1;
            }
            if (n3 == 1) {
                plain = !plain;
                this.repaint();
                return;
            }
            if (n3 == 2) {
                showPoints = !showPoints;
                this.repaint();
                return;
            }
            if (n3 == 3) {
                showColors = !showColors;
                this.repaint();
                return;
            }
            if (n3 == 4) {
                showValues = !showValues;
                this.repaint();
                return;
            }
            if (!manual || CakeSharingVis.this.manualReady) {
                return;
            }
            if (n3 == 0) {
                CakeSharingVis.this.manualReady = true;
                this.repaint();
                return;
            }
            if (n3 == 5) {
                if (CakeSharingVis.this.cuts.isEmpty()) {
                    return;
                }
                CakeSharingVis.this.redos.add(0, CakeSharingVis.this.cuts.remove(CakeSharingVis.this.cuts.size() - 1));
                ArrayList<Cut> arrayList = new ArrayList<Cut>(CakeSharingVis.this.cuts);
                CakeSharingVis.this.initBoard();
                for (Cut cut : arrayList) {
                    CakeSharingVis.this.makeCut(cut.start, cut.end);
                }
                this.repaint();
                return;
            }
            if (n3 == 6) {
                if (CakeSharingVis.this.redos.isEmpty()) {
                    return;
                }
                Cut cut = CakeSharingVis.this.redos.remove(0);
                CakeSharingVis.this.makeCut(cut.start, cut.end);
                this.repaint();
                return;
            }
            if (n3 == 7) {
                if (CakeSharingVis.this.cuts.isEmpty()) {
                    return;
                }
                CakeSharingVis.this.redos.addAll(0, CakeSharingVis.this.cuts);
                CakeSharingVis.this.initBoard();
                this.repaint();
                return;
            }
            int n4 = mouseEvent.getY() / SZ;
            int n5 = mouseEvent.getX() / SZ;
            Point point = new Point(n5, n4);
            if (!CakeSharingVis.this.isInside(point) || SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (CakeSharingVis.this.pStart != null) {
                    CakeSharingVis.this.pMoving = null;
                    CakeSharingVis.this.pStart = null;
                    this.repaint();
                }
                return;
            }
            if (CakeSharingVis.this.pStart == null) {
                if (CakeSharingVis.this.pieces.size() >= CakeSharingVis.this.N) {
                    if (debug) {
                        System.out.println("Enough pieces already");
                    }
                    return;
                }
                if (!CakeSharingVis.this.isValidEndPoint(point)) {
                    if (debug) {
                        System.out.println("Invalid start at " + point);
                    }
                    return;
                }
                CakeSharingVis.this.pStart = point;
                CakeSharingVis.this.pMoving = null;
                this.repaint();
                if (debug) {
                    System.out.println("Starting a cut at " + point);
                }
                return;
            }
            if (debug) {
                System.out.println("Attempting a cut to " + point);
            }
            String string = CakeSharingVis.this.makeCut(CakeSharingVis.this.pStart, point);
            CakeSharingVis.this.pMoving = null;
            CakeSharingVis.this.pStart = null;
            this.repaint();
            if (!string.equals("")) {
                CakeSharingVis.this.addFatalError(string);
                return;
            }
            CakeSharingVis.this.redos.clear();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (CakeSharingVis.this.pStart != null) {
                CakeSharingVis.this.pMoving = new Point(mouseEvent.getX() - SZ / 2, mouseEvent.getY() - SZ / 2);
                this.repaint();
            }
        }
    }
}

