/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Random;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BookSelectionVis {
    static final int WD = 10;
    static final int HD = 1;
    Random r;
    int H;
    int W;
    int X;
    int[] hs;
    int[] ws;
    int[] vs;
    int[] maxes;
    int[] totw;
    int[] ret;
    Vis v;
    static String exec;
    static boolean vis;
    static boolean save;
    static Process proc;
    static String seed1;
    InputStream is;
    OutputStream os;
    JFrame jf;

    public void generate(String string) {
        try {
            this.r = SecureRandom.getInstance("SHA1PRNG");
            this.r.setSeed(Long.parseLong(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d = this.r.nextDouble() * 30.0 + 10.0;
        double d2 = this.r.nextDouble() * 150.0 + 50.0;
        this.H = this.r.nextInt(961) + 240;
        this.W = this.r.nextInt(3601) + 2400;
        this.X = this.r.nextInt(3 * this.H * this.W / 16000 - this.H * this.W / 16000 + 1) + this.H * this.W / 16000;
        this.hs = new int[this.X];
        this.ws = new int[this.X];
        this.vs = new int[this.X];
        for (int i = 0; i < this.X; ++i) {
            this.hs[i] = Math.max(1, (int)Math.round(this.r.nextGaussian() * d + 80.0));
            this.ws[i] = Math.max(1, (int)Math.round(this.r.nextGaussian() * d2 + 200.0));
            this.vs[i] = Math.max(1, (int)Math.round((double)(this.hs[i] * this.ws[i]) * (this.r.nextGaussian() * 0.001 + 0.001)));
        }
    }

    public BookSelectionVis(String string) {
        this.generate(string);
        if (vis) {
            this.jf = new JFrame();
            this.v = new Vis();
            this.jf.getContentPane().add(this.v);
        }
        if (exec != null) {
            try {
                Runtime runtime = Runtime.getRuntime();
                proc = runtime.exec(exec);
                this.os = proc.getOutputStream();
                this.is = proc.getInputStream();
                new ErrorReader(proc.getErrorStream()).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("Score = " + this.runTest());
    }

    public double runTest() {
        int n;
        try {
            this.ret = this.go();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1.0;
        }
        if (this.ret == null) {
            System.err.println("Got null");
            return 0.0;
        }
        if (this.ret.length != this.X) {
            System.err.println("Your return contained the wrong number of elements.  Expected " + this.X + ", got " + this.ret.length + ".");
            return 0.0;
        }
        this.maxes = new int[this.X];
        this.totw = new int[this.X];
        int n2 = 0;
        for (n = 0; n < this.X; ++n) {
            if (this.ret[n] == -1) continue;
            if (this.ret[n] >= this.X || this.ret[n] < -1) {
                System.err.println("Your return contained an invalid book index: " + this.ret[n]);
                return 0.0;
            }
            if (this.hs[n] > this.maxes[this.ret[n]]) {
                this.maxes[this.ret[n]] = this.hs[n];
            }
            int n3 = this.ret[n];
            this.totw[n3] = this.totw[n3] + this.ws[n];
            n2 += this.vs[n];
        }
        n = 0;
        for (int i = 0; i < this.X; ++i) {
            if (this.totw[i] > this.W) {
                System.err.println("The books on shelf " + i + " are too wide!  Allowed width is " + this.W + ", your width is " + this.totw[i] + ".");
                return 0.0;
            }
            if (this.maxes[i] <= 0) continue;
            n += this.maxes[i] + 10;
        }
        if (n > this.H) {
            System.err.println("The books are too tall!  Allowed height is " + this.H + ", your height is " + n + ".");
            return 0.0;
        }
        System.err.println("INFO : total height = " + n + ", value = " + n2);
        if (vis) {
            this.jf.setSize(this.W / 10 + 40, this.H / 1 + 60);
            this.v.repaint();
            this.jf.setVisible(true);
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        String string = "1";
        vis = true;
        save = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
            }
            if (stringArray[i].equals("-exec")) {
                exec = stringArray[++i];
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
            }
            if (!stringArray[i].equals("-save")) continue;
            save = true;
        }
        if (save) {
            vis = true;
        }
        BookSelectionVis bookSelectionVis = new BookSelectionVis(string);
    }

    int[] go() throws IOException {
        int n;
        if (exec == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.H).append('\n');
        stringBuffer.append(this.W).append('\n');
        stringBuffer.append(this.X).append('\n');
        stringBuffer.append(this.hs[0]);
        for (n = 1; n < this.X; ++n) {
            stringBuffer.append(' ').append(this.hs[n]);
        }
        stringBuffer.append('\n');
        stringBuffer.append(this.ws[0]);
        for (n = 1; n < this.X; ++n) {
            stringBuffer.append(' ').append(this.ws[n]);
        }
        stringBuffer.append('\n');
        stringBuffer.append(this.vs[0]);
        for (n = 1; n < this.X; ++n) {
            stringBuffer.append(' ').append(this.vs[n]);
        }
        stringBuffer.append('\n');
        this.os.write(stringBuffer.toString().getBytes());
        this.os.flush();
        Scanner scanner = new Scanner(this.is);
        int[] nArray = new int[this.X];
        for (n = 0; n < this.X; ++n) {
            nArray[n] = scanner.nextInt();
        }
        return nArray;
    }

    public class Vis
    extends JPanel
    implements WindowListener {
        public void paint(Graphics graphics) {
            try {
                BufferedImage bufferedImage = new BufferedImage(BookSelectionVis.this.W / 10 + 2, BookSelectionVis.this.H / 1, 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                int n = 0;
                if (BookSelectionVis.this.maxes != null) {
                    int n2;
                    graphics2D.setColor(new Color(255, 255, 128));
                    graphics2D.fillRect(0, 0, BookSelectionVis.this.W / 10 + 2, BookSelectionVis.this.H / 1);
                    int[] nArray = new int[BookSelectionVis.this.X];
                    int[] nArray2 = new int[BookSelectionVis.this.X];
                    int[] nArray3 = new int[BookSelectionVis.this.X];
                    for (int i = 0; i < BookSelectionVis.this.maxes.length; ++i) {
                        if (BookSelectionVis.this.maxes[i] != 0) {
                            nArray[i] = n;
                            n += BookSelectionVis.this.maxes[i] + 10;
                        }
                        nArray2[i] = 1;
                    }
                    Color color = new Color(128, 0, 0);
                    Color color2 = new Color(0, 0, 128);
                    for (n2 = 0; n2 < BookSelectionVis.this.X; ++n2) {
                        if (BookSelectionVis.this.ret[n2] == -1) continue;
                        if (nArray3[BookSelectionVis.this.ret[n2]] % 2 == 0) {
                            graphics2D.setColor(color);
                        } else {
                            graphics2D.setColor(color2);
                        }
                        int n3 = Math.max(1, (BookSelectionVis.this.ws[n2] + 5) / 10);
                        int n4 = (BookSelectionVis.this.hs[n2] + 0) / 1;
                        graphics2D.fillRect(nArray2[BookSelectionVis.this.ret[n2]], BookSelectionVis.this.H / 1 - (10 + nArray[BookSelectionVis.this.ret[n2]]) / 1 - n4, n3, n4);
                        int n5 = BookSelectionVis.this.ret[n2];
                        nArray2[n5] = nArray2[n5] + n3;
                        int n6 = BookSelectionVis.this.ret[n2];
                        nArray3[n6] = nArray3[n6] + 1;
                    }
                    graphics2D.setColor(Color.black);
                    graphics2D.fillRect(0, 0, 1, BookSelectionVis.this.H / 1);
                    graphics2D.fillRect(BookSelectionVis.this.W / 10 + 1, 0, 1, BookSelectionVis.this.H / 1);
                    for (n2 = 0; n2 < BookSelectionVis.this.maxes.length; ++n2) {
                        if (BookSelectionVis.this.maxes[n2] == 0) continue;
                        graphics2D.fillRect(0, BookSelectionVis.this.H / 1 - (10 + nArray[n2]) / 1, BookSelectionVis.this.W / 10 + 2, 10);
                    }
                }
                graphics.drawImage(bufferedImage, 10, 10, null);
                if (save) {
                    ImageIO.write((RenderedImage)bufferedImage, "png", new File(seed1 + ".png"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Vis() {
            BookSelectionVis.this.jf.addWindowListener(this);
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.exit(0);
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }
    }
}

