/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

class World {
    final Object worldLock = new Object();
    TestCase tc;
    int curStep = -1;
    List<Troop> troops = new ArrayList<Troop>();
    double playerScore = 0.0;
    long totalUnits;
    long[] playersUnits;
    boolean simComplete = false;

    World(TestCase testCase) {
        this.tc = testCase;
    }

    void updateScore() {
        this.totalUnits = 0L;
        this.playersUnits = new long[this.tc.NOpp + 1];
        for (int i = 0; i < this.tc.B; ++i) {
            this.totalUnits += (long)this.tc.bases[i].size;
            int n = this.tc.bases[i].owner;
            this.playersUnits[n] = this.playersUnits[n] + (long)this.tc.bases[i].size;
        }
        for (Troop troop : this.troops) {
            this.totalUnits += (long)troop.size;
            int n = troop.owner;
            this.playersUnits[n] = this.playersUnits[n] + (long)troop.size;
        }
        if (this.totalUnits > 0L) {
            this.playerScore += (double)this.playersUnits[0] * 1.0 / (double)this.totalUnits;
        }
        if (this.playersUnits[0] == this.totalUnits || this.playersUnits[0] == 0L) {
            this.simComplete = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTroopDepartures(int n, int[] nArray) {
        Object object = this.worldLock;
        synchronized (object) {
            String string = "WARNING: time step = " + this.curStep + ". ";
            for (int i = 0; i < nArray.length / 2; ++i) {
                int n2 = nArray[2 * i];
                int n3 = nArray[2 * i + 1];
                if (n2 < 0 || n2 >= this.tc.B || n3 < 0 || n3 >= this.tc.B) {
                    if (n != 0) continue;
                    System.err.println(string + "Invalid base index in troop sending attempt " + i + ", ignoring.");
                    continue;
                }
                if (this.tc.bases[n2].owner != n) {
                    if (n != 0) continue;
                    System.err.println(string + "Base not owned by you in troop sending attempt " + i + ", ignoring.");
                    continue;
                }
                if (n2 == n3) {
                    if (n != 0) continue;
                    System.err.println(string + "Sending troop from the base to itself in troop sending attempt " + i + ", ignoring.");
                    continue;
                }
                if (this.tc.bases[n2].size < 2) {
                    if (n != 0) continue;
                    System.err.println(string + "Source base has less than 2 units in troop sending attempt " + i + ", ignoring.");
                    continue;
                }
                Troop troop = new Troop();
                troop.owner = n;
                troop.size = this.tc.bases[n2].size / 2;
                troop.x = this.tc.bases[n2].x;
                troop.y = this.tc.bases[n2].y;
                troop.sourceId = n2;
                troop.targetId = n3;
                troop.depTime = this.curStep;
                int n4 = (int)Math.ceil(Math.sqrt(Math.pow(troop.x - this.tc.bases[n3].x, 2.0) + Math.pow(troop.y - this.tc.bases[n3].y, 2.0)) / (double)this.tc.speed);
                troop.arrivalTime = troop.depTime + n4;
                this.troops.add(troop);
                this.tc.bases[n2].size -= troop.size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTroopArrivals() {
        Object object = this.worldLock;
        synchronized (object) {
            int n = 0;
            while (n < this.troops.size()) {
                if (this.troops.get((int)n).arrivalTime != this.curStep) {
                    ++n;
                    continue;
                }
                int n2 = this.troops.get((int)n).owner;
                int n3 = this.troops.get((int)n).size;
                int n4 = this.troops.get((int)n).targetId;
                if (n2 == this.tc.bases[n4].owner) {
                    this.tc.bases[n4].size += n3;
                } else {
                    double d = (double)this.tc.bases[n4].size * this.tc.powers[this.tc.bases[n4].owner];
                    double d2 = (double)n3 * this.tc.powers[n2];
                    if (d >= d2) {
                        this.tc.bases[n4].size = Math.max(0, this.tc.bases[n4].size - (int)Math.ceil(d2 / this.tc.powers[this.tc.bases[n4].owner]));
                    } else {
                        this.tc.bases[n4].size = Math.max(0, n3 - (int)Math.ceil(d / this.tc.powers[n2]));
                        this.tc.bases[n4].owner = n2;
                    }
                }
                if (this.tc.bases[n4].size > 1000) {
                    this.tc.bases[n4].size = 1000;
                }
                this.troops.remove(n);
            }
        }
    }

    void startNewStep() {
        ++this.curStep;
        for (int i = 0; i < this.tc.B; ++i) {
            if (this.tc.bases[i].size > 0) {
                this.tc.bases[i].size += this.tc.bases[i].growthRate + this.tc.bases[i].size / 100;
            }
            if (this.tc.bases[i].size <= 1000) continue;
            this.tc.bases[i].size = 1000;
        }
        for (Troop troop : this.troops) {
            if (troop.arrivalTime == this.curStep) {
                troop.x = this.tc.bases[troop.targetId].x;
                troop.y = this.tc.bases[troop.targetId].y;
                continue;
            }
            double d = (double)(this.curStep - troop.depTime) * 1.0 / (double)(troop.arrivalTime - troop.depTime);
            double d2 = (double)this.tc.bases[troop.sourceId].x + (double)(this.tc.bases[troop.targetId].x - this.tc.bases[troop.sourceId].x) * d;
            double d3 = (double)this.tc.bases[troop.sourceId].y + (double)(this.tc.bases[troop.targetId].y - this.tc.bases[troop.sourceId].y) * d;
            troop.x = (int)d2;
            troop.y = (int)d3;
        }
    }
}

