/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

class Drawer
extends JFrame {
    public static final int EXTRA_WIDTH = 250;
    public static final int EXTRA_HEIGHT = 100;
    public World world;
    public DrawerPanel panel;
    public int S;
    public int width;
    public int height;
    public boolean pauseMode = false;
    public boolean stepMode = false;
    final Object keyMutex = new Object();
    boolean keyPressed;

    static int getOwnerColor(int n) {
        int[] nArray = new int[]{0, 33022, 16646272, 16678912, 65152};
        return nArray[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPause() {
        Object object = this.keyMutex;
        synchronized (object) {
            if (!this.stepMode && !this.pauseMode) {
                return;
            }
            this.keyPressed = false;
            while (!this.keyPressed) {
                try {
                    this.keyMutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Drawer(World world) {
        this.panel = new DrawerPanel();
        this.getContentPane().add(this.panel);
        this.addWindowListener(new DrawerWindowListener());
        this.world = world;
        TestCase cfr_ignored_0 = world.tc;
        this.S = 600;
        this.width = this.S + 250;
        this.height = this.S + 100;
        this.addKeyListener(new DrawerKeyListener());
        this.setSize(this.width, this.height);
        this.setTitle("Visualizer tool for problem AbstractWars");
        this.setResizable(false);
        this.setVisible(true);
    }

    class DrawerWindowListener
    extends WindowAdapter {
        DrawerWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            AbstractWarsVis.stopSolution();
            System.exit(0);
        }
    }

    class DrawerPanel
    extends JPanel {
        DrawerPanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics) {
            Object object = Drawer.this.world.worldLock;
            synchronized (object) {
                int n;
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics.setColor(new Color(0xA0A0A0));
                graphics.fillRect(15, 15, Drawer.this.S + 1, Drawer.this.S + 1);
                graphics.setFont(new Font("Arial", 0, 11));
                for (int i = 0; i < Drawer.this.world.tc.B; ++i) {
                    int n2 = Drawer.getOwnerColor(Drawer.this.world.tc.bases[i].owner);
                    graphics.setColor(new Color(n2));
                    n = Drawer.this.world.tc.bases[i].x;
                    int n3 = Drawer.this.world.tc.bases[i].y;
                    graphics.fillRect(15 + n - 3, 15 + n3 - 3, 7, 7);
                    graphics.setColor(new Color(n2 / 2));
                    graphics.drawRect(15 + n - 3, 15 + n3 - 3, 7, 7);
                    graphics2D.drawString("" + Drawer.this.world.tc.bases[i].size, 15 + n + 1, 15 + n3);
                }
                graphics.setFont(new Font("Arial", 0, 10));
                for (Troop troop : Drawer.this.world.troops) {
                    n = Drawer.getOwnerColor(troop.owner);
                    graphics.setColor(new Color(n));
                    graphics.fillOval(15 + troop.x - 3, 15 + troop.y - 3, 7, 7);
                    graphics.setColor(new Color(n / 2));
                    graphics2D.drawString("" + troop.size, 15 + troop.x + 1, 15 + troop.y);
                }
                graphics.setFont(new Font("Arial", 1, 12));
                graphics.setColor(Color.BLACK);
                int n4 = 40 + Drawer.this.S;
                graphics2D.drawString("Speed = " + Drawer.this.world.tc.speed, n4, 30);
                graphics2D.drawString("Simulation step = " + Drawer.this.world.curStep, n4, 50);
                graphics2D.drawString(String.format("Score = %.4f", Drawer.this.world.playerScore), n4, 70);
                for (int i = 0; i <= Drawer.this.world.tc.NOpp; ++i) {
                    graphics2D.setColor(new Color(Drawer.getOwnerColor(i)));
                    graphics2D.drawString(String.format("#" + i + " (power %.2f) share %.4f", Drawer.this.world.tc.powers[i], (double)Drawer.this.world.playersUnits[i] * 1.0 / (double)Drawer.this.world.totalUnits), n4, 90 + 20 * i);
                }
            }
        }
    }

    class DrawerKeyListener
    extends KeyAdapter {
        DrawerKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object = Drawer.this.keyMutex;
            synchronized (object) {
                if (keyEvent.getKeyChar() == ' ') {
                    boolean bl = Drawer.this.pauseMode = !Drawer.this.pauseMode;
                }
                if (keyEvent.getKeyChar() == 's') {
                    Drawer.this.stepMode = !Drawer.this.stepMode;
                }
                Drawer.this.keyPressed = true;
                Drawer.this.keyMutex.notifyAll();
            }
        }
    }
}

