/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class AbstractWarsVis {
    static String execCommand = null;
    static boolean vis = true;
    static int delay = 100;
    static boolean startPaused = false;
    static Process solution;
    BufferedReader reader;
    PrintWriter writer;
    boolean useLazy = false;
    LazyAI lazy;
    RealAI[] realAIs;

    public AbstractWarsVis() {
        if (execCommand != null) {
            try {
                solution = Runtime.getRuntime().exec(execCommand);
                this.reader = new BufferedReader(new InputStreamReader(solution.getInputStream()));
                this.writer = new PrintWriter(solution.getOutputStream());
                new ErrorStreamRedirector(solution.getErrorStream()).start();
            }
            catch (Exception exception) {
                System.err.println("ERROR: Unable to execute your solution using the provided command: " + execCommand + "; using lazy AI instead.");
                this.useLazy = true;
            }
        } else {
            this.useLazy = true;
        }
        if (this.useLazy) {
            this.lazy = new LazyAI();
        }
    }

    int callInit(int n, int[] nArray, int n2) throws IOException {
        if (n > 0) {
            return this.realAIs[n - 1].init(nArray, n2);
        }
        if (this.useLazy) {
            return this.lazy.init(nArray, n2);
        }
        this.writer.println(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.writer.println(nArray[i]);
        }
        this.writer.println(n2);
        this.writer.flush();
        this.reader.readLine();
        return 0;
    }

    int[] callSendTroops(int n, int[] nArray, int[] nArray2) throws IOException {
        int n2;
        if (n > 0) {
            return this.realAIs[n - 1].sendTroops(nArray, nArray2);
        }
        if (this.useLazy) {
            return this.lazy.sendTroops(nArray, nArray2);
        }
        this.writer.println(nArray.length);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.writer.println(nArray[n2]);
        }
        this.writer.println(nArray2.length);
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            this.writer.println(nArray2[n2]);
        }
        this.writer.flush();
        n2 = Integer.parseInt(this.reader.readLine());
        int[] nArray3 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray3[i] = Integer.parseInt(this.reader.readLine());
        }
        return nArray3;
    }

    public double runTest(String string) {
        int n;
        TestCase testCase = new TestCase(string);
        this.realAIs = new RealAI[testCase.NOpp];
        for (int i = 1; i <= testCase.NOpp; ++i) {
            this.realAIs[i - 1] = new RealAI(Long.parseLong(string + "" + i), i);
        }
        int[] nArray = new int[testCase.B * 2];
        for (n = 0; n < testCase.B; ++n) {
            nArray[2 * n] = testCase.bases[n].x;
            nArray[2 * n + 1] = testCase.bases[n].y;
        }
        try {
            this.callInit(0, nArray, testCase.speed);
        }
        catch (Exception exception) {
            System.err.println("ERROR: calling init failed for your solution: " + exception);
            return -1.0;
        }
        for (n = 1; n <= testCase.NOpp; ++n) {
            try {
                this.callInit(n, nArray, testCase.speed);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Opponent " + n + " threw exception in init: " + exception);
            }
        }
        World world = new World(testCase);
        Drawer drawer = null;
        if (vis) {
            drawer = new Drawer(world);
            if (startPaused) {
                drawer.pauseMode = true;
            }
        }
        int n2 = 0;
        while (true) {
            if (n2 >= 2000) break;
            world.startNewStep();
            world.updateTroopArrivals();
            int[] nArray2 = new int[testCase.B * 2];
            for (int i = 0; i < testCase.B; ++i) {
                nArray2[2 * i] = testCase.bases[i].owner;
                nArray2[2 * i + 1] = testCase.bases[i].size;
            }
            int[] nArray3 = new int[world.troops.size() * 4];
            int n3 = 0;
            for (Troop troop : world.troops) {
                nArray3[n3++] = troop.owner;
                nArray3[n3++] = troop.size;
                nArray3[n3++] = troop.x;
                nArray3[n3++] = troop.y;
            }
            String string2 = "ERROR: time step = " + n2 + ". ";
            for (int i = 0; i <= testCase.NOpp; ++i) {
                int[] nArray4;
                try {
                    nArray4 = this.callSendTroops(i, nArray2, nArray3);
                }
                catch (Exception exception) {
                    if (i > 0) {
                        System.err.println((String)string2 + "Opponent " + i + " threw exception in sendTroops: " + exception);
                        nArray4 = new int[]{};
                    }
                    System.err.println((String)string2 + "Unable to get return from sendTroops. " + exception);
                    return -1.0;
                }
                if (i == 0) {
                    int n4 = nArray4.length;
                    if (n4 % 2 > 0) {
                        System.err.println((String)string2 + "Return from sendTroops must have even length.");
                        return -1.0;
                    }
                    if ((n4 /= 2) > testCase.B) {
                        System.err.println((String)string2 + "You can send at most B troops on each step.");
                        return -1.0;
                    }
                }
                world.updateTroopDepartures(i, nArray4);
            }
            world.updateScore();
            if (vis) {
                drawer.processPause();
                drawer.repaint();
                try {
                    Thread.sleep(delay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (world.simComplete) {
                System.err.println("Simulation completed at step " + n2 + ".");
                world.playerScore += (double)((long)(2000 - n2 - 1) * world.playersUnits[0]) * 1.0 / (double)world.totalUnits;
                break;
            }
            ++n2;
        }
        AbstractWarsVis.stopSolution();
        return world.playerScore;
    }

    public static void stopSolution() {
        if (solution != null) {
            try {
                solution.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "1";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-exec")) {
                execCommand = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-seed")) {
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-novis")) {
                vis = false;
                continue;
            }
            if (stringArray[i].equals("-delay")) {
                delay = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-pause")) {
                startPaused = true;
                continue;
            }
            System.out.println("WARNING: unknown argument " + stringArray[i] + ".");
        }
        AbstractWarsVis abstractWarsVis = new AbstractWarsVis();
        try {
            double d = abstractWarsVis.runTest(string);
            System.out.println("Score = " + d);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("ERROR: Unexpected error while running your test case.");
            runtimeException.printStackTrace();
            AbstractWarsVis.stopSolution();
        }
    }
}

