/*
 * Decompiled with CFR 0.152.
 */
package popspack.processors;

import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.Renderer;
import com.topcoder.shared.problem.TestCase;
import java.util.HashMap;
import java.util.Map;
import popspack.Preferences;

public class PopsProcessor {
    private HashMap myTags = new HashMap();
    private static final String WRITERCODE = "$WRITERCODE$";
    private static final String MAIN = "$MAIN$";

    public String preProcess(String source, ProblemComponentModel component, Language language, Renderer renderer) {
        if (source.length() > 0 && !source.equals(component.getDefaultSolution())) {
            return source;
        }
        if (language.getId() != 1) {
            return "";
        }
        this.myTags.put(WRITERCODE, "");
        this.myTags.put(MAIN, "");
        if (!component.hasSignature()) {
            this.myTags.put(MAIN, "// Problem has no signature defined for it");
            return "";
        }
        TestCase[] testCases = component.getTestCases();
        if (testCases == null || testCases.length == 0) {
            this.myTags.put(MAIN, "// No test cases defined for this problem");
            return "";
        }
        this.myTags.clear();
        this.myTags.put(WRITERCODE, component.getDefaultSolution());
        StringBuffer mainMethod = new StringBuffer(5000);
        mainMethod.append("\tpublic static void main(String[] a) {\n");
        int x = 0;
        while (x < testCases.length) {
            mainMethod.append("\t\tnew ");
            mainMethod.append(component.getClassName());
            mainMethod.append("().runTestCase(");
            mainMethod.append(x);
            mainMethod.append(");\n");
            ++x;
        }
        mainMethod.append("\t}\n\n\tpublic void runTestCase(int nbr) {\n\t\tswitch(nbr) {\n");
        x = 0;
        while (x < testCases.length) {
            mainMethod.append("\t\t\tcase ");
            mainMethod.append(x);
            mainMethod.append(" : {\n");
            PopsProcessor.addTestCase(component, mainMethod, testCases[x], x);
            mainMethod.append(" break;\n\t\t\t}\n");
            ++x;
        }
        mainMethod.append("\t\t}\n\t}\n");
        mainMethod.append(PopsProcessor.addCompareMethods());
        Preferences pref = new Preferences("popspack.popscutter");
        String beginCut = pref.getStringProperty("begincut", "\n/** begin cut - don't modify this line*/\n");
        String endCut = pref.getStringProperty("endcut", "\n/** end cut - don't modify this line*/\n");
        mainMethod.insert(0, String.valueOf(beginCut) + "\n");
        mainMethod.append("\n" + endCut);
        this.myTags.put(MAIN, mainMethod.toString());
        return "";
    }

    private static final void addTestCase(ProblemComponentModel component, StringBuffer buf, TestCase testCase, int nbr) {
        DataType[] parms = component.getParamTypes();
        DataType rc = component.getReturnType();
        String[] inputs = testCase.getInput();
        String output = testCase.getOutput();
        if (parms.length != inputs.length) {
            System.out.println("Parms don't match inputs");
            return;
        }
        buf.append("\t\t\t\tcheckOutput(");
        buf.append(component.getMethodName());
        buf.append("(");
        int x = 0;
        while (x < parms.length) {
            PopsProcessor.decodeValue(buf, parms[x], inputs[x]);
            if (x < parms.length - 1) {
                buf.append(", ");
            }
            ++x;
        }
        buf.append("), ");
        PopsProcessor.decodeValue(buf, rc, output);
        buf.append(", ");
        buf.append(nbr);
        buf.append(");");
    }

    private static final void decodeValue(StringBuffer buf, DataType parm, String input) {
        if (parm.getDescription().endsWith("[]")) {
            buf.append("new ");
            buf.append(parm.getDescription());
            buf.append(" ");
            input = input.replace('\n', ' ');
            buf.append(input);
        } else {
            try {
                long inputL = Long.parseLong(input);
                buf.append(input);
                if (inputL > Integer.MAX_VALUE || inputL < Integer.MIN_VALUE) {
                    buf.append("L");
                }
            }
            catch (NumberFormatException e) {
                buf.append(input);
            }
        }
    }

    private static final String addCompareMethods() {
        StringBuffer f = new StringBuffer(1000);
        f.append("\tfinal void checkOutput(int mine, int them, int nbr) {\n");
        f.append("\t\tboolean success = (mine==them);\n");
        f.append("\t\tStringBuffer out = new StringBuffer();\n");
        f.append("\t\tout.append(\"Example \");\n");
        f.append("\t\tout.append((nbr+1));\n");
        f.append("\t\tout.append(\" - \");\n");
        f.append("\t\tout.append(success ? \"success\" : \"failure   \");\n");
        f.append("\t\tif(!success) {\n");
        f.append("\t\t\tout.append(\"Got: \");\n");
        f.append("\t\t\tout.append(mine);\n");
        f.append("\t\t\tout.append(\", Expected: \");\n");
        f.append("\t\t\tout.append(them);\n");
        f.append("\t\t}\n");
        f.append("\t\tSystem.out.println(out);\n");
        f.append("\t}\n");
        f.append("\tfinal void checkOutput(long mine, long them, int nbr) {\n");
        f.append("\t\tboolean success = (mine==them);\n");
        f.append("\t\tStringBuffer out = new StringBuffer();\n");
        f.append("\t\tout.append(\"Example \");\n");
        f.append("\t\tout.append((nbr+1));\n");
        f.append("\t\tout.append(\" - \");\n");
        f.append("\t\tout.append(success ? \"success\" : \"failure   \");\n");
        f.append("\t\tif(!success) {\n");
        f.append("\t\t\tout.append(\"Got: \");\n");
        f.append("\t\t\tout.append(mine);\n");
        f.append("\t\t\tout.append(\", Expected: \");\n");
        f.append("\t\t\tout.append(them);\n");
        f.append("\t\t}\n");
        f.append("\t\tSystem.out.println(out);\n");
        f.append("\t}\n");
        f.append("\tfinal void checkOutput(double mine, double them, int nbr) {\n");
        f.append("\t\tboolean success = doubleCompare(mine, them);\n");
        f.append("\t\tStringBuffer out = new StringBuffer();\n");
        f.append("\t\tout.append(\"Example \");\n");
        f.append("\t\tout.append((nbr+1));\n");
        f.append("\t\tout.append(\" - \");\n");
        f.append("\t\tout.append(success ? \"success\" : \"failure   \");\n");
        f.append("\t\tif(!success) {\n");
        f.append("\t\t\tout.append(\"Got: \");\n");
        f.append("\t\t\tout.append(mine);\n");
        f.append("\t\t\tout.append(\", Expected: \");\n");
        f.append("\t\t\tout.append(them);\n");
        f.append("\t\t}\n");
        f.append("\t\tSystem.out.println(out);\n");
        f.append("\t}\n");
        f.append("\tprivate static boolean doubleCompare(double expected, double result){\n");
        f.append("\t\tdouble MAX_DOUBLE_ERROR = 1E-9;\n");
        f.append("\t\tif(Double.isNaN(expected)){\n");
        f.append("\t\t\treturn Double.isNaN(result);\n");
        f.append("\t\t}else if(Double.isInfinite(expected)){\n");
        f.append("\t\t\tif(expected > 0){\n");
        f.append("\t\t\t\treturn result > 0 && Double.isInfinite(result);\n");
        f.append("\t\t\t}else{\n");
        f.append("\t\t\t\treturn result < 0 && Double.isInfinite(result);\n");
        f.append("\t\t\t}\n");
        f.append("\t\t}else if(Double.isNaN(result) || Double.isInfinite(result)){\n");
        f.append("\t\t\treturn false;\n");
        f.append("\t\t}else if(Math.abs(result - expected) < MAX_DOUBLE_ERROR){\n");
        f.append("\t\t\treturn true;\n");
        f.append("\t\t}else{\n");
        f.append("\t\t\tdouble min = Math.min(expected * (1.0 - MAX_DOUBLE_ERROR),\n");
        f.append("\t\t\t\texpected * (1.0 + MAX_DOUBLE_ERROR));\n");
        f.append("\t\t\tdouble max = Math.max(expected * (1.0 - MAX_DOUBLE_ERROR),\n");
        f.append("\t\t\t\t\texpected * (1.0 + MAX_DOUBLE_ERROR));\n");
        f.append("\t\t\treturn result > min && result < max;\n");
        f.append("\t\t}\n");
        f.append("\t}\n");
        f.append("\tfinal void checkOutput(char mine, char them, int nbr) {\n");
        f.append("\t\tboolean success = (mine==them);\n");
        f.append("\t\tStringBuffer out = new StringBuffer();\n");
        f.append("\t\tout.append(\"Example \");\n");
        f.append("\t\tout.append((nbr+1));\n");
        f.append("\t\tout.append(\" - \");\n");
        f.append("\t\tout.append(success ? \"success\" : \"failure   \");\n");
        f.append("\t\tif(!success) {\n");
        f.append("\t\t\tout.append(\"Got: \");\n");
        f.append("\t\t\tout.append(\"'\");\n");
        f.append("\t\t\tout.append(mine);\n");
        f.append("\t\t\tout.append(\"'\");\n");
        f.append("\t\t\tout.append(\", Expected: \");\n");
        f.append("\t\t\tout.append(\"'\");\n");
        f.append("\t\t\tout.append(them);\n");
        f.append("\t\t\tout.append(\"'\");\n");
        f.append("\t\t}\n");
        f.append("\t\tSystem.out.println(out);\n");
        f.append("\t}\n");
        f.append("\tfinal void checkOutput(String mine, String them, int nbr) {\n");
        f.append("\t\tboolean success = (mine.equals(them));\n");
        f.append("\t\tStringBuffer out = new StringBuffer();\n");
        f.append("\t\tout.append(\"Example \");\n");
        f.append("\t\tout.append((nbr+1));\n");
        f.append("\t\tout.append(\" - \");\n");
        f.append("\t\tout.append(success ? \"success\" : \"failure   \");\n");
        f.append("\t\tif(!success) {\n");
        f.append("\t\t\tout.append(\"Got: \");\n");
        f.append("\t\t\tout.append(\"\\\"\");\n");
        f.append("\t\t\tout.append(mine);\n");
        f.append("\t\t\tout.append(\"\\\"\");\n");
        f.append("\t\t\tout.append(\", Expected: \");\n");
        f.append("\t\t\tout.append(\"\\\"\");\n");
        f.append("\t\t\tout.append(them);\n");
        f.append("\t\t\tout.append(\"\\\"\");\n");
        f.append("\t\t}\n");
        f.append("\t\tSystem.out.println(out);\n");
        f.append("\t}\n");
        f.append("\tfinal void checkOutput(long[] mine, long[] them, int nbr) {\n");
        f.append("\t\tboolean success = (Arrays.equals(mine, them));\n");
        f.append("\t\tStringBuffer out = new StringBuffer();\n");
        f.append("\t\tout.append(\"Example \");\n");
        f.append("\t\tout.append((nbr+1));\n");
        f.append("\t\tout.append(\" - \");\n");
        f.append("\t\tout.append(success ? \"success\" : \"failure   \");\n");
        f.append("\t\tif(!success) {\n");
        f.append("\t\t\tout.append(\"Got: \");\n");
        f.append("\t\t\tout.append(\"{\");\n");
        f.append("\t\t\tfor(int x=0;x<mine.length;x++) {\n");
        f.append("\t\t\t\tout.append(mine[x]);\n");
        f.append("\t\t\t\tif(x<mine.length-1) out.append(\", \");\n");
        f.append("\t\t\t}\n");
        f.append("\t\t\tout.append(\"}\");\n");
        f.append("\t\t\tout.append(\", Expected: \");\n");
        f.append("\t\t\tout.append(\"{\");\n");
        f.append("\t\t\tfor(int x=0;x<them.length;x++) {\n");
        f.append("\t\t\t\tout.append(them[x]);\n");
        f.append("\t\t\t\tif(x<them.length-1) out.append(\", \");\n");
        f.append("\t\t\t}\n");
        f.append("\t\t\tout.append(\"}\");\n");
        f.append("\t\t}\n");
        f.append("\t\tSystem.out.println(out);\n");
        f.append("\t}\n");
        f.append("\tfinal void checkOutput(char[] mine, char[] them, int nbr) {\n");
        f.append("\t\tboolean success = (Arrays.equals(mine, them));\n");
        f.append("\t\tStringBuffer out = new StringBuffer();\n");
        f.append("\t\tout.append(\"Example \");\n");
        f.append("\t\tout.append((nbr+1));\n");
        f.append("\t\tout.append(\" - \");\n");
        f.append("\t\tout.append(success ? \"success\" : \"failure   \");\n");
        f.append("\t\tif(!success) {\n");
        f.append("\t\t\tout.append(\"Got: \");\n");
        f.append("\t\t\tout.append(\"{\");\n");
        f.append("\t\t\tfor(int x=0;x<mine.length;x++) {\n");
        f.append("\t\t\t\tout.append(mine[x]);\n");
        f.append("\t\t\t\tif(x<mine.length-1) out.append(\", \");\n");
        f.append("\t\t\t}\n");
        f.append("\t\t\tout.append(\"}\");\n");
        f.append("\t\t\tout.append(\", Expected: \");\n");
        f.append("\t\t\tout.append(\"{\");\n");
        f.append("\t\t\tfor(int x=0;x<them.length;x++) {\n");
        f.append("\t\t\t\tout.append(them[x]);\n");
        f.append("\t\t\t\tif(x<them.length-1) out.append(\", \");\n");
        f.append("\t\t\t}\n");
        f.append("\t\t\tout.append(\"}\");\n");
        f.append("\t\t}\n");
        f.append("\t\tSystem.out.println(out);\n");
        f.append("\t}\n");
        f.append("\tfinal void checkOutput(double[] mine, double[] them, int nbr) {\n");
        f.append("\t\tboolean success = (Arrays.equals(mine, them));\n");
        f.append("\t\tStringBuffer out = new StringBuffer();\n");
        f.append("\t\tout.append(\"Example \");\n");
        f.append("\t\tout.append((nbr+1));\n");
        f.append("\t\tout.append(\" - \");\n");
        f.append("\t\tout.append(success ? \"success\" : \"failure   \");\n");
        f.append("\t\tif(!success) {\n");
        f.append("\t\t\tout.append(\"Got: \");\n");
        f.append("\t\t\tout.append(\"{\");\n");
        f.append("\t\t\tfor(int x=0;x<mine.length;x++) {\n");
        f.append("\t\t\t\tout.append(mine[x]);\n");
        f.append("\t\t\t\tif(x<mine.length-1) out.append(\", \");\n");
        f.append("\t\t\t}\n");
        f.append("\t\t\tout.append(\"}\");\n");
        f.append("\t\t\tout.append(\", Expected: \");\n");
        f.append("\t\t\tout.append(\"{\");\n");
        f.append("\t\t\tfor(int x=0;x<them.length;x++) {\n");
        f.append("\t\t\t\tout.append(them[x]);\n");
        f.append("\t\t\t\tif(x<them.length-1) out.append(\", \");\n");
        f.append("\t\t\t}\n");
        f.append("\t\t\tout.append(\"}\");\n");
        f.append("\t\t}\n");
        f.append("\t\tSystem.out.println(out);\n");
        f.append("\t}\n");
        f.append("\tfinal void checkOutput(int[] mine, int[] them, int nbr) {\n");
        f.append("\t\tboolean success = (Arrays.equals(mine, them));\n");
        f.append("\t\tStringBuffer out = new StringBuffer();\n");
        f.append("\t\tout.append(\"Example \");\n");
        f.append("\t\tout.append((nbr+1));\n");
        f.append("\t\tout.append(\" - \");\n");
        f.append("\t\tout.append(success ? \"success\" : \"failure   \");\n");
        f.append("\t\tif(!success) {\n");
        f.append("\t\t\tout.append(\"Got: \");\n");
        f.append("\t\t\tout.append(\"{\");\n");
        f.append("\t\t\tfor(int x=0;x<mine.length;x++) {\n");
        f.append("\t\t\t\tout.append(mine[x]);\n");
        f.append("\t\t\t\tif(x<mine.length-1) out.append(\", \");\n");
        f.append("\t\t\t}\n");
        f.append("\t\t\tout.append(\"}\");\n");
        f.append("\t\t\tout.append(\", Expected: \");\n");
        f.append("\t\t\tout.append(\"{\");\n");
        f.append("\t\t\tfor(int x=0;x<them.length;x++) {\n");
        f.append("\t\t\t\tout.append(them[x]);\n");
        f.append("\t\t\t\tif(x<them.length-1) out.append(\", \");\n");
        f.append("\t\t\t}\n");
        f.append("\t\t\tout.append(\"}\");\n");
        f.append("\t\t}\n");
        f.append("\t\tSystem.out.println(out);\n");
        f.append("\t}\n");
        f.append("\tfinal void checkOutput(String[] mine, String[] them, int nbr) {\n");
        f.append("\t\tboolean success = (Arrays.equals(mine, them));\n");
        f.append("\t\tStringBuffer out = new StringBuffer();\n");
        f.append("\t\tout.append(\"Example \");\n");
        f.append("\t\tout.append((nbr+1));\n");
        f.append("\t\tout.append(\" - \");\n");
        f.append("\t\tout.append(success ? \"success\" : \"failure   \");\n");
        f.append("\t\tif(!success) {\n");
        f.append("\t\t\tout.append(\"Got: \");\n");
        f.append("\t\t\tout.append(\"{\");\n");
        f.append("\t\t\tfor(int x=0;x<mine.length;x++) {\n");
        f.append("\t\t\t\tout.append(mine[x]);\n");
        f.append("\t\t\t\tif(x<mine.length-1) out.append(\", \");\n");
        f.append("\t\t\t}\n");
        f.append("\t\t\tout.append(\"}\");\n");
        f.append("\t\t\tout.append(\", Expected: \");\n");
        f.append("\t\t\tout.append(\"{\");\n");
        f.append("\t\t\tfor(int x=0;x<them.length;x++) {\n");
        f.append("\t\t\t\tout.append(them[x]);\n");
        f.append("\t\t\t\tif(x<them.length-1) out.append(\", \");\n");
        f.append("\t\t\t}\n");
        f.append("\t\t\tout.append(\"}\");\n");
        f.append("\t\t}\n");
        f.append("\t\tSystem.out.println(out);\n");
        f.append("\t}\n");
        return f.toString();
    }

    public Map getUserDefinedTags() {
        return this.myTags;
    }
}

