/*
 * Decompiled with CFR 0.152.
 */
package popspack.processors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JTextField;
import popspack.Common;
import popspack.Preferences;
import popspack.config.AbstractConfigurationPanel;

public class PopsCutterConfig
extends AbstractConfigurationPanel
implements ItemListener {
    private JTextField endCut = Common.createJTextField(25);
    private JTextField beginCut = Common.createJTextField(25);

    public PopsCutterConfig(Preferences pref) {
        super(pref);
        this.beginCut.setText(pref.getStringProperty("begincut", "\n/** begin cut - don't modify this line*/\n"));
        this.endCut.setText(pref.getStringProperty("endcut", "\n/** end cut - don't modify this line*/\n"));
        this.beginCut.getDocument().addDocumentListener(this);
        this.endCut.getDocument().addDocumentListener(this);
        this.add((Component)Common.createJLabel("The beginning cut tag:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.beginCut, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("The ending cut tag:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.endCut, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel(""), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public String getTabTitle() {
        return "Cutting Tags";
    }

    public String getTabToolTip() {
        return "The cutting tags";
    }

    public boolean validatePreferences() {
        if (this.beginCut.getText().trim().length() == 0) {
            Common.showMessage("Error", "Please specify the text for the begin cut", this);
            this.beginCut.requestFocus();
            return false;
        }
        if (this.endCut.getText().trim().length() == 0) {
            Common.showMessage("Error", "Please specify the text for the end cut", this);
            this.endCut.requestFocus();
            return false;
        }
        return true;
    }

    public void savePreferences() {
        this.pref.setProperty("begincut", this.beginCut.getText());
        this.pref.setProperty("endcut", this.endCut.getText());
    }

    public void itemStateChanged(ItemEvent e) {
        this.savePending();
    }
}

