/*
 * Decompiled with CFR 0.152.
 */
package popspack.processors;

import com.topcoder.shared.language.Language;
import popspack.Preferences;
import popspack.config.ConfigurationDialog;
import popspack.config.ConfigurationInterface;
import popspack.processors.PopsCutterConfig;

public class PopsCutter {
    public static final String POPSCUTTERPREF = "popspack.popscutter";
    public static final String BEGINCUT = "begincut";
    public static final String ENDCUT = "endcut";
    public static final String BEGINCUTDEF = "\n/** begin cut - don't modify this line*/\n";
    public static final String ENDCUTDEF = "\n/** end cut - don't modify this line*/\n";

    public String postProcess(String source, Language language) {
        int start;
        Preferences pref = new Preferences(POPSCUTTERPREF);
        String beginCut = pref.getStringProperty(BEGINCUT, BEGINCUTDEF);
        String endCut = pref.getStringProperty(ENDCUT, ENDCUTDEF);
        StringBuffer buf = new StringBuffer(source);
        while ((start = buf.indexOf(beginCut)) >= 0) {
            int end = buf.indexOf(endCut);
            if (end < 0) {
                end = buf.length() - endCut.length();
            }
            if (end <= start) break;
            buf.delete(start, end + endCut.length());
        }
        return buf.toString();
    }

    public void configure() {
        Preferences pref = new Preferences(POPSCUTTERPREF);
        ConfigurationInterface[] inter = new ConfigurationInterface[]{new PopsCutterConfig(pref)};
        ConfigurationDialog dial = new ConfigurationDialog("PopsCutter Preferences", pref, inter);
        dial.show();
    }
}

