/*
 * Decompiled with CFR 0.152.
 */
package popspack.popstalk;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import popspack.Common;
import popspack.Preferences;
import popspack.config.AbstractConfigurationPanel;

public class TalkingEditorConfig
extends AbstractConfigurationPanel {
    public static final String NONE = "None";
    public static final String PROBLEM = "Problem Statement";
    public static final String CLASSDEF = "Class Definition";
    public static final String POINTS = "Points";
    public static final String CONSTRAINTS = "Constraints";
    public static final String TESTCASES = "Test Cases";
    public static final String PLAYATSTART = "playAtStart";
    private JComboBox playStart = Common.createComboBox(new String[]{"None", "Problem Statement", "Class Definition", "Constraints", "Test Cases", "Points"});

    public TalkingEditorConfig(Preferences pref) {
        super(pref);
        this.playStart.setSelectedItem(pref.getStringProperty(PLAYATSTART, PROBLEM));
        this.playStart.addActionListener(this);
        Common.setDefaultAttributes(this, new GridBagLayout());
        this.add((Component)Common.createJLabel("What to play when problem is opened:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.playStart, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel(""), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public String getTabTitle() {
        return "Settings";
    }

    public String getTabToolTip() {
        return "Settings for PopsTalk Editor";
    }

    public boolean validatePreferences() {
        String selected = (String)this.playStart.getSelectedItem();
        if (selected == null || selected.trim().length() == 0) {
            Common.showMessage("Error", "You must specify a value.", this);
            this.playStart.requestFocus();
            return false;
        }
        return true;
    }

    public void savePreferences() {
        this.pref.setProperty(PLAYATSTART, (String)this.playStart.getSelectedItem());
    }
}

