/*
 * Decompiled with CFR 0.152.
 */
package popspack.popstalk;

import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Constraint;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.ElementRenderer;
import com.topcoder.shared.problem.NodeElement;
import com.topcoder.shared.problem.Renderer;
import com.topcoder.shared.problem.TestCase;
import com.topcoder.shared.problem.TextElement;
import com.topcoder.shared.problem.UserConstraint;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.speech.AudioException;
import javax.speech.EngineException;
import javax.speech.EngineStateError;
import javax.speech.synthesis.SpeakableAdapter;
import javax.speech.synthesis.SpeakableEvent;
import javax.speech.synthesis.SpeakableListener;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.Voice;
import javax.swing.JButton;
import javax.swing.JPanel;
import popspack.Common;
import popspack.DynamicEditor;
import popspack.PopsSynthesizer;
import popspack.Preferences;
import popspack.config.ConfigEmbeddedEditor;
import popspack.config.ConfigSingleVoice;
import popspack.config.ConfigSynthesizer;
import popspack.config.ConfigurationDialog;
import popspack.config.ConfigurationInterface;
import popspack.popstalk.TalkingEditorConfig;

public class TalkingEditor
extends DynamicEditor
implements ActionListener {
    private String name = "";
    private Preferences pref = null;
    private Synthesizer synthesizer = null;
    private ProblemComponentModel prob = null;
    private Language lang = null;
    private Renderer rend = null;
    private JButton statement = Common.createJButton("Statement");
    private JButton source = Common.createJButton("Source");
    private JButton constraints = Common.createJButton("Constraints");
    private JButton methodDef = Common.createJButton("Method");
    private JButton testCases = Common.createJButton("TestCases");
    private JButton stop = Common.createJButton("Stop");
    private SpeakableHandler speakableHandler = new SpeakableHandler();

    public TalkingEditor() {
        this.statement.addActionListener(this);
        this.source.addActionListener(this);
        this.constraints.addActionListener(this);
        this.methodDef.addActionListener(this);
        this.testCases.addActionListener(this);
        this.stop.addActionListener(this);
        this.stop.setEnabled(false);
    }

    public void setName(String name) {
        this.name = name;
        this.loadPreferences();
        super.setName(name);
        this.loadJSAPI();
    }

    public boolean configure() {
        ConfigurationInterface[] inter = new ConfigurationInterface[]{new ConfigSynthesizer(this.pref), new ConfigSingleVoice(this.pref), new ConfigEmbeddedEditor(this.pref), new TalkingEditorConfig(this.pref)};
        ConfigurationDialog dial = new ConfigurationDialog("PopsTalk Editor Preferences", this.pref, inter);
        dial.show();
        this.loadPreferences();
        return true;
    }

    public JPanel getEditorPanel() {
        JPanel editor = super.getEditorPanel();
        JPanel statusPanel = new JPanel(new GridBagLayout());
        statusPanel.add((Component)this.statement, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        statusPanel.add((Component)this.source, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        statusPanel.add((Component)this.constraints, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        statusPanel.add((Component)this.testCases, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        statusPanel.add((Component)this.methodDef, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        statusPanel.add((Component)this.stop, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        MyPanel myPanel = new MyPanel();
        myPanel.add((Component)(editor == null ? new JPanel() : editor), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        myPanel.add((Component)statusPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        return myPanel;
    }

    public void loadPreferences() {
        if (this.pref != null) {
            return;
        }
        this.pref = new Preferences(this.name);
        this.setEditor(this.pref.getStringProperty("embeddededitor", null));
    }

    public void stopUsing() {
        try {
            this.disposeSynthesizer();
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        super.stopUsing();
    }

    public void setProblemComponent(ProblemComponentModel prob, Language lang, Renderer rend) {
        this.prob = prob;
        this.lang = lang;
        this.rend = rend;
        super.setProblemComponent(prob, lang, rend);
        Thread t = new Thread(new Runnable(){

            public void run() {
                String start;
                if (TalkingEditor.this.synthesizer != null) {
                    TalkingEditor.this.synthesizer.cancelAll();
                }
                if ((start = TalkingEditor.this.pref.getStringProperty("playAtStart", "Problem Statement")).equals("Problem Statement")) {
                    TalkingEditor.this.speakStatement();
                }
                if (start.equals("Class Definition")) {
                    TalkingEditor.this.speakMethod();
                }
                if (start.equals("Points")) {
                    TalkingEditor.this.speakPoints();
                }
                if (start.equals("Constraints")) {
                    TalkingEditor.this.speakConstraints();
                }
                if (start.equals("Test Cases")) {
                    TalkingEditor.this.speakTestCases();
                }
            }
        });
        t.start();
    }

    public void dispose() {
        try {
            this.disposeSynthesizer();
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        super.dispose();
    }

    private void loadJSAPI() {
        try {
            this.disposeSynthesizer();
            String v = this.pref.getStringProperty("voice", null);
            int g = this.pref.getIntegerProperty("voicegender", 65535);
            int a = this.pref.getIntegerProperty("voiceage", 65535);
            String s = this.pref.getStringProperty("voiceStyle", "");
            Voice voice = new Voice(v, g, a, s);
            this.synthesizer = PopsSynthesizer.createSynthesizer(this.pref);
            if (this.synthesizer == null) {
                return;
            }
            this.synthesizer.addSpeakableListener((SpeakableListener)this.speakableHandler);
            this.synthesizer.getSynthesizerProperties().setVoice(voice);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        catch (AudioException e) {
            e.printStackTrace();
        }
        catch (EngineStateError e) {
            e.printStackTrace();
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        if (this.synthesizer == null) {
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.synthesizer != null) {
            this.synthesizer.cancelAll();
        }
        if (e.getSource() == this.statement) {
            this.speakStatement();
        } else if (e.getSource() == this.source) {
            this.speakSource();
        } else if (e.getSource() == this.methodDef) {
            this.speakMethod();
        } else if (e.getSource() == this.testCases) {
            this.speakTestCases();
        } else if (e.getSource() == this.constraints) {
            this.speakConstraints();
        } else if (e.getSource() == this.stop) {
            this.synthesizer.cancelAll();
        }
    }

    private void speakPoints() {
        if (this.synthesizer == null) {
            this.loadJSAPI();
        }
        if (this.synthesizer == null) {
            return;
        }
        StringBuffer buf = new StringBuffer("You have opened the ");
        buf.append(this.prob.getPoints().intValue());
        buf.append(" value problem");
        this.speak(buf);
    }

    private void speakStatement() {
        if (this.synthesizer == null) {
            this.loadJSAPI();
        }
        if (this.synthesizer == null) {
            return;
        }
        if (this.prob == null) {
            this.speak("Error, no problem model");
            return;
        }
        StringBuffer buf = new StringBuffer(250);
        buf.append("The Problem Statement  ");
        buf.append(this.convertElement(this.prob.getIntro()));
        this.addSpacing(buf);
        buf.append(this.convertElement(this.prob.getSpec()));
        this.addSpacing(buf);
        Element[] elms = this.prob.getNotes();
        int x = 0;
        while (x < elms.length) {
            buf.append("Note ");
            buf.append(x);
            this.addSpacing(buf);
            buf.append(this.convertElement(elms[x]));
            this.addSpacing(buf);
            ++x;
        }
        this.speak(buf);
    }

    private void speakSource() {
        if (this.synthesizer == null) {
            this.loadJSAPI();
        }
        if (this.synthesizer == null) {
            return;
        }
        String source = this.getSource();
        if (source == null) {
            this.speak("Error, no source.");
            return;
        }
        StringBuffer buf = new StringBuffer(300);
        buf.append("The Source  ");
        buf.append(source);
        this.addSpacing(buf);
        this.speak(buf);
    }

    private void speakMethod() {
        if (this.synthesizer == null) {
            this.loadJSAPI();
        }
        if (this.synthesizer == null) {
            return;
        }
        if (this.prob == null) {
            this.speak("Error, no problem model.");
            return;
        }
        String[] parmNames = this.prob.getParamNames();
        DataType[] parms = this.prob.getParamTypes();
        String[] parmTypes = new String[parms.length];
        int x = parms.length - 1;
        while (x >= 0) {
            parmTypes[x] = this.convertDataType(parms[x]);
            --x;
        }
        StringBuffer buf = new StringBuffer(100);
        buf.append("Implement the class ");
        buf.append(this.prob.getClassName());
        buf.append(" containing the method ");
        buf.append(this.prob.getMethodName());
        buf.append(". The method should return ");
        buf.append(this.convertDataType(this.prob.getReturnType()));
        buf.append(" and has the following parameters. ");
        int x2 = 0;
        while (x2 < parmNames.length) {
            buf.append(parmNames[x2]);
            buf.append(" ");
            buf.append(parmTypes[x2]);
            buf.append(". ");
            ++x2;
        }
        this.addSpacing(buf);
        this.speak(buf);
    }

    private void speakTestCases() {
        if (this.synthesizer == null) {
            this.loadJSAPI();
        }
        if (this.synthesizer == null) {
            return;
        }
        if (this.prob == null) {
            this.speak("Error, no problem model");
            return;
        }
        StringBuffer buf = new StringBuffer(300);
        TestCase[] testCases = this.prob.getTestCases();
        String[] parmName = this.prob.getParamNames();
        int x = 0;
        while (x < testCases.length) {
            buf.append("  Test case ");
            buf.append(x);
            this.addSpacing(buf);
            String[] parms = testCases[x].getInput();
            int y = 0;
            while (y < parms.length) {
                if (y > 0) {
                    buf.append(" and ");
                }
                buf.append("setting ");
                buf.append(parmName[y]);
                buf.append(" to ");
                buf.append(parms[y]);
                ++y;
            }
            buf.append(" should return ");
            buf.append(testCases[x].getOutput());
            this.addSpacing(buf);
            if (testCases[x].getAnnotation() != null) {
                buf.append(this.convertElement(testCases[x].getAnnotation()));
            }
            this.addSpacing(buf);
            ++x;
        }
        this.speak(buf);
    }

    private void speakConstraints() {
        if (this.synthesizer == null) {
            this.loadJSAPI();
        }
        if (this.synthesizer == null) {
            return;
        }
        if (this.prob == null) {
            this.speak("Error, no problem model.");
            return;
        }
        StringBuffer buf = new StringBuffer(150);
        Constraint[] cons = this.prob.getConstraints();
        int x = 0;
        while (x < cons.length) {
            buf.append("Constraint number ");
            buf.append(x);
            buf.append(" of ");
            buf.append(cons.length);
            this.addSpacing(buf);
            buf.append(this.convertConstraint(cons[x]));
            this.addSpacing(buf);
            ++x;
        }
        this.speak(buf);
    }

    private String convertConstraint(Constraint constraint) {
        StringBuffer buf = new StringBuffer(125);
        if (constraint instanceof UserConstraint) {
            buf.append(((UserConstraint)constraint).getText());
        } else {
            buf.append(constraint.toString());
        }
        this.removeBold(buf);
        return buf.toString();
    }

    private void removeBold(StringBuffer s) {
        this.removeAll(s, "<b>");
        this.removeAll(s, "</b>");
    }

    private void removeAll(StringBuffer s, String r) {
        int pos = s.indexOf(r);
        while (pos >= 0) {
            s.delete(pos, pos + r.length());
            pos = s.indexOf(r, pos);
        }
    }

    private String convertElement(Element elm) {
        if (elm == null) {
            return "None";
        }
        if (elm instanceof TextElement) {
            return ((TextElement)elm).getEditableText();
        }
        if (elm instanceof NodeElement) {
            NodeElement e = (NodeElement)elm;
            StringBuffer buf = new StringBuffer(2000);
            ArrayList tmp = e.getChildren();
            int x = 0;
            while (x < tmp.size()) {
                buf.append(this.convertElement((Element)tmp.get(x)));
                this.addSpacing(buf);
                ++x;
            }
            return buf.toString();
        }
        ElementRenderer rend = elm.getRenderer();
        if (rend == null) {
            return elm.toString();
        }
        try {
            return rend.toPlainText(this.lang);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error rendering the element";
        }
    }

    private void addSpacing(StringBuffer buf) {
        char ch = buf.charAt(buf.length() - 1);
        if (ch != '.') {
            buf.append(". ");
        }
    }

    private String convertDataType(DataType dataType) {
        int dim;
        String baseName = dataType.getBaseName();
        if (baseName.equalsIgnoreCase("int")) {
            baseName = "integer";
        }
        if (baseName.equalsIgnoreCase("char")) {
            baseName = "character";
        }
        if ((dim = dataType.getDimension()) == 0) {
            return "a " + baseName;
        }
        if (dim == 1) {
            return "an array of " + baseName + "s";
        }
        return "a " + dim + " dimensional array of " + baseName;
    }

    private void disposeSynthesizer() throws EngineException {
        if (this.synthesizer != null) {
            this.synthesizer.cancelAll();
            this.synthesizer.removeSpeakableListener((SpeakableListener)this.speakableHandler);
            this.synthesizer = null;
        }
    }

    private void speak(String speakIt) {
        this.speak(new StringBuffer(speakIt));
    }

    private void speak(StringBuffer speakIt) {
        this.removeBold(speakIt);
        System.out.println("Speaking: " + speakIt);
        if (this.synthesizer != null) {
            this.synthesizer.speakPlainText(speakIt.toString(), null);
        }
    }

    class SpeakableHandler
    extends SpeakableAdapter {
        SpeakableHandler() {
        }

        public void speakableStarted(SpeakableEvent e) {
            TalkingEditor.this.stop.setEnabled(true);
        }

        public void speakableCancelled(SpeakableEvent e) {
            TalkingEditor.this.stop.setEnabled(false);
        }

        public void speakableEnded(SpeakableEvent e) {
            TalkingEditor.this.stop.setEnabled(false);
        }
    }

    class MyPanel
    extends JPanel {
        public MyPanel() {
            super(new GridBagLayout());
            this.enableEvents(8L);
        }

        protected void processEvent(AWTEvent e) {
            System.out.println(e);
            super.processEvent(e);
        }

        public boolean isFocusTraversable() {
            return true;
        }
    }
}

