/*
 * Decompiled with CFR 0.152.
 */
package popspack.popstalk;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.JTextField;
import popspack.Common;
import popspack.config.AbstractConfigurationPanel;
import popspack.popstalk.TalkingAppletPreferences;

public class TalkingAppletWhatConfig
extends AbstractConfigurationPanel
implements ItemListener {
    private JTextField welcome = Common.createJTextField(25);
    private JTextField broadCasts = Common.createJTextField(25);
    private JTextField moveToRoom = Common.createJTextField(25);
    private JTextField whisper = Common.createJTextField(25);
    private JTextField leaderChange = Common.createJTextField(25);
    private JTextField registrationPhase = Common.createJTextField(25);
    private JTextField almostPhase = Common.createJTextField(25);
    private JTextField codingPhase = Common.createJTextField(25);
    private JTextField intermissionPhase = Common.createJTextField(25);
    private JTextField challengePhase = Common.createJTextField(25);
    private JTextField systemTestPhase = Common.createJTextField(25);
    private JTextField endContestPhase = Common.createJTextField(25);
    private JTextField registrationProgress = Common.createJTextField(25);
    private JTextField codingProgress = Common.createJTextField(25);
    private JTextField intermissionProgress = Common.createJTextField(25);
    private JTextField challengeProgress = Common.createJTextField(25);
    private JTextField systemTestProgress = Common.createJTextField(25);
    private JTextField challengeSuccess = Common.createJTextField(25);
    private JTextField challengeUnsuccess = Common.createJTextField(25);
    private JTextField hasSubmitted = Common.createJTextField(25);
    private JTextField timeLeftCuts = Common.createJTextField(25);
    private JTextField systemTestCuts = Common.createJTextField(25);

    public TalkingAppletWhatConfig(TalkingAppletPreferences pref) {
        super(pref);
        this.welcome.setText(pref.getWelcomeSpeech());
        this.broadCasts.setText(pref.getBroadcastsSpeech());
        this.moveToRoom.setText(pref.getMoveToRoomSpeech());
        this.whisper.setText(pref.getWhisperSpeech());
        this.leaderChange.setText(pref.getLeaderChangeSpeech());
        this.challengeSuccess.setText(pref.getChallengeSuccessSpeech());
        this.challengeUnsuccess.setText(pref.getChallengeUnsuccessSpeech());
        this.hasSubmitted.setText(pref.getProblemSubmittedSpeech());
        this.timeLeftCuts.setText(pref.getTimeCuts());
        this.systemTestCuts.setText(pref.getSystemCuts());
        this.registrationPhase.setText(pref.getRegistrationPhaseSpeech());
        this.almostPhase.setText(pref.getAlmostPhaseSpeech());
        this.codingPhase.setText(pref.getCodingPhaseSpeech());
        this.intermissionPhase.setText(pref.getIntermissionPhaseSpeech());
        this.challengePhase.setText(pref.getChallengePhaseSpeech());
        this.systemTestPhase.setText(pref.getSystemTestPhaseSpeech());
        this.endContestPhase.setText(pref.getEndContestPhaseSpeech());
        this.registrationProgress.setText(pref.getRegistrationPhaseProgressSpeech());
        this.codingProgress.setText(pref.getCodingPhaseProgressSpeech());
        this.intermissionProgress.setText(pref.getIntermissionPhaseProgressSpeech());
        this.challengeProgress.setText(pref.getChallengePhaseProgressSpeech());
        this.systemTestProgress.setText(pref.getSystemTestPhaseProgressSpeech());
        this.welcome.getDocument().addDocumentListener(this);
        this.broadCasts.getDocument().addDocumentListener(this);
        this.moveToRoom.getDocument().addDocumentListener(this);
        this.registrationPhase.getDocument().addDocumentListener(this);
        this.almostPhase.getDocument().addDocumentListener(this);
        this.codingPhase.getDocument().addDocumentListener(this);
        this.intermissionPhase.getDocument().addDocumentListener(this);
        this.challengePhase.getDocument().addDocumentListener(this);
        this.systemTestPhase.getDocument().addDocumentListener(this);
        this.endContestPhase.getDocument().addDocumentListener(this);
        this.registrationProgress.getDocument().addDocumentListener(this);
        this.codingProgress.getDocument().addDocumentListener(this);
        this.intermissionProgress.getDocument().addDocumentListener(this);
        this.challengeProgress.getDocument().addDocumentListener(this);
        this.systemTestProgress.getDocument().addDocumentListener(this);
        this.whisper.getDocument().addDocumentListener(this);
        this.challengeSuccess.getDocument().addDocumentListener(this);
        this.challengeUnsuccess.getDocument().addDocumentListener(this);
        this.hasSubmitted.getDocument().addDocumentListener(this);
        this.leaderChange.getDocument().addDocumentListener(this);
        this.timeLeftCuts.getDocument().addDocumentListener(this);
        this.systemTestCuts.getDocument().addDocumentListener(this);
        int row = 0;
        this.add((Component)Common.createJLabel("Welcome"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.welcome, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Broadcasts"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.broadCasts, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Moving to"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.moveToRoom, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Whispers"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.whisper, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Successful Challenge"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.challengeSuccess, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Unsuccessful Challenge"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.challengeUnsuccess, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Submitted Problem"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.hasSubmitted, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Leader Change"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.leaderChange, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Time Left Cuts"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 5, 5, 5), 0, 0));
        this.add((Component)this.timeLeftCuts, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("System Test Cuts"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.systemTestCuts, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Registration Phase"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.registrationPhase, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Registration Progress"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.registrationProgress, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Pre-Coding Phase"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.almostPhase, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Coding Phase"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.codingPhase, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Coding Progress"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.codingProgress, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Intermission Phase"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.intermissionPhase, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Intermission Progress"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.intermissionProgress, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Challenge Phase"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.challengePhase, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Challenge Progress"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.challengeProgress, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("System Testing Phase"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.systemTestPhase, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("System Testing Progress"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.systemTestProgress, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("End Contest Phase"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.endContestPhase, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel(""), new GridBagConstraints(1, row++, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public String getTabTitle() {
        return "What to Speak";
    }

    public String getTabToolTip() {
        return "Speaking Settings for the TalkingApplet";
    }

    public boolean validatePreferences() {
        StringTokenizer tok = new StringTokenizer(this.timeLeftCuts.getText(), ", ");
        long prior = Integer.MIN_VALUE;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            try {
                Integer v = new Integer(token);
                if (v < 1) {
                    Common.showMessage("Error", "You have a time left cut that is less than 1 minute", this);
                    this.timeLeftCuts.requestFocus();
                    return false;
                }
                if (v > 90) {
                    Common.showMessage("Error", "You have a time left cut that is greater than 90 minutes", this);
                    this.timeLeftCuts.requestFocus();
                    return false;
                }
                prior = v.intValue();
            }
            catch (NumberFormatException e) {
                Common.showMessage("Error", "The time left cuts are not all integers.  Error parsing '" + token, this);
                this.timeLeftCuts.requestFocus();
                return false;
            }
        }
        tok = new StringTokenizer(this.systemTestCuts.getText(), ", ");
        double priorD = 1.0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            try {
                Double v = new Double(token);
                if (v < 0.0) {
                    Common.showMessage("Error", "You have a system test cut that is less than 0.0", this);
                    this.systemTestCuts.requestFocus();
                    return false;
                }
                if (v > 1.0) {
                    Common.showMessage("Error", "You have a system test cut that is greater than 1.0", this);
                    this.systemTestCuts.requestFocus();
                    return false;
                }
                priorD = v;
            }
            catch (NumberFormatException e) {
                Common.showMessage("Error", "The system test cuts are not all doubles.  Error parsing '" + token, this);
                this.systemTestCuts.requestFocus();
                return false;
            }
        }
        return true;
    }

    public void savePreferences() {
        ((TalkingAppletPreferences)this.pref).setWelcomeSpeech(this.welcome.getText());
        ((TalkingAppletPreferences)this.pref).setBroadcastsSpeech(this.broadCasts.getText());
        ((TalkingAppletPreferences)this.pref).setMoveToRoomSpeech(this.moveToRoom.getText());
        ((TalkingAppletPreferences)this.pref).setRegistrationPhaseSpeech(this.registrationPhase.getText());
        ((TalkingAppletPreferences)this.pref).setRegistrationPhaseProgressSpeech(this.registrationProgress.getText());
        ((TalkingAppletPreferences)this.pref).setAlmostPhaseSpeech(this.almostPhase.getText());
        ((TalkingAppletPreferences)this.pref).setCodingPhaseSpeech(this.codingPhase.getText());
        ((TalkingAppletPreferences)this.pref).setCodingPhaseProgressSpeech(this.codingProgress.getText());
        ((TalkingAppletPreferences)this.pref).setIntermissionPhaseSpeech(this.intermissionPhase.getText());
        ((TalkingAppletPreferences)this.pref).setIntermissionPhaseProgressSpeech(this.intermissionProgress.getText());
        ((TalkingAppletPreferences)this.pref).setChallengePhaseSpeech(this.challengePhase.getText());
        ((TalkingAppletPreferences)this.pref).setChallengePhaseProgressSpeech(this.challengeProgress.getText());
        ((TalkingAppletPreferences)this.pref).setSystemTestPhaseSpeech(this.systemTestPhase.getText());
        ((TalkingAppletPreferences)this.pref).setSystemTestPhaseProgressSpeech(this.systemTestProgress.getText());
        ((TalkingAppletPreferences)this.pref).setEndContestPhaseSpeech(this.endContestPhase.getText());
        ((TalkingAppletPreferences)this.pref).setWhisperSpeech(this.whisper.getText());
        ((TalkingAppletPreferences)this.pref).setChallengeSuccessSpeech(this.challengeSuccess.getText());
        ((TalkingAppletPreferences)this.pref).setChallengeUnsuccessSpeech(this.challengeUnsuccess.getText());
        ((TalkingAppletPreferences)this.pref).setProblemSubmittedSpeech(this.hasSubmitted.getText());
        ((TalkingAppletPreferences)this.pref).setLeaderChangeSpeech(this.leaderChange.getText());
        ((TalkingAppletPreferences)this.pref).setTimeCuts(this.timeLeftCuts.getText());
        ((TalkingAppletPreferences)this.pref).setSystemCuts(this.systemTestCuts.getText());
    }

    public void itemStateChanged(ItemEvent e) {
        this.savePending();
    }
}

