/*
 * Decompiled with CFR 0.152.
 */
package popspack.popstalk;

import java.text.MessageFormat;
import javax.speech.synthesis.Voice;
import popspack.Preferences;

public class TalkingAppletPreferences
extends Preferences {
    private static final String MOVETOROOM = "movetoroom";
    private static final String LEADERCHANGE = "leaderchange";
    private static final String REGISTRATIONPHASE = "registrationphase";
    private static final String ALMOSTCONTESTPHASE = "almostcontestphase";
    private static final String CODINGPHASE = "codingphase";
    private static final String CHALLENGEPHASE = "challengephase";
    private static final String INTERMISSIONPHASE = "intermissionphase";
    private static final String SYSTEMTESTPHASE = "systemtestphase";
    private static final String ENDCONTESTPHASE = "endcontestphase";
    private static final String REGISTRATIONPROGRESS = "registrationprogress";
    private static final String CODINGPROGRESS = "codingprogress";
    private static final String CHALLENGEPROGRESS = "challengeprogress";
    private static final String INTERMISSIONPROGRESS = "intermissionprogress";
    private static final String SYSTEMTESTPROGRESS = "systemtestprogress";
    private static final String BROADCASTMSG = "broadcastsmsg";
    private static final String WELCOME = "welcome";
    private static final String WHISPER = "whisperphrase";
    private static final String BROADCASTS = "broadcasts";
    private static final String ROOMMOVES = "roommoves";
    private static final String LEADERBOARDWATCH = "leaderboardwatch";
    private static final String LEADERBOARDROOM = "leaderboardroom";
    private static final String TIMELEFT = "timeleft";
    private static final String SYSTEMTESTS = "systemtests";
    private static final String TIMELEFTCUTS = "timeleftcuts";
    private static final String SYSTEMTESTCUTS = "systemtestcuts";
    private static final String CHALLENGESUCCESS = "challengesuccessphrase";
    private static final String CHALLENGEUNSUCCESS = "challengeunsuccessphrase";
    private static final String PROBLEMSUBMITTED = "problemsubmittedphrase";
    private static final String CHATALL = "chatall";

    public TalkingAppletPreferences(String name) {
        super(name);
    }

    public boolean isLeaderBoardRoom() {
        return this.getLeaderChangeSpeech().length() > 0;
    }

    public boolean isRoomMoves() {
        return this.getMoveToRoomSpeech().length() > 0;
    }

    public boolean isWhispers() {
        return this.getWhisperSpeech().length() > 0;
    }

    public boolean isChallengeSuccess() {
        return this.getChallengeSuccessSpeech().length() > 0;
    }

    public boolean isChallengeUnsuccess() {
        return this.getChallengeUnsuccessSpeech().length() > 0;
    }

    public boolean isProblemSubmitted() {
        return this.getProblemSubmittedSpeech().length() > 0;
    }

    public boolean isBroadcasts() {
        return this.getBroadcastsSpeech().length() > 0;
    }

    public String getTimeCuts() {
        return this.getStringProperty(TIMELEFTCUTS, "60,45,30,15,10,5,1");
    }

    public String getSystemCuts() {
        return this.getStringProperty(SYSTEMTESTCUTS, ".25,.50,.75,.95");
    }

    public String getMoveToRoomSpeech() {
        return this.getStringProperty(MOVETOROOM, "Moving to {0}.");
    }

    public String getMoveToRoomSpeech(String roomName) {
        return MessageFormat.format(this.getMoveToRoomSpeech(), roomName);
    }

    public String getLeaderChangeSpeech() {
        return this.getStringProperty(LEADERCHANGE, "{0} has taken the lead with {1}.");
    }

    public String getLeaderChangeSpeech(String userName, int points) {
        return MessageFormat.format(this.getLeaderChangeSpeech(), userName, String.valueOf(points));
    }

    public String getRegistrationPhaseSpeech() {
        return this.getStringProperty(REGISTRATIONPHASE, "Registration is open.");
    }

    public String getAlmostPhaseSpeech() {
        return this.getStringProperty(ALMOSTCONTESTPHASE, "Contest will begin soon.");
    }

    public String getCodingPhaseSpeech() {
        return this.getStringProperty(CODINGPHASE, "Begin coding.");
    }

    public String getIntermissionPhaseSpeech() {
        return this.getStringProperty(INTERMISSIONPHASE, "Take a break - it''s intermission.");
    }

    public String getChallengePhaseSpeech() {
        return this.getStringProperty(CHALLENGEPHASE, "Challenge away.");
    }

    public String getSystemTestPhaseSpeech() {
        return this.getStringProperty(SYSTEMTESTPHASE, "System testing underway.");
    }

    public String getEndContestPhaseSpeech() {
        return this.getStringProperty(ENDCONTESTPHASE, "System testing finished.");
    }

    public String getRegistrationPhaseProgressSpeech() {
        return this.getStringProperty(REGISTRATIONPROGRESS, "{0} minutes left to register.");
    }

    public String getRegistrationPhaseProgressSpeech(int minutes) {
        return MessageFormat.format(this.getRegistrationPhaseProgressSpeech(), String.valueOf(minutes));
    }

    public String getCodingPhaseProgressSpeech() {
        return this.getStringProperty(CODINGPROGRESS, "{0} minutes left to code.");
    }

    public String getCodingPhaseProgressSpeech(int minutes) {
        return MessageFormat.format(this.getCodingPhaseProgressSpeech(), String.valueOf(minutes));
    }

    public String getIntermissionPhaseProgressSpeech() {
        return this.getStringProperty(INTERMISSIONPROGRESS, "{0} minutes left in intermission.");
    }

    public String getIntermissionPhaseProgressSpeech(int minutes) {
        return MessageFormat.format(this.getIntermissionPhaseProgressSpeech(), String.valueOf(minutes));
    }

    public String getChallengePhaseProgressSpeech() {
        return this.getStringProperty(CHALLENGEPROGRESS, "{0} minutes left to challenge.");
    }

    public String getChallengePhaseProgressSpeech(int minutes) {
        return MessageFormat.format(this.getChallengePhaseProgressSpeech(), String.valueOf(minutes));
    }

    public String getSystemTestPhaseProgressSpeech() {
        return this.getStringProperty(SYSTEMTESTPROGRESS, "System tests are {0} percent complete.");
    }

    public String getSystemTestPhaseProgressSpeech(int completed) {
        return MessageFormat.format(this.getSystemTestPhaseProgressSpeech(), String.valueOf(completed));
    }

    public String getBroadcastsSpeech() {
        return this.getStringProperty(BROADCASTMSG, "Attention, {0}.");
    }

    public String getBroadcastsSpeech(String broadcasts) {
        return MessageFormat.format(this.getBroadcastsSpeech(), broadcasts);
    }

    public String getWelcomeSpeech() {
        return this.getStringProperty(WELCOME, "Welcome to the top coder competition arena.");
    }

    public String getWhisperSpeech() {
        return this.getStringProperty(WHISPER, "{0} whispers to you {1}.");
    }

    public String getWhisperSpeech(String handle, String msg) {
        return MessageFormat.format(this.getWhisperSpeech(), handle, msg);
    }

    public String getChallengeSuccessSpeech() {
        return this.getStringProperty(CHALLENGESUCCESS, "{0} successfully challenged {1}''s {2} point problem.");
    }

    public String getChallengeSuccessSpeech(String handle, String otherHandle, Integer pts) {
        return MessageFormat.format(this.getChallengeSuccessSpeech(), handle, otherHandle, pts);
    }

    public String getChallengeUnsuccessSpeech() {
        return this.getStringProperty(CHALLENGEUNSUCCESS, "{0} unsuccessfully challenged {1}''s {2} point problem.");
    }

    public String getChallengeUnsuccessSpeech(String handle, String otherHandle, Integer pts) {
        return MessageFormat.format(this.getChallengeUnsuccessSpeech(), handle, otherHandle, pts.toString());
    }

    public String getProblemSubmittedSpeech() {
        return this.getStringProperty(PROBLEMSUBMITTED, "{0} has submitted the {1} point problem for {2} points.");
    }

    public String getProblemSubmittedSpeech(String handle, Integer pts, Integer pts2) {
        return MessageFormat.format(this.getProblemSubmittedSpeech(), handle, pts, pts2);
    }

    public Voice getVoice() {
        String v = this.getStringProperty("voice", null);
        int g = this.getIntegerProperty("voicegender", 65535);
        int a = this.getIntegerProperty("voiceage", 65535);
        String s = this.getStringProperty("voiceStyle", "");
        return new Voice(v, g, a, s);
    }

    public void setTimeCuts(String cuts) {
        this.setProperty(TIMELEFTCUTS, cuts);
    }

    public void setSystemCuts(String cuts) {
        this.setProperty(SYSTEMTESTCUTS, cuts);
    }

    public void setMoveToRoomSpeech(String speech) {
        this.setProperty(MOVETOROOM, speech);
    }

    public void setLeaderChangeSpeech(String speech) {
        this.setProperty(LEADERCHANGE, speech);
    }

    public void setRegistrationPhaseSpeech(String speech) {
        this.setProperty(REGISTRATIONPHASE, speech);
    }

    public void setAlmostPhaseSpeech(String speech) {
        this.setProperty(ALMOSTCONTESTPHASE, speech);
    }

    public void setCodingPhaseSpeech(String speech) {
        this.setProperty(CODINGPHASE, speech);
    }

    public void setIntermissionPhaseSpeech(String speech) {
        this.setProperty(INTERMISSIONPHASE, speech);
    }

    public void setChallengePhaseSpeech(String speech) {
        this.setProperty(CHALLENGEPHASE, speech);
    }

    public void setSystemTestPhaseSpeech(String speech) {
        this.setProperty(SYSTEMTESTPHASE, speech);
    }

    public void setEndContestPhaseSpeech(String speech) {
        this.setProperty(ENDCONTESTPHASE, speech);
    }

    public void setRegistrationPhaseProgressSpeech(String speech) {
        this.setProperty(REGISTRATIONPROGRESS, speech);
    }

    public void setCodingPhaseProgressSpeech(String speech) {
        this.setProperty(CODINGPROGRESS, speech);
    }

    public void setIntermissionPhaseProgressSpeech(String speech) {
        this.setProperty(INTERMISSIONPROGRESS, speech);
    }

    public void setChallengePhaseProgressSpeech(String speech) {
        this.setProperty(CHALLENGEPROGRESS, speech);
    }

    public void setSystemTestPhaseProgressSpeech(String speech) {
        this.setProperty(SYSTEMTESTPROGRESS, speech);
    }

    public void setBroadcastsSpeech(String speech) {
        this.setProperty(BROADCASTMSG, speech);
    }

    public void setWelcomeSpeech(String speech) {
        this.setProperty(WELCOME, speech);
    }

    public void setWhisperSpeech(String speech) {
        this.setProperty(WHISPER, speech);
    }

    public void setChallengeSuccessSpeech(String speech) {
        this.setProperty(CHALLENGESUCCESS, speech);
    }

    public void setChallengeUnsuccessSpeech(String speech) {
        this.setProperty(CHALLENGEUNSUCCESS, speech);
    }

    public void setProblemSubmittedSpeech(String speech) {
        this.setProperty(PROBLEMSUBMITTED, speech);
    }

    public void setChatAll(boolean enabled) {
        this.setProperty(CHATALL, enabled);
    }

    public boolean isChatAll() {
        return this.getBooleanProperty(CHATALL, false);
    }
}

