/*
 * Decompiled with CFR 0.152.
 */
package popspack.popstalk;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestant.BroadcastListener;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.message.Interceptor;
import com.topcoder.client.contestant.view.RoomViewManager;
import com.topcoder.client.contestant.view.RoundView;
import java.beans.PropertyVetoException;
import javax.speech.AudioException;
import javax.speech.EngineException;
import javax.speech.EngineStateError;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.Voice;
import popspack.AbstractEntryPoint;
import popspack.PopsSynthesizer;
import popspack.config.ConfigSingleVoice;
import popspack.config.ConfigSynthesizer;
import popspack.config.ConfigurationDialog;
import popspack.config.ConfigurationInterface;
import popspack.popstalk.CurrentRoomListener;
import popspack.popstalk.InterceptorHandler;
import popspack.popstalk.PlayBroadcasts;
import popspack.popstalk.RoundListener;
import popspack.popstalk.TalkingAppletPreferences;
import popspack.popstalk.TalkingAppletWhatConfig;

public class TalkingApplet
extends AbstractEntryPoint {
    private Synthesizer synthesizer = null;
    private TalkingAppletPreferences pref;
    private ContestApplet ca = null;

    public void configure() {
        this.loadPreferences(null);
        new ConfigurationDialog("TalkingApplet Configuration", this.pref, new ConfigurationInterface[]{new ConfigSynthesizer(this.pref), new ConfigSingleVoice(this.pref), new TalkingAppletWhatConfig(this.pref)}).show();
        this.loadJSAPI();
    }

    public void setContestApplet(ContestApplet ca) {
        this.loadPreferences(null);
        this.loadJSAPI();
        PopsSynthesizer.getInstance(this.pref.getName()).speak(this.pref.getWelcomeSpeech(), true);
        this.ca = ca;
        ca.getModel().getBroadcastManager().addBroadcastListener((BroadcastListener)new PlayBroadcasts(this.pref.getName()), true);
        ca.getModel().getRoundViewManager().addListener((RoundView)new RoundListener(this.pref.getName()));
        ca.getModel().getRoundViewManager().updateActiveRoundList();
        CurrentRoomListener crl = new CurrentRoomListener(this.pref.getName());
        ca.getModel().getRoomViewManagerManager().addListener((RoomViewManager)crl);
        RoomModel[] rooms = ca.getModel().getRooms();
        int x = rooms.length - 1;
        while (x >= 0) {
            crl.addRoom(rooms[x]);
            --x;
        }
        ca.getModel().getInterceptorManager().addInterceptor((Interceptor)new InterceptorHandler(this.pref.getName(), this.pref));
    }

    public void startUsing() {
        this.loadPreferences(null);
        this.loadJSAPI();
    }

    public synchronized void loadPreferences(String name) {
        if (this.pref == null) {
            this.pref = new TalkingAppletPreferences(this.getClass().getName());
        }
    }

    private synchronized void loadJSAPI() {
        try {
            this.disposeSynthesizer();
            Voice voice = this.pref.getVoice();
            this.synthesizer = PopsSynthesizer.createSynthesizer(this.pref);
            if (this.synthesizer == null) {
                return;
            }
            this.synthesizer.getSynthesizerProperties().setVoice(voice);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        catch (AudioException e) {
            e.printStackTrace();
        }
        catch (EngineStateError e) {
            e.printStackTrace();
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    private void disposeSynthesizer() throws EngineException {
        if (this.synthesizer != null) {
            this.synthesizer.cancelAll();
            this.synthesizer = null;
        }
    }
}

