/*
 * Decompiled with CFR 0.152.
 */
package popspack.popstalk;

import com.topcoder.client.contestant.RoundModel;
import com.topcoder.client.contestant.view.PhaseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import popspack.Logger;
import popspack.PopsSynthesizer;
import popspack.popstalk.TalkingAppletPreferences;

class PhaseHandler
implements PhaseListener {
    private String name;
    private int currentPhase = Integer.MIN_VALUE;
    double[] sysTestAnnounce;
    boolean[] sysTestSaid;
    int[] roundAnnounce;
    boolean[] roundSaid;
    private TalkingAppletPreferences pref;

    public PhaseHandler(String name) {
        String cut;
        this.name = name;
        this.pref = new TalkingAppletPreferences(name);
        ArrayList temp = new ArrayList();
        StringTokenizer str = new StringTokenizer(this.pref.getTimeCuts(), ",");
        this.roundAnnounce = new int[str.countTokens()];
        this.roundSaid = new boolean[str.countTokens()];
        int x = 0;
        while (str.hasMoreTokens()) {
            cut = str.nextToken();
            try {
                this.roundAnnounce[x] = Integer.parseInt(cut);
                if (this.roundAnnounce[x] > 90) {
                    Logger.getInstance().log("Error - the time cut '" + cut + "' is greater than 90 and will be ignored", 2);
                    this.roundAnnounce[x] = -1;
                } else if (this.roundAnnounce[x] < 1) {
                    Logger.getInstance().log("Error - the time cut '" + cut + "' is less than 1 and will be ignored", 2);
                    this.roundAnnounce[x] = -1;
                }
            }
            catch (NumberFormatException e) {
                Logger.getInstance().log("Error - the time cut '" + cut + "' is not a valid integer and will be ignored", 2);
                this.roundAnnounce[x] = -1;
            }
            ++x;
        }
        Arrays.sort(this.roundAnnounce);
        Arrays.fill(this.roundSaid, false);
        str = new StringTokenizer(this.pref.getSystemCuts(), ",");
        this.sysTestAnnounce = new double[str.countTokens() + 1];
        this.sysTestSaid = new boolean[str.countTokens() + 1];
        this.sysTestAnnounce[0] = -1.0;
        x = 1;
        while (str.hasMoreTokens()) {
            cut = str.nextToken();
            try {
                this.sysTestAnnounce[x] = Double.parseDouble(cut);
                if (this.sysTestAnnounce[x] > 1.0) {
                    Logger.getInstance().log("Error - the system test cut '" + cut + "' is greater than 1 and will be ignored", 2);
                    this.sysTestAnnounce[x] = -1.0;
                } else if (this.sysTestAnnounce[x] < 0.0) {
                    Logger.getInstance().log("Error - the system test cut '" + cut + "' is less than 0 and will be ignored", 2);
                    this.sysTestAnnounce[x] = -1.0;
                }
            }
            catch (NumberFormatException e) {
                Logger.getInstance().log("Error - the system test cut '" + cut + "' is not a valid double - it will be ignored", 2);
                this.sysTestAnnounce[x] = -1.0;
            }
            ++x;
        }
        Arrays.sort(this.sysTestAnnounce);
        Arrays.fill(this.sysTestSaid, false);
    }

    public void phaseEvent(int phase, RoundModel roundModel) {
        Logger.getInstance().log("PhaseEvent: " + phase, 0);
        int priorPhase = this.currentPhase;
        this.currentPhase = phase;
        if (priorPhase != phase) {
            Arrays.fill(this.roundSaid, false);
            Arrays.fill(this.sysTestSaid, false);
            switch (phase) {
                case 2: {
                    PopsSynthesizer.getInstance(this.name).speak(this.pref.getRegistrationPhaseSpeech());
                    break;
                }
                case 3: {
                    PopsSynthesizer.getInstance(this.name).speak(this.pref.getAlmostPhaseSpeech());
                    break;
                }
                case 4: {
                    PopsSynthesizer.getInstance(this.name).speak(this.pref.getCodingPhaseSpeech());
                    break;
                }
                case 5: {
                    PopsSynthesizer.getInstance(this.name).speak(this.pref.getIntermissionPhaseSpeech());
                    break;
                }
                case 6: {
                    PopsSynthesizer.getInstance(this.name).speak(this.pref.getChallengePhaseSpeech());
                    break;
                }
                case 8: {
                    PopsSynthesizer.getInstance(this.name).speak(this.pref.getSystemTestPhaseSpeech());
                    break;
                }
                case 11: {
                    if (priorPhase != 8) break;
                    PopsSynthesizer.getInstance(this.name).speak(this.pref.getEndContestPhaseSpeech());
                }
            }
            return;
        }
        int minutesLeft = (roundModel.getSecondsLeftInPhase() + 59) / 60;
        if (minutesLeft <= 0) {
            return;
        }
        int idx = Arrays.binarySearch(this.roundAnnounce, minutesLeft);
        if (idx < 0) {
            idx = -(idx + 1);
        }
        Arrays.fill(this.roundSaid, 0, idx, false);
        if (idx >= this.roundSaid.length || this.roundSaid[idx]) {
            return;
        }
        Arrays.fill(this.roundSaid, idx, this.roundSaid.length, true);
        Object format = null;
        switch (phase) {
            case 2: {
                PopsSynthesizer.getInstance(this.name).speak(this.pref.getRegistrationPhaseProgressSpeech(minutesLeft));
                break;
            }
            case 4: {
                PopsSynthesizer.getInstance(this.name).speak(this.pref.getCodingPhaseProgressSpeech(minutesLeft));
                break;
            }
            case 5: {
                PopsSynthesizer.getInstance(this.name).speak(this.pref.getIntermissionPhaseProgressSpeech(minutesLeft));
                break;
            }
            case 6: {
                PopsSynthesizer.getInstance(this.name).speak(this.pref.getChallengePhaseProgressSpeech(minutesLeft));
            }
        }
    }

    public void updateSystestProgress(int completed, int total) {
        Logger.getInstance().log("UpdateSystestProgress: " + completed + "/" + total, 0);
        double perc = (double)completed / (double)total;
        int idx = Arrays.binarySearch(this.sysTestAnnounce, perc);
        if (idx < 0) {
            idx = -(idx + 1);
        }
        if (idx < this.sysTestAnnounce.length && this.sysTestAnnounce[idx] != perc) {
            --idx;
        }
        if (idx + 1 < this.sysTestSaid.length) {
            Arrays.fill(this.sysTestSaid, idx + 1, this.sysTestSaid.length, false);
        }
        if (idx >= this.sysTestSaid.length || idx == 0 || this.sysTestSaid[idx]) {
            return;
        }
        Arrays.fill(this.sysTestSaid, 0, idx + 1, true);
        PopsSynthesizer.getInstance(this.name).speak(this.pref.getSystemTestPhaseProgressSpeech((int)(perc * 100.0)));
    }

    public void enableRound(RoundModel round) {
        Logger.getInstance().log("EnableRound: " + round.getRoundName() + ":" + round.getContestName());
    }

    public void roomListEvent(RoundModel round) {
        Logger.getInstance().log("RoomListEvent: " + round.getRoundName() + ":" + round.getContestName());
    }
}

