/*
 * Decompiled with CFR 0.152.
 */
package popspack.popstalk;

import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.view.ChatView;
import com.topcoder.client.contestant.view.LeaderListener;
import com.topcoder.client.contestant.view.RoomViewManager;
import java.text.MessageFormat;
import java.text.ParseException;
import popspack.Logger;
import popspack.PopsSynthesizer;
import popspack.popstalk.LeaderHandler;
import popspack.popstalk.TalkingAppletPreferences;

class CurrentRoomListener
implements RoomViewManager {
    private String name;
    private TalkingAppletPreferences pref;
    private ChatListener chatListener = new ChatListener();
    private LeaderHandler leaderHandler;
    private RoomModel oldRoom = null;

    CurrentRoomListener(String name) {
        this.name = name;
        this.pref = new TalkingAppletPreferences(name);
        this.leaderHandler = new LeaderHandler(name);
    }

    public synchronized void setCurrentRoom(RoomModel room) {
        Logger.getInstance().log("SetCurrentRoom: " + (room == null ? "null" : room.getName()), 0);
        if (this.oldRoom != null) {
            this.oldRoom.removeChatView((ChatView)this.chatListener);
            this.oldRoom.removeLeaderListener((LeaderListener)this.leaderHandler);
            this.oldRoom = null;
        }
        if (room != null) {
            this.oldRoom = room;
            room.addChatView((ChatView)this.chatListener);
            if (this.pref.isLeaderBoardRoom()) {
                room.addLeaderListener((LeaderListener)this.leaderHandler);
            }
            if (room.getName() != null && this.pref.isRoomMoves()) {
                PopsSynthesizer.getInstance(this.name).speak(this.pref.getMoveToRoomSpeech(room.getName()));
            }
        }
    }

    public void addRoom(RoomModel room) {
        Logger.getInstance().log("AddRoom: " + (room == null ? "null" : room.getName()), 0);
        if (room == null || this.oldRoom != null && this.oldRoom.getRoomID().equals(room.getRoomID())) {
            return;
        }
        room.getType().intValue();
    }

    public void removeRoom(RoomModel room) {
        Logger.getInstance().log("Remove Room: " + (room == null ? "null" : room.getName()), 0);
    }

    public void clearRooms() {
        Logger.getInstance().log("ClearRooms", 0);
    }

    private class ChatListener
    implements ChatView {
        private static final String WHISPERS = "whispers to you:";
        private static final String SUCCESSFULLYCHALLENGES = "successfully challenged";
        private static final String UNSUCCESSFULLYCHALLENGES = "unsuccessfully challenged";
        private static final String HASSUBMITTED = "has submitted the";
        private static final String WHISPERFORMAT = "{0} whispers to you: {1}";
        private static final String SUCCESSFULCHALLENGEFORMAT = "System> {0} successfully challenged {1}''s {2}-point problem.";
        private static final String UNSUCCESSFULCHALLENGEFORMAT = "System> {0} unsuccessfully challenged {1}''s {2}-point problem.";
        private static final String HASSUBMITTEDFORMAT = "System> {0} has submitted the {1}-point problem for {2}.{3} points";

        ChatListener() {
        }

        public void updateChat(String user, int rank, String msg, int scope) {
            this.updateChat(0, msg, scope);
        }

        public void updateChat(int type, String msg, int scope) {
            Logger.getInstance().log("UpdateChat: (" + type + ") " + msg, 0);
            if (type == 3 && CurrentRoomListener.this.pref.isWhispers() && this.processWhisper(msg)) {
                return;
            }
            if (type == 2) {
                if (CurrentRoomListener.this.pref.isChallengeUnsuccess() && this.processChallengeUnsuccess(msg)) {
                    return;
                }
                if (CurrentRoomListener.this.pref.isChallengeSuccess() && this.processChallengeSuccess(msg)) {
                    return;
                }
                if (CurrentRoomListener.this.pref.isProblemSubmitted() && this.processHasSubmitted(msg)) {
                    return;
                }
            }
            if (CurrentRoomListener.this.pref.isChatAll()) {
                PopsSynthesizer.getInstance(CurrentRoomListener.this.name).speak(msg);
            }
        }

        public boolean processWhisper(String msg) {
            int idx = msg.indexOf(WHISPERS);
            if (idx < 0) {
                return false;
            }
            MessageFormat temp = new MessageFormat(WHISPERFORMAT);
            try {
                Object[] o = temp.parse(msg);
                PopsSynthesizer.getInstance(CurrentRoomListener.this.name).speak(CurrentRoomListener.this.pref.getWhisperSpeech((String)o[0], (String)o[1]));
                return true;
            }
            catch (ParseException e) {
                System.err.println("Unknown Whisper Format: " + msg);
                return false;
            }
        }

        public boolean processChallengeSuccess(String msg) {
            int idx = msg.indexOf(SUCCESSFULLYCHALLENGES);
            if (idx < 0) {
                return false;
            }
            MessageFormat temp = new MessageFormat(SUCCESSFULCHALLENGEFORMAT);
            try {
                Object[] o = temp.parse(msg);
                PopsSynthesizer.getInstance(CurrentRoomListener.this.name).speak(CurrentRoomListener.this.pref.getChallengeSuccessSpeech((String)o[0], (String)o[1], new Integer((String)o[2])));
                return true;
            }
            catch (NumberFormatException e) {
                System.err.println("Unknown Challenge Successful Format: " + msg);
                return false;
            }
            catch (ParseException e) {
                System.err.println("Unknown Challenge Successful Format: " + msg);
                return false;
            }
        }

        public boolean processChallengeUnsuccess(String msg) {
            int idx = msg.indexOf(UNSUCCESSFULLYCHALLENGES);
            if (idx < 0) {
                return false;
            }
            MessageFormat temp = new MessageFormat(UNSUCCESSFULCHALLENGEFORMAT);
            try {
                Object[] o = temp.parse(msg);
                PopsSynthesizer.getInstance(CurrentRoomListener.this.name).speak(CurrentRoomListener.this.pref.getChallengeUnsuccessSpeech((String)o[0], (String)o[1], new Integer((String)o[2])));
                return true;
            }
            catch (NumberFormatException e) {
                System.err.println("Unknown Challenge Unsuccessful Format: " + msg);
                return false;
            }
            catch (ParseException e) {
                System.err.println("Unknown Challenge Unsuccessful Format: " + msg);
                return false;
            }
        }

        public boolean processHasSubmitted(String msg) {
            int idx = msg.indexOf(HASSUBMITTED);
            if (idx < 0) {
                return false;
            }
            MessageFormat temp = new MessageFormat(HASSUBMITTEDFORMAT);
            try {
                Object[] o = temp.parse(msg);
                PopsSynthesizer.getInstance(CurrentRoomListener.this.name).speak(CurrentRoomListener.this.pref.getProblemSubmittedSpeech((String)o[0], new Integer((String)o[1]), new Integer((String)o[2])));
                return true;
            }
            catch (NumberFormatException e) {
                System.err.println("Unknown Problem Submitted Format: " + msg);
                return true;
            }
            catch (ParseException e) {
                System.err.println("Unknown Problem Submitted Format: " + msg);
                return true;
            }
        }
    }
}

