/*
 * Decompiled with CFR 0.152.
 */
package popspack.config;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import popspack.Common;
import popspack.Preferences;
import popspack.config.ConfigurationInterface;
import popspack.popstalk.TalkingAppletPreferences;
import popspack.popstalk.TalkingAppletWhatConfig;

public class ConfigurationDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private Preferences pref;
    private JTabbedPane tab = new JTabbedPane();
    private JButton saveButton = new JButton("Save");
    private JButton closeButton = new JButton("Close");
    private ConfigurationInterface[] config;
    private WindowHandler windowHandler = new WindowHandler();
    private int priorIdx = 0;

    public ConfigurationDialog(String title, Preferences pref, ConfigurationInterface[] config) {
        super((Frame)null, title, true);
        this.pref = pref;
        this.config = config;
        this.setSize(new Dimension(600, 400));
        Container contentPane = this.getContentPane();
        Common.setDefaultAttributes(contentPane, new GridBagLayout());
        this.tab.setForeground(Common.FG_COLOR);
        this.tab.setBackground(Common.WPB_COLOR);
        this.tab.addChangeListener(this);
        int x = 0;
        while (x < config.length) {
            this.tab.addTab(config[x].getTabTitle(), config[x].getTabIcon(), (Component)((Object)config[x]), config[x].getTabToolTip());
            ++x;
        }
        JPanel buttonPane = new JPanel();
        Common.setDefaultAttributes(buttonPane, new GridBagLayout());
        buttonPane.add((Component)this.saveButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(10, 10, 10, 10), 0, 0));
        buttonPane.add((Component)this.closeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 10, 10), 0, 0));
        contentPane.add((Component)this.tab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 10, 10), 0, 0));
        contentPane.add((Component)buttonPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.saveButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.windowHandler);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.saveButton) {
            this.save();
        } else if (src == this.closeButton) {
            this.windowHandler.windowClosing(new WindowEvent(this, 201));
        }
    }

    public boolean save() {
        int x = 0;
        while (x < this.config.length) {
            if (!this.config[x].validatePreferences()) {
                this.tab.setSelectedIndex(x);
                return false;
            }
            ++x;
        }
        x = 0;
        while (x < this.config.length) {
            this.config[x].savePreferences();
            ++x;
        }
        try {
            if (this.pref != null) {
                this.pref.save();
            }
            x = 0;
            while (x < this.config.length) {
                this.config[x].resetSavePending();
                ++x;
            }
            return true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Error saving preferences", 0);
            return false;
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.config[this.priorIdx].tabUnSelected();
        this.priorIdx = this.tab.getSelectedIndex();
        this.config[this.priorIdx].tabSelected();
    }

    public static void main(String[] a) {
        TalkingAppletPreferences pref = new TalkingAppletPreferences("popspack.popstalk");
        ConfigurationInterface[] inter = new ConfigurationInterface[]{new TalkingAppletWhatConfig(pref)};
        ConfigurationDialog dial = new ConfigurationDialog("test", pref, inter);
        dial.show();
    }

    private class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            boolean savePending = false;
            int x = 0;
            while (x < ConfigurationDialog.this.config.length) {
                if (ConfigurationDialog.this.config[x].isSavePending()) {
                    savePending = true;
                    break;
                }
                ++x;
            }
            if (savePending) {
                if (Common.confirm("Save Pending", "Changes are pending.  Do you want to save before closing?", null)) {
                    if (!ConfigurationDialog.this.save()) {
                        return;
                    }
                } else {
                    ConfigurationDialog.this.pref.restore();
                }
            }
            ConfigurationDialog.this.dispose();
        }
    }
}

