/*
 * Decompiled with CFR 0.152.
 */
package popspack.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import popspack.Common;
import popspack.PopsSynthesizer;
import popspack.Preferences;
import popspack.config.AbstractConfigurationPanel;

public class ConfigSynthesizer
extends AbstractConfigurationPanel {
    public static final String SYNTHESIZER = "synthesizer";
    public static final String PITCH = "pitch";
    public static final String PITCHRANGE = "pitchrange";
    public static final String SPEAKINGRATE = "speakingrate";
    public static final String VOLUME = "volume";
    private JComboBox synthesizers = Common.createComboBox(new String[0]);
    private JSlider pitch = Common.createJSlider(0, 50, 200, 25, 50);
    private JSlider pitchRange = Common.createJSlider(0, 0, 50, 5, 10);
    private JSlider volume = Common.createJSlider(0, 0, 10, 1, 5);
    private JSlider speakingRate = Common.createJSlider(0, 0, 400, 50, 100);

    public ConfigSynthesizer(Preferences pref) {
        super(pref);
        SynthesizerModeDesc[] modes = PopsSynthesizer.getEngines();
        if (modes != null) {
            int x = 0;
            while (x < modes.length) {
                this.synthesizers.addItem(modes[x].getEngineName());
                ++x;
            }
        }
        this.synthesizers.setSelectedItem(pref.getStringProperty(SYNTHESIZER, ""));
        this.pitch.setValue(pref.getIntegerProperty(PITCH, 100));
        this.pitchRange.setValue(pref.getIntegerProperty(PITCHRANGE, 10));
        this.volume.setValue(pref.getIntegerProperty(VOLUME, 10));
        this.speakingRate.setValue(pref.getIntegerProperty(SPEAKINGRATE, 150));
        this.synthesizers.addActionListener(this);
        JPanel line = new JPanel();
        Common.setDefaultAttributes(line, new GridBagLayout());
        line.add((Component)Common.createJLabel("Synthesizer:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.synthesizers, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)Common.createJLabel("Volume:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.volume, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.createLabelListener(this.volume), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)Common.createJLabel("Words/Min:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.speakingRate, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.createLabelListener(this.speakingRate), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)Common.createJLabel("Pitch/Hz:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.pitch, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.createLabelListener(this.pitch), new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)Common.createJLabel("Range:"), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.pitchRange, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.createLabelListener(this.pitchRange), new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)line, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public String getTabTitle() {
        return "JSAPI Synthesizer Setup";
    }

    public String getTabToolTip() {
        return "Settings for JSAPI Synthesizer";
    }

    public boolean validatePreferences() {
        return true;
    }

    private JLabel createLabelListener(final JSlider slider) {
        final JLabel label = Common.createJLabel(String.valueOf(slider.getValue()));
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                label.setText(String.valueOf(slider.getValue()));
                ConfigSynthesizer.this.savePending();
            }
        });
        return label;
    }

    public void savePreferences() {
        this.pref.setProperty(SYNTHESIZER, (String)this.synthesizers.getSelectedItem());
        this.pref.setProperty(PITCH, this.pitch.getValue());
        this.pref.setProperty(PITCHRANGE, this.pitchRange.getValue());
        this.pref.setProperty(VOLUME, this.volume.getValue());
        this.pref.setProperty(SPEAKINGRATE, this.speakingRate.getValue());
    }
}

