/*
 * Decompiled with CFR 0.152.
 */
package popspack.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.speech.AudioException;
import javax.speech.EngineException;
import javax.speech.EngineStateError;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.Voice;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import popspack.Common;
import popspack.PopsSynthesizer;
import popspack.Preferences;
import popspack.config.AbstractConfigurationPanel;

public class ConfigSingleVoice
extends AbstractConfigurationPanel
implements ActionListener {
    public static final String VOICE = "voice";
    public static final String VOICEGENDER = "voicegender";
    public static final String GENDERDONTCARE = "Don't Care";
    public static final String GENDERFEMALE = "Female";
    public static final String GENDERMALE = "Male";
    public static final String GENDERNEUTRAL = "Neutral";
    public static final String VOICEAGE = "voiceage";
    public static final String AGECHILD = "Child";
    public static final String AGEDONTCARE = "Don't Care";
    public static final String AGETEENAGER = "Teenager";
    public static final String AGEYOUNG = "Young Adult";
    public static final String AGEMIDDLE = "Middle Adult";
    public static final String AGEOLDER = "Older Adult";
    public static final String AGENEUTRAL = "Neutral";
    public static final String VOICESTYLE = "voiceStyle";
    private JTextField sayThis = Common.createJTextField(20);
    private JButton testVoice = Common.createJButton("Test");
    private JComboBox voice = Common.createComboBox(new String[0]);
    private JComboBox gender = Common.createComboBox(new String[]{"Don't Care", "Neutral", "Male", "Female"});
    private JComboBox age = Common.createComboBox(new String[]{"Don't Care", "Neutral", "Child", "Teenager", "Young Adult", "Middle Adult", "Older Adult"});
    private JTextField voiceStyle = Common.createJTextField(20);
    private VoiceModel model = new VoiceModel();

    public ConfigSingleVoice(Preferences pref) {
        super(pref);
        this.model.reSync();
        this.voice.setModel(this.model);
        this.voice.setEditable(false);
        this.voice.setSelectedItem(pref.getStringProperty(VOICE, "kevin16"));
        this.gender.setEditable(false);
        this.gender.setSelectedItem(ConfigSingleVoice.convertGender(pref.getIntegerProperty(VOICEGENDER, 4)));
        this.age.setEditable(false);
        this.age.setSelectedItem(ConfigSingleVoice.convertGender(pref.getIntegerProperty(VOICEAGE, 32)));
        this.voiceStyle.setText(pref.getStringProperty(VOICESTYLE, ""));
        this.voiceStyle.getDocument().addDocumentListener(this);
        this.sayThis.setText("Shall we play a game?");
        this.voice.addActionListener(this);
        this.gender.addActionListener(this);
        this.age.addActionListener(this);
        this.testVoice.addActionListener(this);
        JPanel line = new JPanel();
        Common.setDefaultAttributes(line, new GridBagLayout());
        line.add((Component)Common.createJLabel("Voice:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)Common.createJLabel("Gender:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)Common.createJLabel("Age:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)Common.createJLabel("Style:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.voice, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.gender, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.age, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.voiceStyle, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel testPanel = new JPanel();
        Common.setDefaultAttributes(testPanel, new GridBagLayout());
        testPanel.add((Component)Common.createJLabel("Enter text to test (assumes you setup the synthesizer correctly)"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        testPanel.add((Component)this.sayThis, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        testPanel.add((Component)this.testVoice, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        testPanel.add((Component)Common.createJLabel(""), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)line, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)testPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void tabSelected() {
        this.model.reSync();
    }

    public String getTabTitle() {
        return "JSAPI Voice Setup";
    }

    public String getTabToolTip() {
        return "Settings for JSAPI Voice";
    }

    public boolean validatePreferences() {
        String selected = (String)this.voice.getSelectedItem();
        if (selected == null || selected.trim().length() == 0) {
            Common.showMessage("Error", "You must specify a value for the voice", this);
            this.voice.requestFocus();
            return false;
        }
        return true;
    }

    public void savePreferences() {
        this.pref.setProperty(VOICE, (String)this.voice.getSelectedItem());
        this.pref.setProperty(VOICEGENDER, ConfigSingleVoice.convertGender((String)this.gender.getSelectedItem()));
        this.pref.setProperty(VOICEAGE, ConfigSingleVoice.convertAge((String)this.age.getSelectedItem()));
        this.pref.setProperty(VOICESTYLE, this.voiceStyle.getText());
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() != this.testVoice) {
            return;
        }
        if (!this.validatePreferences()) {
            return;
        }
        this.savePreferences();
        try {
            String v = (String)this.voice.getSelectedItem();
            int g = ConfigSingleVoice.convertGender((String)this.gender.getSelectedItem());
            int a = ConfigSingleVoice.convertAge((String)this.age.getSelectedItem());
            String s = this.voiceStyle.getText();
            Voice voice = new Voice(v, g, a, s);
            Synthesizer sync = PopsSynthesizer.createSynthesizer(this.pref);
            if (sync != null) {
                sync.getSynthesizerProperties().setVoice(voice);
                sync.speakPlainText(this.sayThis.getText(), null);
            } else {
                Common.showMessage("Error", "Synthesizer could not be created - see console", this);
            }
        }
        catch (IllegalArgumentException e) {
            Common.showMessage("Error", e.toString(), this);
            e.printStackTrace();
        }
        catch (EngineException e) {
            Common.showMessage("Error", e.toString(), this);
            e.printStackTrace();
        }
        catch (AudioException e) {
            Common.showMessage("Error", e.toString(), this);
            e.printStackTrace();
        }
        catch (EngineStateError e) {
            Common.showMessage("Error", e.toString(), this);
            e.printStackTrace();
        }
        catch (PropertyVetoException e) {
            Common.showMessage("Error", e.toString(), this);
            e.printStackTrace();
        }
    }

    private static String convertGender(int gender) {
        switch (gender) {
            case 65535: {
                return "Don't Care";
            }
            case 1: {
                return GENDERFEMALE;
            }
            case 2: {
                return GENDERMALE;
            }
        }
        return "Neutral";
    }

    private static int convertGender(String gender) {
        if (gender.equals("Don't Care")) {
            return 65535;
        }
        if (gender.equals(GENDERFEMALE)) {
            return 1;
        }
        if (gender.equals(GENDERMALE)) {
            return 2;
        }
        return 4;
    }

    private static String convertAge(int age) {
        switch (age) {
            case 1: {
                return AGECHILD;
            }
            case 2: {
                return AGETEENAGER;
            }
            case 4: {
                return AGEYOUNG;
            }
            case 8: {
                return AGEMIDDLE;
            }
            case 16: {
                return AGEOLDER;
            }
            case 65535: {
                return "Don't Care";
            }
        }
        return "Neutral";
    }

    private static int convertAge(String age) {
        if (age.equals("Don't Care")) {
            return 65535;
        }
        if (age.equals(AGECHILD)) {
            return 1;
        }
        if (age.equals(AGETEENAGER)) {
            return 2;
        }
        if (age.equals(AGEYOUNG)) {
            return 4;
        }
        if (age.equals(AGEMIDDLE)) {
            return 8;
        }
        if (age.equals(AGEOLDER)) {
            return 16;
        }
        return 32;
    }

    public static final void PRINTLN(String s) {
        System.out.println(String.valueOf(System.currentTimeMillis()) + " " + s);
    }

    private class VoiceModel
    extends AbstractListModel
    implements ComboBoxModel {
        private String[] voice = new String[0];
        private String selectedItem = "";

        VoiceModel() {
        }

        public void reSync() {
            int oldSize = this.voice.length;
            Voice[] voices = PopsSynthesizer.getVoices(ConfigSingleVoice.this.pref.getStringProperty("synthesizer", null));
            if (voices == null) {
                voices = new Voice[]{};
            }
            String[] newVoice = new String[voices.length];
            boolean found = false;
            int x = newVoice.length - 1;
            while (x >= 0) {
                newVoice[x] = voices[x].getName();
                if (newVoice[x].equals(this.selectedItem)) {
                    found = true;
                }
                --x;
            }
            this.voice = newVoice;
            if (oldSize > 0 && this.voice.length > 0) {
                this.fireContentsChanged(this, 0, Math.min(oldSize, this.voice.length));
            }
            if (oldSize > this.voice.length) {
                this.fireIntervalRemoved(this, this.voice.length, oldSize - 1);
            }
            if (this.voice.length > oldSize) {
                this.fireIntervalAdded(this, oldSize, this.voice.length - 1);
            }
            if (!found) {
                this.selectedItem = "";
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object anItem) {
            this.selectedItem = (String)anItem;
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public int getSize() {
            return this.voice.length;
        }

        public Object getElementAt(int index) {
            return this.voice[index];
        }
    }
}

