/*
 * Decompiled with CFR 0.152.
 */
package popspack.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import popspack.Common;
import popspack.DynamicEditor;
import popspack.Preferences;
import popspack.config.AbstractConfigurationPanel;

public class ConfigEmbeddedEditor
extends AbstractConfigurationPanel
implements ActionListener {
    public static final String EMBEDDEDEDITOR = "embeddededitor";
    private JTextField editor = Common.createJTextField(30);
    private JButton config = Common.createJButton("Configure");

    public ConfigEmbeddedEditor(Preferences pref) {
        super(pref);
        this.editor.setText(pref.getStringProperty(EMBEDDEDEDITOR, ""));
        this.editor.getDocument().addDocumentListener(this);
        this.config.addActionListener(this);
        JPanel line = new JPanel();
        Common.setDefaultAttributes(line, new GridBagLayout());
        line.add((Component)Common.createJLabel("Entry Point to Embed:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.editor, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.config, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)line, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public String getTabTitle() {
        return "Embedded Editor";
    }

    public String getTabToolTip() {
        return "Specification for the Embedded Editor";
    }

    public boolean validatePreferences() {
        if (this.editor.getText().trim().length() == 0) {
            Common.showMessage("Error", "You must specify an editor", this);
            this.editor.requestFocus();
            return false;
        }
        try {
            new DynamicEditor(this.editor.getText());
        }
        catch (InstantiationError e) {
            Common.showMessage("Error", "Cannot instantiate the editor", this);
            return false;
        }
        catch (NoSuchMethodError e) {
            Common.showMessage("Error", "The specified editor does not implement the required methods", this);
            return false;
        }
        return true;
    }

    public void savePreferences() {
        this.pref.setProperty(EMBEDDEDEDITOR, this.editor.getText());
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.validatePreferences()) {
            return;
        }
        try {
            DynamicEditor dynam = new DynamicEditor(this.editor.getText());
            if (dynam.doesMethodExist("configure")) {
                dynam.configure();
            } else {
                Common.showMessage("Warning", "No configuration exists for this editor", this);
            }
        }
        catch (NoSuchMethodError nsm) {
            Common.showMessage("Error", "Editor does not implement the required methods", this);
        }
        catch (InstantiationError ie) {
            Common.showMessage("Error", "Cannot instantiate the editor", this);
        }
    }
}

