/*
 * Decompiled with CFR 0.152.
 */
package popspack.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import popspack.Common;
import popspack.DynamicCodeProcessor;
import popspack.Preferences;
import popspack.config.AbstractConfigurationPanel;

public class ConfigEmbeddedCodeProcessor
extends AbstractConfigurationPanel
implements ActionListener {
    public static final String EMBEDDEDCODEPROCESSOR = "embeddedcodeprocessor";
    private JTextField codeProcessor = Common.createJTextField(30);
    private JButton config = Common.createJButton("Configure");

    public ConfigEmbeddedCodeProcessor(Preferences pref) {
        super(pref);
        this.codeProcessor.setText(pref.getStringProperty(EMBEDDEDCODEPROCESSOR, ""));
        this.codeProcessor.getDocument().addDocumentListener(this);
        this.config.addActionListener(this);
        JPanel line = new JPanel();
        Common.setDefaultAttributes(line, new GridBagLayout());
        line.add((Component)Common.createJLabel("CodeProcessor to embed:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.codeProcessor, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        line.add((Component)this.config, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)line, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public String getTabTitle() {
        return "Embedded CodeProcessor";
    }

    public String getTabToolTip() {
        return "Specification for the Embedded CodeProcessor";
    }

    public boolean validatePreferences() {
        if (this.codeProcessor.getText().trim().length() == 0) {
            Common.showMessage("Error", "You must specify a code processor", this);
            this.codeProcessor.requestFocus();
            return false;
        }
        try {
            new DynamicCodeProcessor(this.codeProcessor.getText());
        }
        catch (InstantiationError e) {
            Common.showMessage("Error", "Cannot instantiate the code processor", this);
            return false;
        }
        return true;
    }

    public void savePreferences() {
        this.pref.setProperty(EMBEDDEDCODEPROCESSOR, this.codeProcessor.getText());
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.validatePreferences()) {
            return;
        }
        try {
            DynamicCodeProcessor dynam = new DynamicCodeProcessor(this.codeProcessor.getText());
            if (dynam.isConfigureDefined()) {
                dynam.configure();
            } else {
                Common.showMessage("Warning", "No configuration has been defined for this CodeProcessor", this);
            }
        }
        catch (InstantiationError ie) {
            Common.showMessage("Error", "Cannot instantiate the code processor", this);
        }
    }
}

