/*
 * Decompiled with CFR 0.152.
 */
package popspack.autologon;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import popspack.Common;
import popspack.autologon.AutoLogonPreferences;
import popspack.config.AbstractConfigurationPanel;

public class ConfigPanel
extends AbstractConfigurationPanel {
    private JTextField handle = Common.createJTextField(30);
    private JTextField password = Common.createJTextField(30);
    private JCheckBox tunnel = Common.createJCheckBox("");
    private JComboBox method = Common.createJComboBox(new String[]{"Robot", "Direct"});
    private JSpinner spinner = Common.createJSpinnerNumeric(3, 20, 1);

    public ConfigPanel(AutoLogonPreferences pref) {
        super(pref);
        this.handle.setText(pref.getHandle());
        this.password.setText(pref.getPassword());
        this.tunnel.setSelected(pref.isTunnel());
        this.method.setSelectedItem(pref.getMethod());
        int spinv = pref.getDelay();
        if (spinv < 3) {
            spinv = 3;
        }
        if (spinv > 20) {
            spinv = 20;
        }
        this.spinner.setValue(new Integer(spinv));
        this.handle.getDocument().addDocumentListener(this);
        this.password.getDocument().addDocumentListener(this);
        this.method.addItemListener(this);
        this.spinner.addChangeListener(this);
        int row = 0;
        this.add((Component)Common.createJLabel("Handle:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.handle, new GridBagConstraints(1, row++, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Password:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.password, new GridBagConstraints(1, row++, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Seconds Delay before logging in:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.spinner, new GridBagConstraints(1, row++, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Method:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.method, new GridBagConstraints(1, row++, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)Common.createJLabel("Tunnel:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.tunnel, new GridBagConstraints(1, row++, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public String getTabTitle() {
        return "General";
    }

    public String getTabToolTip() {
        return "General settings for AutoLogon";
    }

    public boolean validatePreferences() {
        if (this.handle.getText().trim().length() == 0) {
            Common.showMessage("Error", "You must specify a handle", this);
            this.handle.requestFocus();
            return false;
        }
        if (this.password.getText().trim().length() == 0) {
            Common.showMessage("Error", "You must specify a password", this);
            this.password.requestFocus();
            return false;
        }
        return true;
    }

    public void savePreferences() {
        ((AutoLogonPreferences)this.pref).setHandle(this.handle.getText());
        ((AutoLogonPreferences)this.pref).setPassword(this.password.getText());
        ((AutoLogonPreferences)this.pref).setMethod((String)this.method.getSelectedItem());
        ((AutoLogonPreferences)this.pref).setTunnel(this.tunnel.isSelected());
        ((AutoLogonPreferences)this.pref).setDelay(((SpinnerNumberModel)this.spinner.getModel()).getNumber().intValue());
    }
}

