/*
 * Decompiled with CFR 0.152.
 */
package popspack.autologon;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestant.LoginException;
import java.awt.AWTException;
import java.awt.Robot;
import popspack.AbstractEntryPoint;
import popspack.autologon.AutoLogonPreferences;
import popspack.autologon.ConfigPanel;
import popspack.config.ConfigurationDialog;
import popspack.config.ConfigurationInterface;

public class AutoLogon
extends AbstractEntryPoint {
    private AutoLogonPreferences pref;

    public void configure() {
        this.loadPreferences(null);
        new ConfigurationDialog("AutoLogon Configuration", this.pref, new ConfigurationInterface[]{new ConfigPanel(this.pref)}).show();
    }

    public void setContestApplet(ContestApplet ca) {
        this.loadPreferences(null);
        int delay = this.pref.getDelay();
        String handle = this.pref.getHandle();
        char[] password = this.pref.getPassword().toCharArray();
        boolean tunnel = this.pref.isTunnel();
        if (handle.trim().length() == 0 || password.length == 0) {
            return;
        }
        try {
            if (delay > 0) {
                Thread.sleep(delay * 1000);
            }
            LoginMethod method = null;
            method = this.pref.getMethod().equals("Direct") ? new MethodDirect() : new MethodRobot();
            method.login(ca, handle, password, tunnel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isCacheable() {
        return false;
    }

    public void loadPreferences(String name) {
        this.pref = new AutoLogonPreferences(this.getClass().getName());
    }

    interface LoginMethod {
        public void login(ContestApplet var1, String var2, char[] var3, boolean var4);
    }

    class MethodDirect
    implements LoginMethod {
        MethodDirect() {
        }

        public void login(ContestApplet ca, String handle, char[] password, boolean tunnel) {
            try {
                ca.getModel().setTunnel(tunnel);
                ca.getModel().login(handle, password, null);
            }
            catch (LoginException e) {
                e.printStackTrace();
            }
            if (ca.getModel().isLoggedIn()) {
                ca.getRoomManager().loadRoom(3, -1L, 1);
            }
        }
    }

    class MethodRobot
    implements LoginMethod {
        MethodRobot() {
        }

        public void login(ContestApplet ca, String handle, char[] password, boolean tunnel) {
            try {
                Robot robot = new Robot();
                robot.setAutoDelay(15);
                robot.setAutoWaitForIdle(true);
                int x = 0;
                while (x < handle.length()) {
                    this.pressKey(robot, Character.isUpperCase(handle.charAt(x)), Character.toUpperCase(handle.charAt(x)));
                    ++x;
                }
                this.pressKey(robot, false, 9);
                x = 0;
                while (x < password.length) {
                    this.pressKey(robot, Character.isUpperCase(password[x]), Character.toUpperCase(password[x]));
                    ++x;
                }
                this.pressKey(robot, false, 9);
                if (tunnel) {
                    this.pressKey(robot, false, 32);
                }
                this.pressKey(robot, false, 9);
                this.pressKey(robot, false, 32);
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
        }

        private void pressKey(Robot robot, boolean shift, int keyCode) {
            if (shift) {
                robot.keyPress(16);
            }
            robot.keyPress(keyCode);
            robot.keyRelease(keyCode);
            if (shift) {
                robot.keyRelease(16);
            }
        }
    }
}

