/*
 * Decompiled with CFR 0.152.
 */
package popspack.autodownload;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import popspack.Common;
import popspack.Preferences;
import popspack.autodownload.DownloadClass;
import popspack.autodownload.DownloadManager;
import popspack.config.AbstractConfigurationPanel;

public class DownloadManagerConfig
extends AbstractConfigurationPanel
implements ItemListener {
    private JTable downloads = Common.createJTable();
    private MyModel downloadsModel = new MyModel((Object[])new String[]{"From URL", "Local File"});
    private JButton addDownload = Common.createJButton("Add", new Dimension(60, 21));
    private JButton deleteDownload = Common.createJButton("Delete", new Dimension(80, 21));
    private JButton browse = Common.createJButton("Browse", new Dimension(80, 21));
    private JButton tryIt = Common.createJButton("TryIt", new Dimension(60, 21));

    public DownloadManagerConfig(Preferences pref) {
        super(pref);
        Common.setDefaultAttributes(this, new BorderLayout());
        this.downloads.setModel(this.downloadsModel);
        this.addDownload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadManagerConfig.this.stopEditing();
                DownloadManagerConfig.this.savePending();
                DownloadManagerConfig.this.downloadsModel.addRow(new String[]{"", ""});
            }
        });
        this.deleteDownload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadManagerConfig.this.stopEditing();
                int row = DownloadManagerConfig.this.downloads.getSelectedRow();
                if (row >= 0) {
                    DownloadManagerConfig.this.savePending();
                    DownloadManagerConfig.this.downloadsModel.removeRow(row);
                } else {
                    JOptionPane.showMessageDialog(DownloadManagerConfig.this, "Please choose a row to delete");
                }
            }
        });
        this.tryIt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadManagerConfig.this.stopEditing();
                int row = DownloadManagerConfig.this.downloads.getSelectedRow();
                if (row >= 0) {
                    if (DownloadManagerConfig.this.validatePreferences(row)) {
                        try {
                            DownloadClass dwc = new DownloadClass(new URL((String)DownloadManagerConfig.this.downloadsModel.getValueAt(row, 0)), new File((String)DownloadManagerConfig.this.downloadsModel.getValueAt(row, 1)));
                            dwc.executeDownload();
                            JOptionPane.showMessageDialog(DownloadManagerConfig.this, "Success!");
                        }
                        catch (MalformedURLException e1) {
                            e1.printStackTrace();
                            JOptionPane.showMessageDialog(DownloadManagerConfig.this, e1.toString());
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(DownloadManagerConfig.this, e1.toString());
                        }
                    } else {
                        JOptionPane.showMessageDialog(DownloadManagerConfig.this, "Either the fromURL or local file is not valid");
                    }
                } else {
                    JOptionPane.showMessageDialog(DownloadManagerConfig.this, "Please choose a row to try");
                }
            }
        });
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DownloadManagerConfig.this.stopEditing();
                int row = DownloadManagerConfig.this.downloads.getSelectedRow();
                if (row >= 0) {
                    JFileChooser file = new JFileChooser();
                    int returnVal = file.showOpenDialog(DownloadManagerConfig.this);
                    if (returnVal == 0) {
                        DownloadManagerConfig.this.downloadsModel.setValueAt(file.getSelectedFile().getAbsolutePath(), row, 1);
                    }
                } else {
                    JOptionPane.showMessageDialog(DownloadManagerConfig.this, "Please choose a row and column to browse for");
                }
            }
        });
        JPanel downloadButtons = new JPanel();
        Common.setDefaultAttributes(downloadButtons, new GridBagLayout());
        downloadButtons.add((Component)this.addDownload, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        downloadButtons.add((Component)this.deleteDownload, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 3, new Insets(0, 5, 0, 5), 0, 0));
        downloadButtons.add((Component)this.browse, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 3, new Insets(0, 5, 0, 5), 0, 0));
        downloadButtons.add((Component)this.tryIt, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 18, 3, new Insets(0, 5, 0, 5), 0, 0));
        JPanel downloadPanel = new JPanel();
        Common.setDefaultAttributes(downloadPanel, new GridBagLayout());
        downloadPanel.add((Component)Common.createJLabel("Jar files to keep in sync"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 55), 0, 0));
        downloadPanel.add((Component)downloadButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        downloadPanel.add((Component)Common.createJScrollPane(this.downloads), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(downloadPanel);
        this.loadURLS();
    }

    public void stopEditing() {
        if (this.downloads.isEditing()) {
            this.downloads.getCellEditor().stopCellEditing();
        }
    }

    public void loadURLS() {
        int numDownloads = this.pref.getIntegerProperty("numdownloads", 0);
        int x = 0;
        while (x < numDownloads) {
            String download = this.pref.getStringProperty(DownloadManager.encodeKey("download", x), "");
            if (download != null && download.length() != 0) {
                try {
                    DownloadClass cls = DownloadClass.decode(download);
                    this.downloadsModel.addRow(new String[]{cls.getFromURL().toString(), cls.getFile().getAbsolutePath()});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++x;
        }
    }

    public String getTabTitle() {
        return "Sync";
    }

    public String getTabToolTip() {
        return "JAR Files to Sync";
    }

    public boolean validatePreferences() {
        this.stopEditing();
        int x = 0;
        while (x < this.downloadsModel.getRowCount()) {
            if (!this.validatePreferences(x)) {
                return false;
            }
            ++x;
        }
        return true;
    }

    public boolean validatePreferences(int row) {
        try {
            String url = (String)this.downloadsModel.getValueAt(row, 0);
            if (url == null || url.length() == 0) {
                JOptionPane.showMessageDialog(this, "You must specify the fromURL");
                return false;
            }
            String file = (String)this.downloadsModel.getValueAt(row, 1);
            if (file == null || file.length() == 0) {
                JOptionPane.showMessageDialog(this, "You must specify the fromURL");
                return false;
            }
            new URL(url);
            new File(file).exists();
        }
        catch (MalformedURLException e1) {
            JOptionPane.showMessageDialog(this, e1.toString());
            return false;
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, e1.toString());
            return false;
        }
        return true;
    }

    public void savePreferences() {
        int ct = 0;
        int row = 0;
        while (row < this.downloadsModel.getRowCount()) {
            block3: {
                DownloadClass dwc;
                try {
                    dwc = new DownloadClass(new URL((String)this.downloadsModel.getValueAt(row, 0)), new File((String)this.downloadsModel.getValueAt(row, 1)));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    break block3;
                }
                this.pref.setProperty(DownloadManager.encodeKey("download", row), DownloadClass.encode(dwc));
                ++ct;
            }
            ++row;
        }
        this.pref.setProperty("numdownloads", ct);
    }

    public void itemStateChanged(ItemEvent e) {
        this.savePending();
    }

    class MyModel
    extends DefaultTableModel {
        public MyModel(Object[] columnNames) {
            int x = 0;
            while (x < columnNames.length) {
                this.addColumn(columnNames[x]);
                ++x;
            }
        }

        public void setValueAt(Object obj, int row, int col) {
            super.setValueAt(obj, row, col);
            DownloadManagerConfig.this.savePending();
        }
    }
}

