/*
 * Decompiled with CFR 0.152.
 */
package popspack.autodownload;

import popspack.AbstractEntryPoint;
import popspack.Preferences;
import popspack.autodownload.DownloadClass;
import popspack.autodownload.DownloadManagerConfig;
import popspack.config.ConfigurationDialog;
import popspack.config.ConfigurationInterface;

public class DownloadManager
extends AbstractEntryPoint {
    private Preferences pref = null;
    public static final String NUMDOWNLOAD = "numdownloads";
    public static final String DOWNLOAD = "download";

    public void loadPreferences(String name) {
        this.pref = new Preferences(this.getClass().getName());
    }

    public void startUsing() {
        if (this.pref == null) {
            this.loadPreferences(null);
        }
        if (this.pref == null) {
            return;
        }
        int numDownloads = this.pref.getIntegerProperty(NUMDOWNLOAD, 0);
        int x = 0;
        while (x < numDownloads) {
            String download = this.pref.getStringProperty(DownloadManager.encodeKey(DOWNLOAD, x), "");
            if (download != null && download.length() != 0) {
                try {
                    DownloadClass.decode(download).executeDownload();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++x;
        }
    }

    public static String encodeKey(String key, int x) {
        return String.valueOf(key) + x;
    }

    public void configure() {
        new ConfigurationDialog("AutoLogon Configuration", this.pref, new ConfigurationInterface[]{new DownloadManagerConfig(this.pref)}).show();
    }
}

