/*
 * Decompiled with CFR 0.152.
 */
package popspack.autodownload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

class DownloadClass {
    private URL fromURL;
    private File file;
    public static final String SEPARATOR = ",";

    public DownloadClass(URL fromURL, File file) {
        this.fromURL = fromURL;
        this.file = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeDownload() throws IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            URLConnection fromConn = this.fromURL.openConnection();
            fromConn.setDoInput(true);
            fromConn.connect();
            System.out.println(fromConn.getLastModified());
            if (!this.file.exists() || fromConn.getLastModified() > this.file.lastModified()) {
                if (!this.file.exists()) {
                    this.file.createNewFile();
                }
                System.out.println("Updating: " + this.file + " from " + this.fromURL);
                int BUFFERSIZE = 2048;
                in = new BufferedInputStream(fromConn.getInputStream(), 2048);
                out = new BufferedOutputStream(new FileOutputStream(this.file, false));
                byte[] buffer = new byte[2048];
                while (true) {
                    int len;
                    if ((len = in.read(buffer, 0, 2048)) < 0) {
                        out.flush();
                        out.close();
                        out = null;
                        this.file.setLastModified(fromConn.getLastModified());
                        break;
                    }
                    out.write(buffer, 0, len);
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (in != null) {
                    in.close();
                }
                if (out == null) throw throwable;
                out.flush();
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {
            return;
        }
        if (in != null) {
            in.close();
        }
        if (out == null) return;
        out.flush();
        out.close();
    }

    public URL getFromURL() {
        return this.fromURL;
    }

    public File getFile() {
        return this.file;
    }

    public static String encode(DownloadClass dc) {
        return String.valueOf(dc.getFromURL().toExternalForm()) + SEPARATOR + dc.getFile().toURI().toASCIIString();
    }

    public static DownloadClass decode(String s) {
        StringTokenizer str = new StringTokenizer(s, SEPARATOR);
        if (str.countTokens() != 2) {
            return null;
        }
        try {
            URL fromURL = new URL(str.nextToken());
            File file = new File(new URI(str.nextToken()));
            return new DownloadClass(fromURL, file);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setFromURL(URL fromURL) {
        this.fromURL = fromURL;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

