/*
 * Decompiled with CFR 0.152.
 */
package popspack;

import com.topcoder.client.contestApplet.common.LocalPreferences;
import java.io.IOException;
import java.util.Observer;

public class Preferences {
    private static LocalPreferences pref = LocalPreferences.getInstance();
    private Observer notify;
    public String name;

    public Preferences(String name) {
        this(name, null);
    }

    public Preferences(String name, Observer notify) {
        this.notify = notify;
        this.setName(name.endsWith(".") ? name : String.valueOf(name) + ".");
        if (notify != null) {
            pref.addSaveObserver(notify);
        }
    }

    public void addObserver(Observer s) {
        pref.addSaveObserver(s);
    }

    public void removeObserver(Observer s) {
        pref.removeSaveObserver(s);
    }

    public void restore() {
        try {
            pref.reload();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void finalize() {
        if (this.notify != null) {
            pref.removeSaveObserver(this.notify);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final String getStringProperty(String key, String defaultValue) {
        String value = pref.getProperty(String.valueOf(this.name) + key);
        return value == null ? (defaultValue == null ? null : defaultValue.trim()) : value.trim();
    }

    public final void setProperty(String key, String value) {
        if (value == null) {
            value = "";
        }
        pref.setProperty(String.valueOf(this.name) + key, value);
    }

    public final void setProperty(String key, int value) {
        pref.setProperty(String.valueOf(this.name) + key, String.valueOf(value));
    }

    public final void setProperty(String key, float value) {
        pref.setProperty(String.valueOf(this.name) + key, String.valueOf(value));
    }

    public final void setProperty(String key, boolean value) {
        pref.setProperty(String.valueOf(this.name) + key, value ? "true" : "false");
    }

    public final boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = pref.getProperty(String.valueOf(this.name) + key);
        return value == null || value.equals("") ? defaultValue : value.equals("true");
    }

    public final int getIntegerProperty(String key, int defaultValue) {
        String value = pref.getProperty(String.valueOf(this.name) + key);
        if (value == null || value.equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public final float getFloatValue(String key, float defaultValue) {
        String value = pref.getProperty(String.valueOf(this.name) + key);
        if (value == null || value.equals("")) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void save() throws IOException {
        pref.savePreferences();
    }
}

