/*
 * Decompiled with CFR 0.152.
 */
package popspack;

import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.speech.AudioException;
import javax.speech.Central;
import javax.speech.EngineException;
import javax.speech.EngineList;
import javax.speech.EngineModeDesc;
import javax.speech.EngineStateError;
import javax.speech.synthesis.SpeakableListener;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.Voice;
import popspack.Logger;
import popspack.Preferences;

public class PopsSynthesizer
implements Observer {
    private Preferences pref;
    private Synthesizer synth;
    private static Map syn = new HashMap();

    public PopsSynthesizer(Preferences pref) {
        this.pref = pref;
        pref.addObserver(this);
        this.update(null, null);
    }

    public PopsSynthesizer(Preferences pref, SpeakableListener listener) {
        this.pref = pref;
        pref.addObserver(this);
        this.update(null, null);
        if (this.synth != null) {
            this.synth.addSpeakableListener(listener);
        }
    }

    public void update(Observable o, Object arg) {
        try {
            this.synth = PopsSynthesizer.createSynthesizer(this.pref);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        catch (AudioException e) {
            e.printStackTrace();
        }
        catch (EngineStateError e) {
            e.printStackTrace();
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public void speak(CharSequence c) {
        this.speak(c, false);
    }

    public void speak(CharSequence c, boolean interrupt) {
        if (this.synth == null) {
            Logger.getInstance().log("Error - a null synthesizer", 2);
        } else {
            System.out.println("Speaking: " + c);
            Logger.getInstance().log("Speaking: " + c, 0);
            if (interrupt) {
                this.synth.cancelAll();
            }
            this.synth.speakPlainText(c.toString(), null);
        }
    }

    public static synchronized PopsSynthesizer getInstance(String name) {
        PopsSynthesizer popsSynth = (PopsSynthesizer)syn.get(name);
        if (popsSynth == null) {
            popsSynth = new PopsSynthesizer(new Preferences(name));
            syn.put(name, popsSynth);
        }
        return popsSynth;
    }

    public static final SynthesizerModeDesc[] getEngines() {
        EngineList list = Central.availableSynthesizers((EngineModeDesc)new EngineModeDesc(Locale.US));
        return (SynthesizerModeDesc[])list.toArray((Object[])new SynthesizerModeDesc[0]);
    }

    public static final Voice[] getVoices(String engineName) {
        if (engineName == null) {
            return null;
        }
        EngineList list = Central.availableSynthesizers((EngineModeDesc)new EngineModeDesc(Locale.US));
        int x = list.size() - 1;
        while (x >= 0) {
            SynthesizerModeDesc des = (SynthesizerModeDesc)list.get(x);
            if (des.getEngineName().equals(engineName)) {
                return des.getVoices();
            }
            --x;
        }
        return null;
    }

    public static final Synthesizer createSynthesizer(Preferences pref) throws IllegalArgumentException, EngineException, AudioException, EngineStateError, PropertyVetoException {
        String synName = pref.getStringProperty("synthesizer", null);
        if (synName == null || synName.trim().length() == 0) {
            return null;
        }
        int pitchRange = pref.getIntegerProperty("pitchrange", 10);
        int pitch = pref.getIntegerProperty("pitch", 100);
        int speakingRate = pref.getIntegerProperty("speakingrate", 150);
        float volume = (float)pref.getIntegerProperty("volume", 10) / 20.0f + 0.5f;
        SynthesizerModeDesc desc = new SynthesizerModeDesc(synName, null, Locale.US, Boolean.FALSE, null);
        Synthesizer synthesizer = Central.createSynthesizer((EngineModeDesc)desc);
        if (synthesizer == null) {
            return null;
        }
        if ((synthesizer.getEngineState() & 4L) != 4L) {
            Logger.getInstance().log("Allocating a synthesizer", 0);
            synthesizer.allocate();
        }
        synthesizer.getSynthesizerProperties().setPitchRange((float)pitchRange);
        synthesizer.getSynthesizerProperties().setPitch((float)pitch);
        synthesizer.getSynthesizerProperties().setSpeakingRate((float)speakingRate);
        synthesizer.getSynthesizerProperties().setVolume(volume);
        return synthesizer;
    }
}

