/*
 * Decompiled with CFR 0.152.
 */
package popspack;

import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Renderer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import popspack.Logger;

public class DynamicCodeProcessor {
    private Object processor = null;
    private HashMap methodCache = new HashMap();
    public static final String CONFIGURE = "configure";
    public static final String PREPROCESS = "preProcess";
    public static final String POSTPROCESS = "postProcess";
    public static final String GETUSERDEFINEDTAGS = "getUserDefinedTags";
    private String codeProcessorName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public DynamicCodeProcessor() {
    }

    public DynamicCodeProcessor(String codeProcessor) throws InstantiationError {
        this.setProcessor(codeProcessor);
    }

    public void setProcessor(String codeProcessor) throws InstantiationError {
        Class<?> codeProcessorClass;
        if (codeProcessor == null) {
            throw this.instantiationError("Null CodeProcessor", "Null CodeProcessor");
        }
        try {
            codeProcessorClass = Class.forName(codeProcessor);
        }
        catch (ClassNotFoundException e) {
            throw this.instantiationError(codeProcessor, e.toString());
        }
        Class[] classArray = new Class[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ljava.lang.String;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lcom.topcoder.client.contestant.ProblemComponentModel;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lcom.topcoder.shared.language.Language;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("[Lcom.topcoder.shared.problem.Renderer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        this.methodCache.put(PREPROCESS, this.getMethod(codeProcessorClass, PREPROCESS, classArray));
        Class[] classArray2 = new Class[2];
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("[Ljava.lang.String;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz5;
        Class<?> clazz6 = class$2;
        if (clazz6 == null) {
            try {
                clazz6 = class$2 = Class.forName("[Lcom.topcoder.shared.language.Language;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz6;
        this.methodCache.put(POSTPROCESS, this.getMethod(codeProcessorClass, POSTPROCESS, classArray2));
        this.methodCache.put(GETUSERDEFINEDTAGS, this.getMethod(codeProcessorClass, GETUSERDEFINEDTAGS, new Class[0]));
        this.methodCache.put(CONFIGURE, this.getMethod(codeProcessorClass, CONFIGURE, new Class[0]));
        try {
            this.processor = codeProcessorClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw this.instantiationError(codeProcessor, e.toString());
        }
        catch (InstantiationException e) {
            throw this.instantiationError(codeProcessor, e.toString());
        }
        this.codeProcessorName = codeProcessor;
    }

    public String getCodeProcessorName() {
        return this.codeProcessorName;
    }

    public boolean doesMethodExist(String methodName) {
        return this.methodCache.get(methodName) != null;
    }

    public boolean isConfigureDefined() {
        return this.methodCache.get(CONFIGURE) != null;
    }

    public boolean isPreProcessDefined() {
        return this.methodCache.get(PREPROCESS) != null;
    }

    public boolean isPostProcessDefined() {
        return this.methodCache.get(POSTPROCESS) != null;
    }

    public boolean isUserDefinedTagsDefined() {
        return this.methodCache.get(GETUSERDEFINEDTAGS) != null;
    }

    public String preProcess(String source, ProblemComponentModel component, Language language, Renderer renderer) {
        try {
            if (this.methodCache.get(PREPROCESS) == null) {
                return source;
            }
            return (String)this.invokeMethod(PREPROCESS, new Object[]{source, component, language, renderer});
        }
        catch (ClassCastException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.lang.String;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.printBadRC(PREPROCESS, clazz.toString());
            return null;
        }
    }

    public String postProcess(String source, Language language) {
        try {
            if (this.methodCache.get(POSTPROCESS) == null) {
                return source;
            }
            return (String)this.invokeMethod(POSTPROCESS, new Object[]{source, language});
        }
        catch (ClassCastException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Ljava.lang.String;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.printBadRC(POSTPROCESS, clazz.toString());
            return null;
        }
    }

    public Map getUserDefinedTags() {
        try {
            if (this.methodCache.get(GETUSERDEFINEDTAGS) == null) {
                return new HashMap();
            }
            return (Map)this.invokeMethod(GETUSERDEFINEDTAGS, new Object[0]);
        }
        catch (ClassCastException e) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("[Ljava.util.Map;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.printBadRC(GETUSERDEFINEDTAGS, clazz.toString());
            return null;
        }
    }

    public void configure() {
        if (this.methodCache.get(CONFIGURE) == null) {
            return;
        }
        this.invokeMethod(CONFIGURE, new Object[0]);
    }

    private final Object invokeMethod(String methodName, Object[] parms) {
        if (this.methodCache == null || this.processor == null) {
            return null;
        }
        try {
            Method mthd = (Method)this.methodCache.get(methodName);
            return mthd == null ? null : mthd.invoke(this.processor, parms);
        }
        catch (Exception e) {
            Logger.getInstance().log("Error invoking method " + methodName + "(" + Arrays.asList(parms).toString() + ")", 2);
            e.fillInStackTrace().printStackTrace();
            return null;
        }
    }

    private final Method getMethod(Class pluginClass, String methodName, Class[] parms) {
        try {
            Method method = pluginClass.getMethod(methodName, parms);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private final void printBadClassPath(String pluginName, String classPath) {
        StringBuffer str = new StringBuffer("The classpath ");
        str.append(classPath);
        str.append(" for the plugin ");
        str.append(pluginName);
        str.append(" threw a MalFormedURLException and will be ignored.");
        Logger.getInstance().log(str.toString(), 2);
    }

    private final void printBadRC(String methodName, String expected) {
        StringBuffer str = new StringBuffer("Method ");
        str.append(methodName);
        str.append(" did not return an object of type ");
        str.append(expected);
        str.append(".  Returned object ignored.");
        System.err.println(str.toString());
    }

    private final NoSuchMethodError noSuchMethod(String methodName) {
        StringBuffer str = new StringBuffer("Required Method: ");
        str.append(methodName);
        str.append(" is not defined by the editor plugin.");
        NoSuchMethodError error = new NoSuchMethodError(str.toString());
        error.fillInStackTrace().printStackTrace();
        return error;
    }

    private final InstantiationError instantiationError(String className, String reason) {
        StringBuffer str = new StringBuffer("Cannot instantiate ");
        str.append(className);
        str.append(". ");
        str.append(reason);
        InstantiationError error = new InstantiationError(str.toString());
        error.fillInStackTrace().printStackTrace();
        return error;
    }
}

