/*
 * Decompiled with CFR 0.152.
 */
package popspack;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class Common {
    public static final Color FG_COLOR = Color.white;
    public static final Color BG_COLOR = Color.black;
    public static final Color WPB_COLOR = Color.decode("0x333333");
    public static final Color TF_COLOR = Color.white;
    public static final Color TB_COLOR = Color.black;
    public static final Color HF_COLOR = Color.white;
    public static final Color HB_COLOR = Color.decode("0x003300");
    public static final Font DEFAULTFONT = new Font("SansSerif", 0, 12);
    static /* synthetic */ Class class$0;

    public static final JTable createJTable() {
        JTable table = new JTable();
        table.setBackground(TB_COLOR);
        table.setForeground(TF_COLOR);
        table.setSelectionBackground(HB_COLOR);
        table.setSelectionForeground(HF_COLOR);
        table.setShowGrid(false);
        return table;
    }

    public static final JSlider createJSlider(int o, int min, int max, int minor, int major) {
        JSlider slider = new JSlider(min, max);
        slider.setOrientation(o);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setPaintTrack(true);
        slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        slider.setBackground(WPB_COLOR);
        slider.setMinorTickSpacing(minor);
        slider.setMajorTickSpacing(major);
        return slider;
    }

    public static final JSpinner createJSpinnerNumeric(int min, int max, int step) {
        SpinnerNumberModel mod = new SpinnerNumberModel(min, min, max, step);
        JSpinner temp = new JSpinner(mod);
        temp.setForeground(FG_COLOR);
        temp.setBackground(WPB_COLOR);
        return temp;
    }

    public static final JCheckBox createJCheckBox(String text) {
        JCheckBox temp = new JCheckBox(text);
        temp.setForeground(FG_COLOR);
        temp.setBackground(WPB_COLOR);
        temp.setHorizontalAlignment(4);
        temp.setHorizontalTextPosition(10);
        return temp;
    }

    public static final JComboBox createJComboBox(String[] text) {
        JComboBox<String> temp = new JComboBox<String>(text);
        temp.setForeground(FG_COLOR);
        temp.setBackground(WPB_COLOR);
        return temp;
    }

    public static final JLabel createJLabel(String text) {
        return Common.createJLabel(text, DEFAULTFONT);
    }

    public static final JLabel createJLabel(String text, Font font) {
        return Common.createJLabel(text, null, 2, font);
    }

    public static final JLabel createJLabel(String text, Dimension size) {
        return Common.createJLabel(text, size, 2, DEFAULTFONT);
    }

    public static final JLabel createJLabel(String text, Dimension size, int alignment) {
        return Common.createJLabel(text, size, alignment, DEFAULTFONT);
    }

    public static final JLabel createJLabel(String text, Dimension size, int alignment, Font font) {
        JLabel temp = new JLabel(text);
        temp.setForeground(FG_COLOR);
        temp.setBackground(WPB_COLOR);
        temp.setFont(font);
        temp.setHorizontalAlignment(alignment);
        if (size != null) {
            temp.setMinimumSize(size);
            temp.setPreferredSize(size);
            temp.setMaximumSize(size);
        }
        return temp;
    }

    public static final JTextField createJTextField(int size) {
        JTextField temp = new JTextField(size);
        temp.setForeground(FG_COLOR);
        temp.setBackground(BG_COLOR);
        temp.setCaretColor(FG_COLOR);
        temp.setFont(DEFAULTFONT);
        temp.setBorder(BorderFactory.createLineBorder(FG_COLOR, 1));
        temp.addFocusListener(new SelectAll(temp));
        return temp;
    }

    public static final JTextField createJTextField(int size, Dimension max) {
        return Common.createJTextField(size, max, DEFAULTFONT);
    }

    public static final JTextField createJTextField(int size, Dimension max, Font font) {
        JTextField temp = new JTextField(size);
        temp.setForeground(FG_COLOR);
        temp.setBackground(BG_COLOR);
        temp.setCaretColor(FG_COLOR);
        temp.setFont(font);
        temp.setBorder(BorderFactory.createLineBorder(FG_COLOR, 1));
        temp.setMaximumSize(max);
        temp.addFocusListener(new SelectAll(temp));
        return temp;
    }

    public static final JTextField createNumericTextField() {
        JTextField field = Common.createJTextField(3);
        field.setDocument(new PlainDocument(){

            public void insertString(int off, String str, AttributeSet a) throws BadLocationException {
                try {
                    Integer.parseInt(str);
                    super.insertString(off, str, a);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        return field;
    }

    public static final JComboBox createComboBox(String[] items) {
        JComboBox<String> temp = new JComboBox<String>(items);
        temp.setBorder(BorderFactory.createLineBorder(FG_COLOR, 1));
        temp.addFocusListener(new SelectAll((JTextField)temp.getEditor().getEditorComponent()));
        return temp;
    }

    public static final JScrollPane createJScrollPane(Component a) {
        return Common.createJScrollPane(a, null, null);
    }

    public static final JScrollPane createJScrollPane(Component a, Dimension size) {
        return Common.createJScrollPane(a, size, null);
    }

    public static final JScrollPane createJScrollPane(Component a, Dimension size, Border border) {
        JScrollPane temp = new JScrollPane(a);
        temp.setBackground(WPB_COLOR);
        temp.getViewport().setBackground(WPB_COLOR);
        if (size != null) {
            temp.getViewport().setPreferredSize(size);
        }
        if (border != null) {
            temp.setBorder(border);
        }
        return temp;
    }

    public static final void setDefaultAttributes(Container panel) {
        Common.setDefaultAttributes(panel, new BorderLayout());
    }

    public static final void setDefaultAttributes(Container panel, LayoutManager layout) {
        panel.setLayout(layout);
        panel.setBackground(WPB_COLOR);
    }

    public static final JButton createJButton(String text) {
        return Common.createJButton(text, null, DEFAULTFONT);
    }

    public static final JButton createJButton(String text, Dimension size) {
        return Common.createJButton(text, size, DEFAULTFONT);
    }

    public static final JButton createJButton(String text, Font font) {
        return Common.createJButton(text, null, font);
    }

    public static final JButton createJButton(String text, Dimension size, Font font) {
        JButton temp = new JButton(text);
        temp.setFont(font);
        if (size != null) {
            temp.setMinimumSize(size);
            temp.setPreferredSize(size);
            temp.setMaximumSize(size);
        }
        return temp;
    }

    public static final JButton createJButtonImage(String imageName) {
        JButton temp = new JButton();
        Icon icon = Common.getIcon(imageName, temp);
        temp.setIcon(icon);
        temp.setSize(icon.getIconWidth(), icon.getIconHeight());
        temp.setBorderPainted(false);
        temp.setContentAreaFilled(false);
        System.out.println(temp.getSize());
        return temp;
    }

    public static void showMessage(String title, String msg, Component comp) {
        JOptionPane.showMessageDialog(comp, msg, title, 1);
    }

    public static boolean confirm(String title, String msg, Component comp) {
        int choice = JOptionPane.showConfirmDialog(comp, msg, title, 0, 2);
        return choice == 0;
    }

    public static String input(String title, String msg, Component comp) {
        String value = JOptionPane.showInputDialog(comp, msg, title, 3);
        return value;
    }

    public static Icon getIcon(String name, Component comp) {
        MediaTracker trk = new MediaTracker(comp);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lpopspack.Common;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ImageIcon icon = new ImageIcon(clazz.getResource("images/" + name));
        trk.addImage(icon.getImage(), 0);
        try {
            trk.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return icon;
    }

    private static class SelectAll
    extends FocusAdapter {
        JTextComponent parent;

        public SelectAll(JTextComponent parent) {
            this.parent = parent;
        }

        public void focusGained(FocusEvent e) {
            this.parent.selectAll();
        }
    }
}

