/*
 * Decompiled with CFR 0.152.
 */
package fileedit;

import com.topcoder.client.contestApplet.common.LocalPreferences;
import java.io.IOException;
import java.util.Observer;

public class Preferences {
    private static LocalPreferences pref = LocalPreferences.getInstance();
    private Observer notify;
    public static final String JAVATEMPLATE = "fileeditor.config.javatemplate";
    public static final String CPPTEMPLATE = "fileeditor.config.cpptemplate";
    public static final String CSHARPTEMPLATE = "fileeditor.config.csharptemplate";
    public static final String JAVAEXTENSION = "fileeditor.config.javaextension";
    public static final String CPPEXTENSION = "fileeditor.config.cppextension";
    public static final String CSHARPEXTENSION = "fileeditor.config.csharpextension";
    public static final String DIRNAMEKEY = "fileeditor.config.dirName";
    public static final String FILENAMEKEY = "fileeditor.config.fileName";
    public static final String OVERRIDEFILENAME = "fileeditor.config.overrideFileName";
    public static final String PROVIDEBREAKS = "fileeditor.config.provideBreaks";
    public static final String BREAKAT = "fileeditor.config.breakAt";
    public static final String LINECOMMENTS = "fileeditor.config.lineComments";
    public static final String BEGINCUT = "fileeditor.config.beginCut";
    public static final String ENDCUT = "fileeditor.config.endCut";
    public static final String PROBDESCFILEWRITE = "fileeditor.config.probdescfilewrite";
    public static final String PROBDESCFILEEXTENSION = "fileeditor.config.probdescfileextnsion";
    public static final String SIGNATUREFILENAME = "fileeditor.config.signaturefilename";
    public static final String POWEREDBY = "fileeditor.config.poweredby";
    public static final String HTMLDESC = "fileeditor.config.htmldesc";
    public static final String BACKUP = "fileeditor.config.backup";

    public Preferences() {
    }

    public Preferences(Observer notify) {
        this.notify = notify;
        pref.addSaveObserver(notify);
    }

    public void finalize() {
        if (this.notify != null) {
            pref.removeSaveObserver(this.notify);
        }
    }

    public String getJAVATemplate() {
        return this.getStringProperty(JAVATEMPLATE, "$BEGINCUT$\n$PROBLEMDESC$\n$ENDCUT$\nimport java.util.*;\npublic class $CLASSNAME$ {\n\tpublic $RC$ $METHODNAME$($METHODPARMS$) {\n\t\t\n\t}\n\tpublic static void main(String[] args) {\n\t\t$CLASSNAME$ temp = new $CLASSNAME$();\n\t\tSystem.out.println(temp.$METHODNAME$($METHODPARMS$));\n\t}\n}");
    }

    public String getJAVAExtension() {
        return this.getStringProperty(JAVAEXTENSION, "java");
    }

    public final String getCSHARPTemplate() {
        return this.getStringProperty(CSHARPTEMPLATE, "using System;\r\nusing System.Collections;\r\npublic class $CLASSNAME$ {\r\n\tpublic $RC$ $METHODNAME$($METHODPARMS$) {\r\n\t\t$CARETPOSITION$\r\n\t}\r\n}");
    }

    public String getCSHARPExtension() {
        return this.getStringProperty(CSHARPEXTENSION, "cs");
    }

    public String getCPPTemplate() {
        return this.getStringProperty(CPPTEMPLATE, "$BEGINCUT$\n$PROBLEMDESC$\n$ENDCUT$\n#line $NEXTLINENUMBER$ \"$FILENAME$\"\n#include <string>\n#include <vector>\nclass $CLASSNAME$ {\n\tpublic:\n\t$RC$ $METHODNAME$($METHODPARMS$) {\n\t\t\n\t}\n};");
    }

    public String getCPPExtension() {
        return this.getStringProperty(CPPEXTENSION, "cpp");
    }

    public String getDirectoryName() {
        return this.getStringProperty(DIRNAMEKEY, ".");
    }

    public String getFileName() {
        return this.getStringProperty(FILENAMEKEY, "problem");
    }

    public String getSignatureFileName() {
        return this.getStringProperty(SIGNATUREFILENAME, "");
    }

    public String getBeginCut() {
        return this.getStringProperty(BEGINCUT, "// BEGIN CUT HERE");
    }

    public String getEndCut() {
        return this.getStringProperty(ENDCUT, "// END CUT HERE");
    }

    public String getProblemDescExtension() {
        return this.getStringProperty(PROBDESCFILEEXTENSION, "txt");
    }

    public boolean isOverrideFileName() {
        return this.getBooleanProperty(OVERRIDEFILENAME, false);
    }

    public boolean isProvideBreaks() {
        return this.getBooleanProperty(PROVIDEBREAKS, false);
    }

    public boolean isLineComments() {
        return this.getBooleanProperty(LINECOMMENTS, true);
    }

    public boolean isWriteProblemDescFile() {
        return this.getBooleanProperty(PROBDESCFILEWRITE, false);
    }

    public boolean isPoweredBy() {
        return this.getBooleanProperty(POWEREDBY, true);
    }

    public boolean isHTMLDesc() {
        return this.getBooleanProperty(HTMLDESC, false);
    }

    public boolean isBackup() {
        return this.getBooleanProperty(BACKUP, true);
    }

    public int getBreakAt() {
        String value = pref.getProperty(BREAKAT);
        if (value == null || value.equals("")) {
            return 60;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 60;
        }
    }

    public void setJAVATemplate(String template) {
        pref.setProperty(JAVATEMPLATE, template);
    }

    public void setCPPTemplate(String template) {
        pref.setProperty(CPPTEMPLATE, template);
    }

    public void setCSHARPTemplate(String template) {
        pref.setProperty(CSHARPTEMPLATE, template);
    }

    public void setJAVAExtension(String extension) {
        pref.setProperty(JAVAEXTENSION, extension);
    }

    public void setCPPExtension(String extension) {
        pref.setProperty(CPPEXTENSION, extension);
    }

    public void setCSHARPExtension(String extension) {
        pref.setProperty(CSHARPEXTENSION, extension);
    }

    public void setDirectoryName(String text) {
        pref.setProperty(DIRNAMEKEY, text);
    }

    public void setFileName(String text) {
        pref.setProperty(FILENAMEKEY, text);
    }

    public void setBeginCut(String text) {
        pref.setProperty(BEGINCUT, text);
    }

    public void setEndCut(String text) {
        pref.setProperty(ENDCUT, text);
    }

    public void setSignatureFileName(String text) {
        pref.setProperty(SIGNATUREFILENAME, text);
    }

    public void setProblemDescExtension(String text) {
        pref.setProperty(PROBDESCFILEEXTENSION, text);
    }

    public void setOverrideFileName(boolean override) {
        pref.setProperty(OVERRIDEFILENAME, override ? "true" : "false");
    }

    public void setProvideBreaks(boolean provideBreaks) {
        pref.setProperty(PROVIDEBREAKS, provideBreaks ? "true" : "false");
    }

    public void setLineComments(boolean lineComments) {
        pref.setProperty(LINECOMMENTS, lineComments ? "true" : "false");
    }

    public void setWriteProblemDescFile(boolean probDescFile) {
        pref.setProperty(PROBDESCFILEWRITE, probDescFile ? "true" : "false");
    }

    public void setHTMLDesc(boolean htmlDesc) {
        pref.setProperty(HTMLDESC, htmlDesc ? "true" : "false");
    }

    public void setBackup(boolean backup) {
        pref.setProperty(BACKUP, backup ? "true" : "false");
    }

    public void setBreakAt(int breakAt) {
        pref.setProperty(BREAKAT, String.valueOf(breakAt));
    }

    private final String getStringProperty(String key, String defaultValue) {
        String value = pref.getProperty(key);
        return value == null || value.equals("") ? defaultValue : value;
    }

    private final boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = pref.getProperty(key);
        return value == null || value.equals("") ? defaultValue : value.equals("true");
    }

    public void save() throws IOException {
        pref.savePreferences();
    }

    public static void main(String[] args) {
        Preferences pref = new Preferences();
        pref.setJAVATemplate("kdjf");
        try {
            pref.save();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

