/*
 * Decompiled with CFR 0.152.
 */
package tc_plugin;

import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.Renderer;
import com.topcoder.shared.problem.TestCase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ExampleBuilder {
    private static final String[] supported = new String[]{"Java", "C#", "C++"};
    private final Map tags = new HashMap();
    private static final String WRITERCODE = "$WRITERCODE$";
    private static final String MAINBODY = "$MAINBODY$";
    private static final String RETVAL = "retrunValue";

    public Map getUserDefinedTags() {
        return this.tags;
    }

    public String preProcess(String src, ProblemComponentModel problem, Language lang, Renderer rend) {
        this.tags.put(WRITERCODE, problem.getDefaultSolution());
        if (src != null && src.length() > 0 && !src.equals(problem.getDefaultSolution()) && ExampleBuilder.sameLanguage(lang, src)) {
            return src;
        }
        if (!problem.hasSignature()) {
            this.tags.put(MAINBODY, "// Problem has no signature");
            return src;
        }
        if (!Arrays.asList(supported).contains(lang.getName())) {
            return src;
        }
        TestCase[] tests = problem.getTestCases();
        DataType[] pt = problem.getParamTypes();
        String[] pn = problem.getParamNames();
        StringBuffer buf = new StringBuffer();
        if (tests != null) {
            int i = 0;
            while (i != tests.length) {
                if (ExampleBuilder.needDef(lang)) {
                    buf.append(String.valueOf(ExampleBuilder.indent(lang)) + "    {\n");
                }
                String[] vals = tests[i].getInput();
                int j = 0;
                while (j != pt.length) {
                    ExampleBuilder.genValueDef(buf, pt[j], vals[j], lang, pn[j]);
                    ++j;
                }
                ExampleBuilder.genValueDef(buf, problem.getReturnType(), tests[i].getOutput(), lang, RETVAL);
                if (ExampleBuilder.needDef(lang)) {
                    buf.append(String.valueOf(ExampleBuilder.indent(lang)) + "        " + problem.getClassName() + " theObject;\n" + ExampleBuilder.indent(lang) + "        eq(" + i + ", theObject." + problem.getMethodName() + "(");
                } else {
                    buf.append(String.valueOf(ExampleBuilder.indent(lang)) + "        eq(" + i + ",(new " + problem.getClassName() + "())." + problem.getMethodName() + "(");
                }
                j = 0;
                while (j != pt.length) {
                    if (j != 0) {
                        buf.append(", ");
                    }
                    ExampleBuilder.genValueRef(buf, pt[j], vals[j], lang, pn[j]);
                    ++j;
                }
                buf.append("),");
                ExampleBuilder.genValueRef(buf, problem.getReturnType(), tests[i].getOutput(), lang, RETVAL);
                buf.append(");");
                if (ExampleBuilder.needDef(lang)) {
                    buf.append(String.valueOf(ExampleBuilder.indent(lang)) + "\n    }");
                }
                if (i != tests.length - 1) {
                    buf.append("\n");
                }
                ++i;
            }
        }
        this.tags.put(MAINBODY, buf.toString());
        return "";
    }

    private static void genValue(StringBuffer buf, DataType dt, String val, Language lang) {
        if (dt.getBaseName().toLowerCase().indexOf("long") != -1) {
            val = val.replaceAll("\\d+", "$0L");
        }
        if (dt.getDimension() != 0) {
            val = val.replaceAll("\n", "\n           " + ExampleBuilder.indent(lang));
        }
        buf.append(val);
    }

    private static void genValueRef(StringBuffer buf, DataType dt, String val, Language lang, String name) {
        if (ExampleBuilder.inPlace(dt, lang)) {
            if (dt.getDimension() != 0) {
                buf.append("new ");
                buf.append(dt.getDescriptor(lang));
                buf.append(" ");
            }
            ExampleBuilder.genValue(buf, dt, val, lang);
        } else if (!ExampleBuilder.empty(val)) {
            buf.append(name);
        } else {
            buf.append(String.valueOf(dt.getDescriptor(lang)) + "()");
        }
    }

    private static void genValueDef(StringBuffer buf, DataType dt, String val, Language lang, String name) {
        if (!ExampleBuilder.inPlace(dt, lang) && !ExampleBuilder.empty(val)) {
            buf.append(String.valueOf(ExampleBuilder.indent(lang)) + "        " + dt.getBaseName().toLowerCase() + " " + name + "ARRAY[] = ");
            ExampleBuilder.genValue(buf, dt, val, lang);
            buf.append(";\n");
            buf.append(String.valueOf(ExampleBuilder.indent(lang)) + "        " + dt.getDescriptor(lang) + " " + name + "( " + name + "ARRAY, " + name + "ARRAY+ARRSIZE(" + name + "ARRAY) );\n");
        }
    }

    private static boolean needDef(Language lang) {
        return lang.getName().equals("C++");
    }

    private static boolean inPlace(DataType dt, Language lang) {
        return dt.getDimension() == 0 || !ExampleBuilder.needDef(lang);
    }

    private static String indent(Language lang) {
        if (lang.getName().equals("C++")) {
            return "";
        }
        return "    ";
    }

    private static boolean empty(String s) {
        return s.matches("[{][\t \n\r]*[}]");
    }

    private static boolean sameLanguage(Language lang, String src) {
        if (lang.getName().equals("C++")) {
            return src.indexOf("#include") != -1;
        }
        if (lang.getName().equals("Java")) {
            return src.indexOf("import ") != -1;
        }
        if (lang.getName().equals("C#")) {
            return src.indexOf("using ") != -1 && src.indexOf("#include") == -1;
        }
        return true;
    }
}

