/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter;

class PointIndexer {
    private int index;
    private int size;
    private PointIndexer left = null;
    private PointIndexer right = null;

    PointIndexer(int n, int n2) {
        this.index = n;
        this.size = n2;
    }

    int get(int n) {
        if (this.left == null) {
            return this.index + n;
        }
        if (n < this.left.size) {
            return this.left.get(n);
        }
        return this.right.get(n - this.left.size);
    }

    void remove(int n, int n2) {
        if (n == 0 && n2 == this.size - 1) {
            this.size = 0;
            return;
        }
        if (this.left == null) {
            if (n == 0) {
                this.index += n2 + 1;
                this.size -= n2 + 1;
                return;
            }
            if (n2 == this.size - 1) {
                this.size = n;
                return;
            }
            int n3 = this.size / 2;
            this.left = new PointIndexer(this.index, n3);
            this.right = new PointIndexer(this.index + n3, this.size - n3);
        }
        if (n2 >= this.left.size) {
            if (n >= this.left.size) {
                this.right.remove(n - this.left.size, n2 - this.left.size);
            } else {
                this.right.remove(0, n2 - this.left.size);
            }
        }
        if (n < this.left.size) {
            if (n2 < this.left.size) {
                this.left.remove(n, n2);
            } else {
                this.left.remove(n, this.left.size - 1);
            }
        }
        if (this.left.size == 0) {
            this.index = this.right.index;
            this.size = this.right.size;
            this.left = this.right.left;
            this.right = this.right.right;
        } else if (this.right.size == 0) {
            this.index = this.left.index;
            this.size = this.left.size;
            this.right = this.left.right;
            this.left = this.left.left;
        } else {
            this.size = this.left.size + this.right.size;
        }
    }

    int findBreakPoint(int n, int n2) {
        if (this.left == null) {
            return -1;
        }
        if (n2 < this.left.size) {
            return this.left.findBreakPoint(n, n2);
        }
        if (n >= this.left.size) {
            int n3 = this.right.findBreakPoint(n - this.left.size, n2 - this.left.size);
            if (n3 != -1) {
                return this.left.size + n3;
            }
        } else {
            int n4 = this.left.findBreakPoint(n, this.left.size - 1);
            if (n4 != -1) {
                return n4;
            }
            if (this.left.index + this.left.size != this.right.index) {
                return this.left.size;
            }
            n4 = this.right.findBreakPoint(0, n2 - this.left.size);
            if (n4 != -1) {
                return this.left.size + n4;
            }
        }
        return -1;
    }
}

