/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter;

import com.topcoder.util.syntaxhighlighter.ConfigurationException;
import com.topcoder.util.syntaxhighlighter.SHHelper;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import com.topcoder.util.syntaxhighlighter.rules.BlockMatchRule;
import com.topcoder.util.syntaxhighlighter.rules.PatternMatchRule;
import com.topcoder.util.syntaxhighlighter.rules.Rule;
import com.topcoder.util.syntaxhighlighter.rules.WordMatchRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Category
implements Comparable {
    private final List rules;
    private TextStyle style;
    private int precedence;
    private final String name;

    Category(Node node, Map map) throws ConfigurationException {
        this.name = ((Element)node).getAttribute("name");
        SHHelper.checkConfigString(this.name, "category_name");
        try {
            this.precedence = Integer.parseInt(((Element)node).getAttribute("precedence"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("Illegal precedence:" + ((Element)node).getAttribute("precedence"));
        }
        if (this.precedence < 0) {
            throw new ConfigurationException("Illegal precedence:" + this.precedence);
        }
        this.style = (TextStyle)map.get(((Element)node).getAttribute("style"));
        if (this.style == null) {
            throw new ConfigurationException("Required style not found in style map.");
        }
        this.rules = new ArrayList();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            try {
                if (string.equals("blockMatchRule")) {
                    this.rules.add(new BlockMatchRule(node2));
                    continue;
                }
                if (string.equals("patternMatchRule")) {
                    this.rules.add(new PatternMatchRule(node2));
                    continue;
                }
                if (string.equals("wordMatchRule")) {
                    this.rules.add(new WordMatchRule(node2));
                    continue;
                }
                throw new ConfigurationException("'blockMatchRule' or 'patternMatchRule' or 'wordMatchRule' expected.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConfigurationException("There are some errors in the config:" + illegalArgumentException.getMessage());
            }
        }
    }

    public Rule[] getRules() {
        return this.rules.toArray(new Rule[this.rules.size()]);
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public int compareTo(Object object) {
        SHHelper.checkNull(object, "obj");
        return this.precedence - ((Category)object).getPrecedence();
    }

    public String getName() {
        return this.name;
    }
}

