/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.DuplicatePropertyException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class Property
implements Cloneable {
    private String name = null;
    private List comments = null;
    private List subproperties = null;
    private List values = null;
    private String value = null;
    private char separator = (char)61;

    char getSeparator() {
        return this.separator;
    }

    void setSeparator(char c) {
        this.separator = c;
    }

    public Property(String string) {
        if (string == null) {
            throw new NullPointerException("parameter name is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("parameter name is empty");
        }
        if (string.indexOf(46) != -1) {
            throw new IllegalArgumentException("parameter name is a compound name");
        }
        this.name = string;
        this.subproperties = new ArrayList();
        this.values = new ArrayList();
    }

    Property() {
        this.name = "";
        this.subproperties = new ArrayList();
        this.values = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProperty(Property property) throws DuplicatePropertyException {
        if (property == null) {
            throw new NullPointerException("parameter property is null");
        }
        Property property2 = this;
        synchronized (property2) {
            Iterator iterator = this.subproperties.iterator();
            while (iterator.hasNext()) {
                if (!((Property)iterator.next()).name.equals(property.name)) continue;
                throw new DuplicatePropertyException("property " + this.name + " already exists");
            }
            this.subproperties.add(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProperty(String string) {
        if (string == null) {
            throw new NullPointerException("parameter name is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("parameter name is empty");
        }
        Property property = this;
        synchronized (property) {
            Property property2;
            int n = string.lastIndexOf(46);
            if (n == -1) {
                property2 = this;
            } else {
                property2 = this.find(string.substring(0, n));
                if (property2 == null) {
                    return;
                }
            }
            string = string.substring(n + 1);
            Iterator iterator = property2.subproperties.iterator();
            while (iterator.hasNext()) {
                if (!((Property)iterator.next()).name.equals(string)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setValue(String string) {
        if (string == null) {
            throw new NullPointerException("parameter value is null");
        }
        Property property = this;
        synchronized (property) {
            this.value = string;
            this.values.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setValues(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("parameter values is null");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("parameter values contains no entry");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            throw new NullPointerException("parameter values contains null entry");
        }
        Property property = this;
        synchronized (property) {
            this.value = null;
            this.values.clear();
            if (stringArray.length == 1) {
                this.value = stringArray[0];
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.values.add(stringArray[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProperty(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("parameter key is empty");
        }
        if (string2 == null) {
            throw new NullPointerException("parameter value is null");
        }
        Property property = this;
        synchronized (property) {
            Property property2 = this.find(string);
            if (property2 == null) {
                property2 = this.create(string);
            }
            property2.setValue(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProperty(String string, String[] stringArray) {
        if (string == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("parameter key is empty");
        }
        if (stringArray == null) {
            throw new NullPointerException("parameter values is null");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("parameter values contains no entry");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            throw new NullPointerException("parameter values contains null entry");
        }
        Property property = this;
        synchronized (property) {
            Property property2 = this.find(string);
            if (property2 == null) {
                property2 = this.create(string);
            }
            property2.setValues(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue() {
        Property property = this;
        synchronized (property) {
            if (this.value != null) {
                return this.value;
            }
            if (this.values.size() > 0) {
                return (String)this.values.get(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValues() {
        Property property = this;
        synchronized (property) {
            if (this.value != null) {
                return new String[]{this.value};
            }
            if (this.values.size() > 0) {
                return this.values.toArray(new String[this.values.size()]);
            }
            return null;
        }
    }

    public Property getProperty(String string) {
        if (string == null) {
            throw new NullPointerException("parameter name is null");
        }
        return this.find(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() {
        Property property = this;
        synchronized (property) {
            return new ArrayList(this.subproperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration propertyNames() {
        Property property = this;
        synchronized (property) {
            Vector<String> vector = new Vector<String>();
            Iterator iterator = this.subproperties.iterator();
            while (iterator.hasNext()) {
                vector.add(((Property)iterator.next()).name);
            }
            return vector.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Property find(String string) {
        Property property = this;
        synchronized (property) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            Property property2 = this;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                boolean bl = false;
                Iterator iterator = property2.subproperties.iterator();
                while (iterator.hasNext()) {
                    Property property3 = (Property)iterator.next();
                    if (!property3.name.equals(string)) continue;
                    property2 = property3;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return null;
            }
            return property2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Property create(String string) {
        if (string == null) {
            throw new NullPointerException("parameter name is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("parameter name is empty");
        }
        Property property = this;
        synchronized (property) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            Object object = this;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                boolean bl = false;
                Object object2 = ((Property)object).subproperties.iterator();
                while (object2.hasNext()) {
                    Property property2 = (Property)object2.next();
                    if (!property2.name.equals(string)) continue;
                    object = property2;
                    bl = true;
                    break;
                }
                if (bl) continue;
                object2 = new Property(string);
                try {
                    ((Property)object).addProperty((Property)object2);
                }
                catch (DuplicatePropertyException duplicatePropertyException) {
                    // empty catch block
                }
                object = object2;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Property property = this;
        synchronized (property) {
            Property property2 = new Property();
            property2.name = this.name;
            property2.value = this.value;
            property2.values = new ArrayList(this.values);
            property2.subproperties = new ArrayList();
            Iterator iterator = this.subproperties.iterator();
            while (iterator.hasNext()) {
                property2.subproperties.add(((Property)iterator.next()).clone());
            }
            if (this.comments != null) {
                property2.comments = new ArrayList(this.comments);
            }
            return property2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComment(String string) {
        if (string == null) {
            throw new NullPointerException("parameter comment is null");
        }
        Property property = this;
        synchronized (property) {
            if (this.comments == null) {
                this.comments = new ArrayList();
            }
            this.comments.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getComments() {
        Property property = this;
        synchronized (property) {
            if (this.comments == null) {
                return null;
            }
            return new ArrayList(this.comments);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        return object instanceof Property && this.name.equals(((Property)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

