/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigParserException;
import com.topcoder.util.config.ConfigProperties;
import com.topcoder.util.config.Property;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class PropConfigProperties
extends ConfigProperties {
    private URL source = null;
    private PrintWriter writer = null;

    private PropConfigProperties() {
    }

    PropConfigProperties(URL uRL) throws IOException {
        this.source = uRL;
        this.load();
    }

    private void writeProperty(Property property, String string) {
        String[] stringArray;
        string = string.equals("") ? property.getName() : string + "." + property.getName();
        List list = property.getComments();
        if (list != null) {
            stringArray = list.iterator();
            while (stringArray.hasNext()) {
                this.writer.println(stringArray.next());
            }
        }
        if ((stringArray = property.getValues()) != null && stringArray.length > 0) {
            this.writer.print(string);
            this.writer.print(property.getSeparator());
            this.writer.println(PropConfigProperties.mergeEscaped(stringArray, this.getListDelimiter()));
        }
        List list2 = property.list();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            this.writeProperty((Property)iterator.next(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() throws IOException {
        if (!this.source.getProtocol().equals("file")) {
            throw new UnsupportedOperationException("source is not a physical file");
        }
        try {
            this.writer = new PrintWriter(new FileWriter(ConfigManager.decodeURL(this.source.getFile())));
            if (this.getListDelimiter() != ';') {
                this.writer.print("ListDelimiter=");
                this.writer.println(this.getListDelimiter());
            }
            this.writeProperty(this.getRoot(), "");
            Object var2_1 = null;
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load() throws IOException {
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this.source.openStream()));
                Property property = new Property();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (true) {
                    Object object;
                    String string;
                    if ((string = bufferedReader.readLine()) == null) {
                        this.setRoot(property);
                        break;
                    }
                    String string2 = string.trim();
                    if (string2.length() == 0 || string2.charAt(0) == '#' || string2.charAt(0) == '!') {
                        arrayList.add(string);
                        continue;
                    }
                    int n = PropConfigProperties.findDelimiter(string, '=');
                    if (n == -1) {
                        n = PropConfigProperties.findDelimiter(string, ':');
                    }
                    if (n == -1) {
                        n = PropConfigProperties.findDelimiter(string, ' ');
                    }
                    if (n == -1) {
                        throw new ConfigParserException("unrecognized line : " + string);
                    }
                    String string3 = string.substring(0, n);
                    if (string3.equals("ListDelimiter")) {
                        object = string.substring(n + 1);
                        if (((String)object).length() != 1) {
                            throw new ConfigParserException("invalid delimiter");
                        }
                        this.setListDelimiter(((String)object).charAt(0));
                        continue;
                    }
                    string3 = PropConfigProperties.parseString(string3);
                    object = PropConfigProperties.parseValueString(string.substring(n + 1), this.getListDelimiter());
                    Property property2 = property.find(string3);
                    if (property2 != null && property2.getValue() != null) {
                        throw new ConfigParserException("contains duplicate property " + string3);
                    }
                    property.setProperty(string3, object.toArray(new String[object.size()]));
                    property2 = property.find(string3);
                    property2.setSeparator(string.charAt(n));
                    if (arrayList.size() <= 0) continue;
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        property2.addComment((String)iterator.next());
                    }
                    arrayList.clear();
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new ConfigParserException(exception.getMessage());
            }
            Object var12_13 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (bufferedReader != null) {
                bufferedReader.close();
                bufferedReader = null;
            }
            throw throwable;
        }
        bufferedReader.close();
    }

    private static String parseString(String string) throws ConfigParserException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (i + 1 >= string.length()) {
                    throw new ConfigParserException("Missing escaped character after '\\'.");
                }
                if ((c = string.charAt(++i)) == 't') {
                    stringBuffer.append('\t');
                    continue;
                }
                if (c == 'r') {
                    stringBuffer.append('\r');
                    continue;
                }
                if (c == 'n') {
                    stringBuffer.append('\n');
                    continue;
                }
                if (c == 'u') {
                    if (i + 4 >= string.length()) {
                        throw new ConfigParserException("Invalid escape after '\\u'.");
                    }
                    String string2 = string.substring(i + 1, i + 1 + 4);
                    i += 4;
                    stringBuffer.append(PropConfigProperties.parseHexString(string2));
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static int findDelimiter(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (string.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private static char parseHexString(String string) throws ConfigParserException {
        string = string.trim().toLowerCase();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n2;
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                n2 = c - 48;
            } else if (c >= 'a' && c <= 'f') {
                n2 = c - 97 + 10;
            } else {
                throw new ConfigParserException("Invalid hex string.");
            }
            n = (n << 4) + n2;
        }
        return (char)n;
    }

    static List parseValueString(String string, char c) throws ConfigParserException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '\\') {
                if (i + 1 >= string.length()) {
                    throw new ConfigParserException("Missing escaped character after '\\'.");
                }
                c2 = string.charAt(++i);
                String string2 = " !:=\\#";
                if (c2 == c || string2.indexOf(c2) >= 0) {
                    stringBuffer.append(c2);
                    continue;
                }
                if (c2 == 't') {
                    stringBuffer.append('\t');
                    continue;
                }
                if (c2 == 'r') {
                    stringBuffer.append('\r');
                    continue;
                }
                if (c2 == 'n') {
                    stringBuffer.append('\n');
                    continue;
                }
                if (c2 == 'u') {
                    if (i + 4 >= string.length()) {
                        throw new ConfigParserException("Invalid escape after '\\u'.");
                    }
                    String string3 = string.substring(i + 1, i + 1 + 4);
                    i += 4;
                    stringBuffer.append(PropConfigProperties.parseHexString(string3));
                    continue;
                }
                throw new ConfigParserException("Invalid escape after '\\'.");
            }
            if (c2 == c) {
                arrayList.add(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                continue;
            }
            stringBuffer.append(c2);
        }
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }

    private static String mergeEscaped(String[] stringArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(c);
            }
            for (int j = 0; j < stringArray[i].length(); ++j) {
                char c2 = stringArray[i].charAt(j);
                String string = " !:=\\#";
                if (c2 == c || string.indexOf(c2) >= 0) {
                    stringBuffer.append('\\');
                    stringBuffer.append(c2);
                    continue;
                }
                if (c2 == '\n') {
                    stringBuffer.append("\\n");
                    continue;
                }
                if (c2 == '\r') {
                    stringBuffer.append("\\r");
                    continue;
                }
                if (c2 == '\t') {
                    stringBuffer.append("\\t");
                    continue;
                }
                stringBuffer.append(c2);
            }
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        PropConfigProperties propConfigProperties = new PropConfigProperties();
        propConfigProperties.source = this.source;
        propConfigProperties.setRoot((Property)this.getRoot().clone());
        return propConfigProperties;
    }
}

