/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.ConfigLockedException;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.config.ConfigProperties;
import com.topcoder.util.config.Namespace;
import com.topcoder.util.config.NamespaceAlreadyExistsException;
import com.topcoder.util.config.PluggableConfigProperties;
import com.topcoder.util.config.PropConfigProperties;
import com.topcoder.util.config.Property;
import com.topcoder.util.config.UnknownConfigFormatException;
import com.topcoder.util.config.UnknownNamespaceException;
import com.topcoder.util.config.XMLConfigProperties;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

class DefaultConfigManager
extends ConfigManager {
    private Map namespaces = new HashMap();
    private Map tempProperties = new HashMap();

    DefaultConfigManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addURL(String string, URL uRL, String string2, int n) throws ConfigManagerException {
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            ConfigProperties configProperties;
            block10: {
                if (this.namespaces.containsKey(string)) {
                    throw new NamespaceAlreadyExistsException(string + "already exists");
                }
                try {
                    if (string2.equals(".xml")) {
                        configProperties = new XMLConfigProperties(uRL);
                        break block10;
                    }
                    if (string2.equals(".properties")) {
                        configProperties = new PropConfigProperties(uRL);
                        break block10;
                    }
                    if (string2.equals("MXML")) {
                        configProperties = new XMLConfigProperties(uRL, string);
                        break block10;
                    }
                    if (string2.equals(".config")) {
                        configProperties = new PluggableConfigProperties(uRL);
                        break block10;
                    }
                    throw new UnknownConfigFormatException("parameter format is illegal");
                }
                catch (IOException iOException) {
                    throw new ConfigManagerException(iOException.getMessage());
                }
            }
            this.namespaces.put(string, new Namespace(string, uRL, string2, n, configProperties));
            this.tempProperties.remove(string);
        }
    }

    public void add(String string, String string2, String string3, int n) throws ConfigManagerException {
        if (string == null) {
            throw new NullPointerException("parameter filename is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("parameter filename is empty");
        }
        if (string2 == null) {
            throw new NullPointerException("parameter filename is null");
        }
        if (string2.trim().length() == 0) {
            throw new IllegalArgumentException("parameter filename is empty");
        }
        if (string3 == null) {
            throw new NullPointerException("parameter format is null");
        }
        if (!(string3.equals(".xml") || string3.equals(".properties") || string3.equals("MXML") || string3.equals(".config"))) {
            throw new UnknownConfigFormatException("parameter format is illegal");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("parameter exceptionLevel is illegal");
        }
        this.addURL(string, ConfigManager.getURL(string2), string3, n);
    }

    public void add(String string, String string2, int n) throws ConfigManagerException {
        if (string == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("parameter namespace is empty");
        }
        if (string2 == null) {
            throw new NullPointerException("parameter format is null");
        }
        if (!(string2.equals(".xml") || string2.equals(".properties") || string2.equals("MXML") || string2.equals(".config"))) {
            throw new UnknownConfigFormatException("parameter format is illegal");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("parameter exceptionLevel is illegal");
        }
        String string3 = string.replace('.', '/');
        string3 = string2.equals("MXML") ? string3 + ".xml" : string3 + string2;
        this.add(string, string3, string2, n);
    }

    public void add(URL uRL, int n) throws ConfigManagerException {
        if (uRL == null) {
            throw new NullPointerException("parameter url is null");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("parameter exceptionLevel is illegal");
        }
        this.addURLs(uRL, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addURLs(URL uRL, int n) throws ConfigManagerException {
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            Enumeration enumeration = XMLConfigProperties.getNamespaces(uRL);
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.addURL(string, uRL, "MXML", n);
            }
        }
    }

    public void add(String string, String string2, String string3) throws ConfigManagerException {
        this.add(string, string2, string3, 0);
    }

    public void add(String string, String string2) throws ConfigManagerException {
        this.add(string, string2, 0);
    }

    public void add(URL uRL) throws ConfigManagerException {
        this.add(uRL, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property getPropertyObject(String string, String string2) throws UnknownNamespaceException {
        if (string == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (string2 == null) {
            throw new NullPointerException("parameter key is null");
        }
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            if (!this.namespaces.containsKey(string)) {
                throw new UnknownNamespaceException(string + " is unknown");
            }
            return ((Namespace)this.namespaces.get(string)).getProperties().getRoot().getProperty(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string, String string2) throws UnknownNamespaceException {
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            Property property = this.getPropertyObject(string, string2);
            if (property == null || property.getValue() == null) {
                return null;
            }
            char c = ((Namespace)this.namespaces.get(string)).getProperties().getListDelimiter();
            String[] stringArray = property.getValues();
            return DefaultConfigManager.mergeEscaped(stringArray, c);
        }
    }

    public String[] getStringArray(String string, String string2) throws UnknownNamespaceException {
        Property property = this.getPropertyObject(string, string2);
        if (property == null) {
            return null;
        }
        return property.getValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsNamespace(String string) {
        if (string == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            return this.namespaces.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfigFilename(String string) throws UnknownNamespaceException {
        if (string == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            if (!this.namespaces.containsKey(string)) {
                throw new UnknownNamespaceException(string + " is unknown");
            }
            return ((Namespace)this.namespaces.get(string)).getFile().getFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getAllNamespaces() {
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            return new HashSet(this.namespaces.keySet()).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(String string, String string2) throws ConfigManagerException {
        if (string == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (string2 == null) {
            throw new NullPointerException("parameter user is null");
        }
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            if (!this.tempProperties.containsKey(string)) {
                throw new UnknownNamespaceException(string + " is unknown");
            }
            Namespace namespace = (Namespace)this.namespaces.get(string);
            if (!namespace.canLock(string2)) {
                throw new ConfigLockedException(string + " is currently locked by another user");
            }
            namespace.lock(string2);
            try {
                try {
                    ((ConfigProperties)this.tempProperties.get(string)).save();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw new ConfigManagerException(unsupportedOperationException.getMessage());
                }
                catch (IOException iOException) {
                    throw new ConfigManagerException(iOException.getMessage());
                }
                Object var7_5 = null;
                this.tempProperties.remove(string);
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.tempProperties.remove(string);
                namespace.releaseLock();
                Iterator iterator = new HashSet(this.namespaces.keySet()).iterator();
                while (iterator.hasNext()) {
                    Object object2222;
                    String string3 = (String)iterator.next();
                    try {
                        object2222 = (Namespace)this.namespaces.get(string3);
                        if (!((Namespace)object2222).getFile().getFile().equals(namespace.getFile().getFile())) continue;
                        ((Namespace)object2222).getProperties().load();
                    }
                    catch (Exception object2222) {}
                }
                throw throwable;
            }
            namespace.releaseLock();
            Iterator iterator = new HashSet(this.namespaces.keySet()).iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                try {}
                catch (Exception object322) {
                    continue;
                }
                object322 = (Namespace)this.namespaces.get(string4);
                if (!((Namespace)object322).getFile().getFile().equals(namespace.getFile().getFile())) continue;
                ((Namespace)object322).getProperties().load();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canLock(String string, String string2) throws UnknownNamespaceException {
        if (string == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (string2 == null) {
            throw new NullPointerException("parameter user is null");
        }
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            if (!this.namespaces.containsKey(string)) {
                throw new UnknownNamespaceException(string + " is unknown");
            }
            Namespace namespace = (Namespace)this.namespaces.get(string);
            Iterator iterator = new HashSet(this.namespaces.keySet()).iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                try {
                    Namespace namespace2 = (Namespace)this.namespaces.get(string3);
                    if (!namespace2.getFile().getFile().equals(namespace.getFile().getFile()) || namespace2.canLock(string2)) continue;
                    return false;
                }
                catch (Exception exception) {
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTemporaryProperties(String string) throws UnknownNamespaceException {
        if (string == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            if (!this.namespaces.containsKey(string)) {
                throw new UnknownNamespaceException(string + " is unknown");
            }
            this.tempProperties.put(string, ((Namespace)this.namespaces.get(string)).getProperties().clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String string, String string2, String string3) throws UnknownNamespaceException {
        if (string == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (string2 == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (string3 == null) {
            throw new NullPointerException("parameter value is null");
        }
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            if (!this.tempProperties.containsKey(string)) {
                throw new UnknownNamespaceException(string + " is unknown");
            }
            ((ConfigProperties)this.tempProperties.get(string)).getRoot().setProperty(string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(String string, String string2) throws UnknownNamespaceException {
        if (string == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (string2 == null) {
            throw new NullPointerException("parameter key is null");
        }
        DefaultConfigManager defaultConfigManager = this;
        synchronized (defaultConfigManager) {
            if (!this.tempProperties.containsKey(string)) {
                throw new UnknownNamespaceException(string + " is unknown");
            }
            ((ConfigProperties)this.tempProperties.get(string)).getRoot().removeProperty(string2);
        }
    }

    private static String mergeEscaped(String[] stringArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(c);
            }
            for (int j = 0; j < stringArray[i].length(); ++j) {
                char c2 = stringArray[i].charAt(j);
                if (c2 == c) {
                    stringBuffer.append('\\');
                    stringBuffer.append(c2);
                    continue;
                }
                stringBuffer.append(c2);
            }
        }
        return stringBuffer.toString();
    }
}

