/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.util.concurrent;

public class Waiter {
    private final Object mutex;
    private long maxTime;
    private long elapse;

    private void init0() {
        this.maxTime = 0L;
        this.elapse = 0L;
    }

    public Waiter(long l, Object object) {
        this.mutex = object;
        if (l <= 0L) {
            this.init0();
        } else {
            this.elapse = l;
            this.resolveMaxTime();
        }
    }

    private void resolveMaxTime() {
        this.maxTime = Long.MAX_VALUE - this.elapse < System.currentTimeMillis() ? Long.MAX_VALUE : System.currentTimeMillis() + this.elapse;
    }

    public boolean elapsed() {
        return this.elapse != 0L && System.currentTimeMillis() >= this.maxTime;
    }

    public void await() throws InterruptedException {
        if (this.elapse == 0L) {
            this.mutex.wait();
        } else {
            long l = this.maxTime - System.currentTimeMillis();
            if (l > 0L) {
                this.mutex.wait(l);
            }
        }
    }

    public long getRemaining() {
        if (this.elapse == 0L) {
            return Long.MAX_VALUE;
        }
        long l = this.maxTime - System.currentTimeMillis();
        return l > 0L ? l : 0L;
    }
}

