/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.problem.BaseElement;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.ProblemComponent;
import java.io.IOException;
import java.io.ObjectStreamException;

public class TextElement
extends BaseElement
implements Element {
    private String text = "";
    private boolean escapedText = false;

    public TextElement() {
    }

    public TextElement(String string) {
        this.text = string;
    }

    public TextElement(boolean bl, String string) {
        this.escapedText = bl;
        this.text = string;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeString(this.text);
        cSWriter.writeBoolean(this.escapedText);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.text = cSReader.readString();
        this.escapedText = cSReader.readBoolean();
    }

    public String getEditableText() {
        return this.text;
    }

    public void setEditableText(String string) {
        this.text = string;
    }

    public String toXML() {
        return ProblemComponent.encodeHTML(this.text);
    }

    public String toString() {
        if (this.escapedText) {
            return this.text;
        }
        return ProblemComponent.encodeHTML(this.text);
    }

    public boolean isEscapedText() {
        return this.escapedText;
    }

    public void setEscapedText(boolean bl) {
        this.escapedText = bl;
    }
}

