/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.problem.BaseElement;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.ProblemComponent;
import java.io.IOException;
import java.io.ObjectStreamException;

public class TestCase
extends BaseElement
implements Element {
    private String[] input;
    private String output;
    private String text;
    private Element annotation;
    private boolean example;
    private boolean systemTest;

    public TestCase() {
    }

    public TestCase(String[] stringArray, String string, boolean bl) {
        this(stringArray, string, null, bl);
    }

    public TestCase(String[] stringArray, String string, Element element, boolean bl) {
        this(stringArray, string, element, bl, false);
    }

    public TestCase(String[] stringArray, String string, Element element, boolean bl, boolean bl2) {
        this.input = stringArray;
        this.output = string;
        this.annotation = element;
        this.example = bl;
        this.systemTest = bl2;
        this.text = element == null ? "" : element.toXML();
        this.output = ProblemComponent.decodeXML(this.output);
        for (int i = 0; i < this.input.length; ++i) {
            this.input[i] = ProblemComponent.decodeXML(this.input[i]);
        }
    }

    public TestCase(String[] stringArray, Element element, boolean bl) {
        this(stringArray, "UNKNOWN-OUTPUT10291821323", element, bl);
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeObjectArray(this.input);
        cSWriter.writeString(this.output);
        cSWriter.writeObject(this.annotation);
        cSWriter.writeBoolean(this.example);
        cSWriter.writeBoolean(this.systemTest);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        Object[] objectArray = cSReader.readObjectArray();
        this.output = cSReader.readString();
        this.annotation = (Element)cSReader.readObject();
        this.example = cSReader.readBoolean();
        this.systemTest = cSReader.readBoolean();
        this.input = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.input[i] = (String)objectArray[i];
        }
        this.text = this.annotation == null ? "" : this.annotation.toXML();
    }

    public boolean isExample() {
        return this.example;
    }

    public void setExample(boolean bl) {
        this.example = bl;
    }

    public String[] getInput() {
        return this.input;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public String getOutput() {
        return this.output;
    }

    public Element getAnnotation() {
        return this.annotation;
    }

    public boolean isSystemTest() {
        return this.systemTest;
    }

    public void setSystemTest(boolean bl) {
        this.systemTest = bl;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<test-case");
        if (this.example) {
            stringBuffer.append(" example=\"1\"");
        }
        if (this.systemTest) {
            stringBuffer.append(" systemTest=\"1\"");
        }
        stringBuffer.append('>');
        for (int i = 0; i < this.input.length; ++i) {
            stringBuffer.append("<input>");
            stringBuffer.append(ProblemComponent.encodeXML(this.input[i]));
            stringBuffer.append("</input>");
        }
        stringBuffer.append("<output>");
        stringBuffer.append(ProblemComponent.encodeXML(this.output));
        stringBuffer.append("</output>");
        if (this.text != null && !this.text.equals("")) {
            stringBuffer.append(ProblemComponent.handleTextElement("annotation", this.annotation));
        }
        stringBuffer.append("</test-case>");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TestCase)) {
            return false;
        }
        TestCase testCase = (TestCase)object;
        return this.toXML().equals(testCase.toXML());
    }
}

