/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.DataValue;
import com.topcoder.shared.problem.DataValueParseException;
import com.topcoder.shared.problem.DataValueReader;
import java.io.IOException;
import java.io.ObjectStreamException;

public class StringValue
extends DataValue {
    private String value;

    public StringValue() {
    }

    public StringValue(String string) {
        this.value = string;
    }

    public void parse(DataValueReader dataValueReader, DataType dataType) throws IOException, DataValueParseException {
        dataValueReader.expect('\"', true);
        StringBuffer stringBuffer = new StringBuffer(64);
        while (!dataValueReader.checkAhead('\"')) {
            int n = dataValueReader.read(true);
            char c = (char)n == '\\' ? (char)dataValueReader.read(true) : (char)n;
            stringBuffer.append(c);
        }
        this.value = stringBuffer.toString();
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeString(this.value);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.value = cSReader.readString();
    }

    public String encode() {
        StringBuffer stringBuffer = new StringBuffer(this.value.length() + 32);
        stringBuffer.append('\"');
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == '\\' || c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public Object getValue() {
        return this.value;
    }
}

