/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.problem.DataValueParseException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;

public class DataValueReader {
    private PushbackReader reader;
    private int line;
    private int column;
    private int prevcolumn = -1;
    private boolean eof = false;

    public DataValueReader(String string) throws IOException {
        this(string, 1, 1);
    }

    public DataValueReader(String string, int n, int n2) throws IOException {
        this(new StringReader(string), n, n2);
    }

    public DataValueReader(Reader reader) throws IOException {
        this(reader, 1, 1);
    }

    public DataValueReader(Reader reader, int n, int n2) throws IOException {
        this.reader = new PushbackReader(reader);
        this.line = n;
        this.column = n2;
    }

    public void exception(String string) throws DataValueParseException {
        throw new DataValueParseException(string, this.line, this.column);
    }

    public int read() throws IOException, DataValueParseException {
        return this.read(false);
    }

    void incrementColumn() {
        ++this.column;
    }

    void incrementLine() {
        ++this.line;
        this.prevcolumn = this.column;
        this.column = 1;
    }

    void decrementColumn() {
        if (this.column < 2) {
            this.column = this.prevcolumn;
            this.prevcolumn = -1;
        } else {
            --this.column;
        }
    }

    public int read(boolean bl) throws IOException, DataValueParseException {
        if (this.eof) {
            if (bl) {
                this.exception("Unexpected EOF");
            }
            return -1;
        }
        int n = this.reader.read();
        if (n == -1) {
            this.eof = true;
            if (bl) {
                this.exception("Unexpected EOF");
            }
            this.incrementColumn();
            return -1;
        }
        if ((char)n == '\n') {
            this.incrementLine();
        } else {
            this.incrementColumn();
        }
        return n;
    }

    public void unread(int n) throws IOException {
        this.decrementColumn();
        if (this.eof) {
            this.eof = false;
        }
        if (n != -1) {
            this.reader.unread(n);
        }
    }

    public void skipWhitespace() throws IOException, DataValueParseException {
        int n = this.read();
        while (n != -1 && Character.isWhitespace((char)n)) {
            n = this.read();
        }
        this.unread(n);
    }

    void expect(char c, boolean bl) throws IOException, DataValueParseException {
        int n;
        if (bl) {
            this.skipWhitespace();
        }
        if ((n = this.read()) == -1) {
            this.unread(n);
            this.expectedException((int)c, "EOF");
        }
        if ((char)n != c) {
            this.unread(n);
            this.expectedException((int)c, n);
        }
    }

    void expectedException(int n, int n2) throws DataValueParseException {
        if (n == -1) {
            this.expectedException("EOF", n2);
        }
        if (n2 == -1) {
            this.expectedException(n, "EOF");
        }
        this.expectedException("``" + (char)n + "''", "``" + (char)n2 + "''");
    }

    void expectedException(String string, int n) throws DataValueParseException {
        if (n == -1) {
            this.expectedException(string, "EOF");
        }
        this.expectedException(string, "``" + (char)n + "''");
    }

    void expectedException(int n, String string) throws DataValueParseException {
        if (n == -1) {
            this.expectedException("EOF", string);
        }
        this.expectedException("``" + (char)n + "''", string);
    }

    void expectedException(String string, String string2) throws DataValueParseException {
        this.exception("Expected " + string + ", got " + string2);
    }

    boolean checkAhead(char c) throws IOException, DataValueParseException {
        return this.checkAhead(c, false);
    }

    boolean checkAhead(char c, boolean bl) throws IOException, DataValueParseException {
        int n;
        if (bl) {
            this.skipWhitespace();
        }
        if ((char)(n = this.read()) == c) {
            return true;
        }
        this.unread(n);
        return false;
    }
}

