/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.DataValue;
import com.topcoder.shared.problem.DataValueParseException;
import com.topcoder.shared.problem.DataValueReader;
import com.topcoder.shared.problem.InvalidTypeException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;

public class ArrayValue
extends DataValue {
    private ArrayList values;

    public ArrayValue() {
    }

    public ArrayValue(ArrayList arrayList) {
        this.values = arrayList;
    }

    public ArrayValue(DataValueReader dataValueReader, DataType dataType) throws IOException, DataValueParseException {
        this.parse(dataValueReader, dataType);
    }

    public void parse(DataValueReader dataValueReader, DataType dataType) throws IOException, DataValueParseException {
        try {
            dataValueReader.expect('{', true);
            DataType dataType2 = dataType.reduceDimension();
            this.values = new ArrayList();
            if (dataValueReader.checkAhead('}', true)) {
                return;
            }
            do {
                this.values.add(DataValue.parseValue(dataValueReader, dataType2));
            } while (dataValueReader.checkAhead(',', true));
            dataValueReader.expect('}', true);
        }
        catch (InvalidTypeException invalidTypeException) {
            dataValueReader.exception("Invalid array type: " + dataType.getDescription());
        }
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeArrayList(this.values);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.values = cSReader.readArrayList();
    }

    public String encode() {
        String[] stringArray = new String[this.values.size()];
        int n = 2;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((DataValue)this.values.get(i)).encode();
            n += stringArray[i].length() + 2;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append('{');
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public Object getValue() {
        return this.values.toArray();
    }
}

