/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.netCommon;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.ClassCache;
import com.topcoder.shared.netCommon.CustomSerializable;
import com.topcoder.shared.netCommon.ReflectUtils;
import com.topcoder.shared.netCommon.ResolvedCustomSerializable;
import com.topcoder.shared.netCommon.customserializer.CustomSerializer;
import com.topcoder.shared.netCommon.customserializer.CustomSerializerProvider;
import com.topcoder.shared.netCommon.customserializer.NullCustomSerializerProvider;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class CSHandler
implements CSReader,
CSWriter {
    private DataOutput output;
    private DataInput input;
    private CustomSerializerProvider customSerializer = new NullCustomSerializerProvider();

    public final void setDataInput(DataInput dataInput) {
        this.input = dataInput;
    }

    public final void setDataOutput(DataOutput dataOutput) {
        this.output = dataOutput;
    }

    public final void writeByte(byte by) throws IOException {
        this.output.writeByte(by);
    }

    public final byte readByte() throws IOException {
        return this.input.readByte();
    }

    private boolean isNull(byte by) throws IOException {
        byte by2 = this.readByte();
        if (by2 == 1) {
            return true;
        }
        if (by2 != by) {
            throw new RuntimeException("unexpected, b=" + by2 + ", expected=" + by);
        }
        return false;
    }

    private boolean isNull(byte by, byte by2) throws IOException {
        byte by3 = this.readByte();
        if (by3 == 1) {
            return true;
        }
        if (by3 != by && by3 != by2) {
            throw new RuntimeException("unexpected, b=" + by3 + ", expected=" + by + " or " + by2);
        }
        return false;
    }

    private void writeNull() throws IOException {
        this.writeByte((byte)1);
    }

    public final short readShort() throws IOException {
        return this.input.readShort();
    }

    public final void writeShort(short s) throws IOException {
        this.output.writeShort(s);
    }

    public final int readInt() throws IOException {
        return this.input.readInt();
    }

    public final void writeInt(int n) throws IOException {
        this.output.writeInt(n);
    }

    public final long readLong() throws IOException {
        return this.input.readLong();
    }

    public final void writeLong(long l) throws IOException {
        this.output.writeLong(l);
    }

    public final boolean readBoolean() throws IOException {
        return this.input.readBoolean();
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.output.writeBoolean(bl);
    }

    public final ArrayList readArrayList() throws IOException {
        if (this.isNull((byte)33, (byte)35)) {
            return null;
        }
        return this.readJustArrayList();
    }

    private ArrayList readJustArrayList() throws IOException {
        int n = this.readShort();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.readObject());
        }
        return arrayList;
    }

    public final void writeCollection(Collection collection) throws IOException {
        this.writeCollection(collection, (byte)37);
    }

    public final void writeArrayList(ArrayList arrayList) throws IOException {
        this.writeCollection(arrayList, (byte)33);
    }

    public void writeList(List list) throws IOException {
        this.writeCollection(list, (byte)35);
    }

    public void writeCollection(Collection collection, byte by) throws IOException {
        if (collection == null) {
            this.writeNull();
            return;
        }
        int n = collection.size();
        if (n > Short.MAX_VALUE) {
            throw new RuntimeException("list big size: " + n);
        }
        this.writeByte(by);
        this.writeShort((short)n);
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.writeObject(iterator.next());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.throwConcurrentModificationException(concurrentModificationException, collection);
        }
    }

    private Object[] readJustObjectArray(Class clazz) throws IOException {
        int n = this.readShort();
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readObject();
        }
        return objectArray;
    }

    private Object[] readJustObjectArray() throws IOException {
        int n = this.readShort();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readObject();
        }
        return objectArray;
    }

    public final Object[] readObjectArray() throws IOException {
        if (this.isNull((byte)9)) {
            return null;
        }
        return this.readJustObjectArray();
    }

    public final Object[] readObjectArray(Class clazz) throws IOException {
        if (this.isNull((byte)9)) {
            return null;
        }
        return this.readJustObjectArray(clazz);
    }

    private void writeJustObjectArray(Object[] objectArray) throws IOException {
        int n = objectArray.length;
        if (n > Short.MAX_VALUE) {
            throw new RuntimeException("object array big size: " + n);
        }
        this.writeShort((short)n);
        for (int i = 0; i < n; ++i) {
            this.writeObject(objectArray[i]);
        }
    }

    public final void writeObjectArray(Object[] objectArray) throws IOException {
        if (objectArray == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)9);
        this.writeJustObjectArray(objectArray);
    }

    public final Object[][] readObjectArrayArray(Class clazz) throws IOException {
        if (this.isNull((byte)14)) {
            return null;
        }
        int n = this.readShort();
        Object[][] objectArray = (Object[][])Array.newInstance(clazz, n, 0);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readJustObjectArray(clazz);
        }
        return objectArray;
    }

    private Object[][] readJustObjectArrayArray() throws IOException {
        int n = this.readShort();
        Object[][] objectArray = new Object[n][];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readJustObjectArray();
        }
        return objectArray;
    }

    public final void writeObjectArrayArray(Object[][] objectArray) throws IOException {
        if (objectArray == null) {
            this.writeNull();
            return;
        }
        int n = objectArray.length;
        if (n > Short.MAX_VALUE) {
            throw new RuntimeException("object array big size: " + n);
        }
        this.writeByte((byte)14);
        this.writeShort((short)n);
        for (int i = 0; i < n; ++i) {
            this.writeJustObjectArray(objectArray[i]);
        }
    }

    private double[][] readJustDoubleArrayArray() throws IOException {
        int n = this.readShort();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = this.readJustDoubleArray();
        }
        return dArrayArray;
    }

    public final void writeDoubleArrayArray(double[][] dArray) throws IOException {
        if (dArray == null) {
            this.writeNull();
            return;
        }
        int n = dArray.length;
        if (n > Short.MAX_VALUE) {
            throw new RuntimeException("object array big size: " + n);
        }
        this.writeByte((byte)18);
        this.writeShort((short)n);
        for (int i = 0; i < n; ++i) {
            this.writeJustDoubleArray(dArray[i]);
        }
    }

    private int[] readJustIntArray() throws IOException {
        int n = this.readShort();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readInt();
        }
        return nArray;
    }

    private long[] readJustLongArray() throws IOException {
        int n = this.readShort();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.readLong();
        }
        return lArray;
    }

    private void writeIntArray(int[] nArray) throws IOException {
        if (nArray == null) {
            this.writeNull();
            return;
        }
        int n = nArray.length;
        if (n > Short.MAX_VALUE) {
            throw new RuntimeException("int array big size: " + n);
        }
        this.writeByte((byte)10);
        this.writeShort((short)n);
        for (int i = 0; i < n; ++i) {
            this.writeInt(nArray[i]);
        }
    }

    private void writeLongArray(long[] lArray) throws IOException {
        if (lArray == null) {
            this.writeNull();
            return;
        }
        int n = lArray.length;
        if (n > Short.MAX_VALUE) {
            throw new RuntimeException("int array big size: " + n);
        }
        this.writeByte((byte)19);
        this.writeShort((short)n);
        for (int i = 0; i < n; ++i) {
            this.writeLong(lArray[i]);
        }
    }

    private double[] readJustDoubleArray() throws IOException {
        int n = this.readShort();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.readDouble();
        }
        return dArray;
    }

    private void writeDoubleArray(double[] dArray) throws IOException {
        if (dArray == null) {
            this.writeNull();
            return;
        }
        int n = dArray.length;
        if (n > Short.MAX_VALUE) {
            throw new RuntimeException("double array big size: " + n);
        }
        this.writeByte((byte)16);
        this.writeShort((short)n);
        for (int i = 0; i < n; ++i) {
            this.writeDouble(dArray[i]);
        }
    }

    private void writeJustDoubleArray(double[] dArray) throws IOException {
        int n = dArray.length;
        if (n > Short.MAX_VALUE) {
            throw new RuntimeException("object array big size: " + n);
        }
        this.writeShort((short)n);
        for (int i = 0; i < n; ++i) {
            this.writeDouble(dArray[i]);
        }
    }

    private String[] readJustStringArray() throws IOException {
        int n = this.readShort();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.readString();
        }
        return stringArray;
    }

    public void writeStringArray(String[] stringArray) throws IOException {
        if (stringArray == null) {
            this.writeNull();
            return;
        }
        int n = stringArray.length;
        if (n > Short.MAX_VALUE) {
            throw new RuntimeException("String array big size: " + n);
        }
        this.writeByte((byte)12);
        this.writeShort((short)n);
        for (int i = 0; i < n; ++i) {
            this.writeString(stringArray[i]);
        }
    }

    public final HashMap readHashMap() throws IOException {
        if (this.isNull((byte)34, (byte)36)) {
            return null;
        }
        return this.readJustHashMap();
    }

    private HashMap readJustHashMap() throws IOException {
        int n = this.readShort();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(n);
        for (int i = 0; i < n; ++i) {
            Object object = this.readObject();
            Object object2 = this.readObject();
            hashMap.put(object, object2);
        }
        return hashMap;
    }

    public final void writeHashMap(HashMap hashMap) throws IOException {
        this.doWriteMap(hashMap, (byte)34);
    }

    public final void writeMap(Map map) throws IOException {
        this.doWriteMap(map, (byte)36);
    }

    private void doWriteMap(Map map, byte by) throws IOException {
        if (map == null) {
            this.writeNull();
            return;
        }
        int n = map.size();
        if (n > Short.MAX_VALUE) {
            throw new RuntimeException("map big size: " + n);
        }
        this.writeByte(by);
        this.writeShort((short)n);
        try {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.writeObject(entry.getKey());
                this.writeObject(entry.getValue());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.throwConcurrentModificationException(concurrentModificationException, map);
        }
    }

    private void throwConcurrentModificationException(ConcurrentModificationException concurrentModificationException, Object object) {
        throw new ConcurrentModificationException(concurrentModificationException + ", object=" + object);
    }

    public String readUTF() throws IOException {
        return this.input.readUTF();
    }

    public void writeUTF(String string) throws IOException {
        this.output.writeUTF(string);
    }

    public final String readString() throws IOException {
        String string;
        byte by = this.readByte();
        if (by == 1) {
            return null;
        }
        switch (by) {
            case 2: {
                string = this.readUTF();
                break;
            }
            case 15: {
                string = this.readLongString();
                break;
            }
            default: {
                throw new RuntimeException("unexpected, b=" + by + ", expected a string");
            }
        }
        return string;
    }

    static int getUTFLength(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if ('\u0001' <= c && c <= '\u007f') {
                ++n;
                continue;
            }
            if (c > '\u07ff') {
                n += 3;
                continue;
            }
            n += 2;
        }
        return n;
    }

    private String readLongString() throws IOException {
        return this.readUTFBody(this.readInt());
    }

    private String readUTFBody(int n) throws IOException {
        byte[] byArray = this.readBytes(n);
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            int n4 = n3 >> 4;
            switch (n4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    n3 = (n3 & 0x1F) << 6 | by & 0x3F;
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    n3 = (n3 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0;
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    private void writeUTFBody(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('\u0001' <= c && c <= '\u007f') {
                this.writeByte((byte)c);
                continue;
            }
            if ('\u07ff' < c) {
                this.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
            this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    private void writeLongUTF(String string, int n) throws IOException {
        this.writeInt(n);
        if (n == string.length()) {
            this.output.writeBytes(string);
        } else {
            this.writeUTFBody(string);
        }
    }

    public final void writeString(String string) throws IOException {
        if (string == null) {
            this.writeNull();
            return;
        }
        int n = CSHandler.getUTFLength(string);
        if (n > 65535) {
            this.writeByte((byte)15);
            this.writeLongUTF(string, n);
        } else {
            this.writeByte((byte)2);
            this.writeUTF(string);
        }
    }

    private byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.input.readFully(byArray);
        return byArray;
    }

    public final byte[] readByteArray() throws IOException {
        if (this.isNull((byte)8)) {
            return null;
        }
        return this.readBytes(this.readInt());
    }

    public final void writeByteArray(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        int n = byArray.length;
        this.writeByte((byte)8);
        this.writeInt(n);
        this.output.write(byArray);
    }

    private char[] readJustCharArray() throws IOException {
        return this.readUTF().toCharArray();
    }

    public final void writeCharArray(char[] cArray) throws IOException {
        if (cArray == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)5);
        this.writeUTF(new String(cArray));
    }

    public double readDouble() throws IOException {
        return this.input.readDouble();
    }

    public void writeDouble(double d) throws IOException {
        this.output.writeDouble(d);
    }

    public void writeClass(Class clazz) throws IOException {
        if (clazz == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)17);
        this.writeUTF(clazz.getName());
    }

    private Class readJustClass() throws IOException {
        String string = this.readUTF();
        try {
            return ClassCache.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException.getMessage());
        }
    }

    protected final void customWriteObject(Object object) throws IOException {
        ((CustomSerializable)object).customWriteObject(this);
    }

    protected abstract boolean writeObjectOverride(Object var1) throws IOException;

    public final void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
            return;
        }
        CustomSerializer customSerializer = this.customSerializer.getSerializer(object.getClass());
        if (customSerializer != null) {
            this.writeByte((byte)64);
            this.writeUTF(object.getClass().getName());
            customSerializer.writeObject(this, object);
            return;
        }
        if (this.writeObjectOverride(object)) {
            return;
        }
        if (object instanceof ArrayList) {
            this.writeArrayList((ArrayList)object);
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof Integer) {
            this.writeByte((byte)4);
            this.writeInt((Integer)object);
        } else if (object instanceof HashMap) {
            this.writeHashMap((HashMap)object);
        } else if (object instanceof Boolean) {
            this.writeByte((byte)3);
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            this.writeByte((byte)7);
            this.writeByte((Byte)object);
        } else if (object instanceof Long) {
            this.writeByte((byte)13);
            this.writeLong((Long)object);
        } else if (object instanceof Character) {
            this.writeByte((byte)11);
            this.writeUTF(object.toString());
        } else if (object instanceof Double) {
            this.writeByte((byte)6);
            this.writeDouble((Double)object);
        } else if (object instanceof char[]) {
            this.writeCharArray((char[])object);
        } else if (object instanceof int[]) {
            this.writeIntArray((int[])object);
        } else if (object instanceof long[]) {
            this.writeLongArray((long[])object);
        } else if (object instanceof double[]) {
            this.writeDoubleArray((double[])object);
        } else if (object instanceof double[][]) {
            this.writeDoubleArrayArray((double[][])object);
        } else if (object instanceof String[]) {
            this.writeStringArray((String[])object);
        } else if (object instanceof byte[]) {
            this.writeByteArray((byte[])object);
        } else if (object instanceof CustomSerializable) {
            this.writeByte((byte)65);
            this.writeUTF(object.getClass().getName());
            this.customWriteObject(object);
        } else if (object instanceof Object[][]) {
            this.writeObjectArrayArray((Object[][])object);
        } else if (object instanceof Object[]) {
            this.writeObjectArray((Object[])object);
        } else if (object instanceof Class) {
            this.writeClass((Class)object);
        } else if (object instanceof List) {
            this.writeList((List)object);
        } else if (object instanceof Map) {
            this.writeMap((Map)object);
        } else if (object instanceof Collection) {
            this.writeCollection((Collection)object);
        } else {
            this.writeUnhandledObject(object);
        }
    }

    protected void writeUnhandledObject(Object object) throws IOException {
        throw new RuntimeException("writeBaseObject, not implemented: " + object.getClass());
    }

    private static Boolean booleanValueOf(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public final Object readObject() throws IOException {
        Class clazz = null;
        byte by = this.readByte();
        switch (by) {
            case 1: {
                return null;
            }
            case 2: {
                return this.readUTF();
            }
            case 3: {
                return CSHandler.booleanValueOf(this.readBoolean());
            }
            case 4: {
                return new Integer(this.readInt());
            }
            case 13: {
                return new Long(this.readLong());
            }
            case 6: {
                return new Double(this.readDouble());
            }
            case 7: {
                return new Byte(this.readByte());
            }
            case 11: {
                return new Character(this.readUTF().charAt(0));
            }
            case 33: {
                return this.readJustArrayList();
            }
            case 8: {
                return this.readBytes(this.readInt());
            }
            case 5: {
                return this.readJustCharArray();
            }
            case 10: {
                return this.readJustIntArray();
            }
            case 19: {
                return this.readJustLongArray();
            }
            case 16: {
                return this.readJustDoubleArray();
            }
            case 18: {
                return this.readJustDoubleArrayArray();
            }
            case 12: {
                return this.readJustStringArray();
            }
            case 15: {
                return this.readLongString();
            }
            case 65: {
                clazz = this.findClassGuarded(this.readUTF());
                return this.readCustomSerializable(clazz);
            }
            case 34: {
                return this.readJustHashMap();
            }
            case 9: {
                return this.readJustObjectArray();
            }
            case 14: {
                return this.readJustObjectArrayArray();
            }
            case 17: {
                return this.readJustClass();
            }
            case 35: {
                return this.readJustArrayList();
            }
            case 36: {
                return this.readJustHashMap();
            }
            case 37: {
                return this.readJustArrayList();
            }
            case 64: {
                clazz = this.findClassGuarded(this.readUTF());
                CustomSerializer customSerializer = this.customSerializer.getSerializer(clazz);
                if (customSerializer != null) {
                    return customSerializer.readObject(this);
                }
                throw new StreamCorruptedException("Custom serializer can't handle class=" + clazz.getName());
            }
        }
        return this.readObjectOverride(by);
    }

    protected Class findClassGuarded(String string) {
        try {
            return ClassCache.findClass(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Object readCustomSerializable(Class clazz) throws IOException, ObjectStreamException {
        CustomSerializable customSerializable = (CustomSerializable)ReflectUtils.newInstance(clazz);
        customSerializable.customReadObject(this);
        if (customSerializable instanceof ResolvedCustomSerializable) {
            return ((ResolvedCustomSerializable)customSerializable).readResolve();
        }
        return customSerializable;
    }

    protected Object readObjectOverride(byte by) throws IOException {
        throw new StreamCorruptedException("readObjectOverride, type=" + by);
    }
}

