/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.io;

import com.topcoder.netCommon.io.ClientConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SocketClientConnectorAdapter
implements ClientConnector {
    private Socket socket;
    private String localEndpoint;
    private String remoteEndpoint;

    public SocketClientConnectorAdapter(Socket socket) {
        this.socket = socket;
        this.localEndpoint = ((InetSocketAddress)socket.getLocalSocketAddress()).getAddress().getHostAddress() + ":" + socket.getLocalPort();
        this.remoteEndpoint = ((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress().getHostAddress() + ":" + socket.getPort();
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public String toString() {
        return this.remoteEndpoint;
    }

    public void close() throws IOException {
        this.socket.close();
    }
}

