/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.io;

import com.topcoder.net.httptunnel.client.HTTPTunnelClientConnector;
import com.topcoder.netCommon.io.ClientConnector;
import com.topcoder.netCommon.io.InputChannelActivityListener;
import com.topcoder.netCommon.io.NullInputChannelActivityListener;
import com.topcoder.netCommon.io.ObjectReader;
import com.topcoder.netCommon.io.ObjectWriter;
import com.topcoder.netCommon.io.SocketClientConnectorAdapter;
import com.topcoder.shared.netCommon.CSHandler;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.net.Socket;

public final class ClientSocket {
    private ObjectWriter writer;
    private ObjectReader reader;
    private OutputStream outputStream;
    private final DataInput dataInput;
    private InputChannelActivityListener inputChannelActivityListener = new NullInputChannelActivityListener();
    private ClientConnector connector;

    public ClientSocket(Socket socket, CSHandler cSHandler, String string) throws IOException {
        this(string != null && string.length() > 0 ? new HTTPTunnelClientConnector(string) : new SocketClientConnectorAdapter(socket), cSHandler);
    }

    public ClientSocket(ClientConnector clientConnector, CSHandler cSHandler) throws IOException {
        this.init(cSHandler);
        this.connector = clientConnector;
        this.outputStream = clientConnector.getOutputStream();
        this.dataInput = this.buildDataInputStream(clientConnector.getInputStream());
    }

    private void init(CSHandler cSHandler) {
        this.writer = new ObjectWriter(102400, 358400, 0x1900000, cSHandler);
        this.reader = new ObjectReader(102400, 358400, 0x1900000, cSHandler);
    }

    public int writeObject(Object object) throws IOException {
        return this.writeObject(object, this.writer, this.outputStream);
    }

    private synchronized int writeObject(Object object, ObjectWriter objectWriter, OutputStream outputStream) throws IOException {
        return objectWriter.writeObject(outputStream, object);
    }

    public Object readObject() throws ObjectStreamException, IOException {
        Object object = this.readObject(this.reader, this.dataInput);
        return object;
    }

    private Object readObject(ObjectReader objectReader, DataInput dataInput) throws IOException {
        return objectReader.readObject(dataInput);
    }

    public void close() throws IOException {
        this.connector.close();
    }

    public void setInputChannelActivityListener(InputChannelActivityListener inputChannelActivityListener) {
        this.inputChannelActivityListener = inputChannelActivityListener != null ? inputChannelActivityListener : new NullInputChannelActivityListener();
    }

    public String toString() {
        return this.connector.toString();
    }

    private DataInputStream buildDataInputStream(InputStream inputStream) {
        inputStream = new BufferedInputStream(inputStream);
        inputStream = new NotificationInputStreamDecorator(inputStream);
        return new DataInputStream(inputStream);
    }

    private class NotificationInputStreamDecorator
    extends FilterInputStream {
        public NotificationInputStreamDecorator(InputStream inputStream) {
            super(inputStream);
        }

        public int read() throws IOException {
            int n = super.read();
            if (n > -1) {
                ClientSocket.this.inputChannelActivityListener.bytesRead(1);
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 > 0) {
                ClientSocket.this.inputChannelActivityListener.bytesRead(n3);
            }
            return n3;
        }
    }
}

