/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contestantMessages.response;

import com.topcoder.netCommon.contestantMessages.response.BaseResponse;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.problem.DataType;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;

public class TestInfoResponse
extends BaseResponse {
    private DataType[] dataTypes;
    private int componentID;

    public TestInfoResponse() {
    }

    public TestInfoResponse(DataType[] dataTypeArray, int n) {
        this.dataTypes = dataTypeArray;
        this.componentID = n;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        super.customWriteObject(cSWriter);
        cSWriter.writeInt(this.dataTypes.length);
        for (int i = 0; i < this.dataTypes.length; ++i) {
            cSWriter.writeObject(this.dataTypes[i]);
        }
        cSWriter.writeInt(this.componentID);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        super.customReadObject(cSReader);
        int n = cSReader.readInt();
        this.dataTypes = new DataType[n];
        for (int i = 0; i < n; ++i) {
            this.dataTypes[i] = (DataType)cSReader.readObject();
        }
        this.componentID = cSReader.readInt();
    }

    public DataType[] getDataTypes() {
        return this.dataTypes;
    }

    public int getComponentID() {
        return this.componentID;
    }

    public ArrayList oldGetDataTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.dataTypes.length; ++i) {
            arrayList.add(this.dataTypes[i].getDescriptor(1));
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("(com.topcoder.netCommon.contestantMessages.response.TestInfoResponse) [");
        stringBuffer.append("dataTypes = ");
        if (this.dataTypes == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("{");
            for (int i = 0; i < this.dataTypes.length; ++i) {
                stringBuffer.append(this.dataTypes[i].toString() + ",");
            }
            stringBuffer.append("}");
        }
        stringBuffer.append(", ");
        stringBuffer.append("componentID = ");
        stringBuffer.append(this.componentID);
        stringBuffer.append(", ");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

