/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contestantMessages.request;

import com.topcoder.netCommon.contestantMessages.request.BaseRequest;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ErrorReportRequest
extends BaseRequest {
    protected String error;
    protected String jvmVendor;
    protected String jvmVersion;

    public ErrorReportRequest() {
    }

    public ErrorReportRequest(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        this.error = stringWriter.toString();
        this.jvmVendor = System.getProperty("java.vendor");
        this.jvmVersion = System.getProperty("java.version");
    }

    public void customReadObject(CSReader cSReader) throws IOException {
        super.customReadObject(cSReader);
        this.error = cSReader.readString();
        this.jvmVendor = cSReader.readString();
        this.jvmVersion = cSReader.readString();
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        super.customWriteObject(cSWriter);
        cSWriter.writeString(this.error);
        cSWriter.writeString(this.jvmVendor);
        cSWriter.writeString(this.jvmVersion);
    }

    public int getRequestType() {
        return 118;
    }

    public String getJVMVendor() {
        return this.jvmVendor;
    }

    public String getJVMVersion() {
        return this.jvmVersion;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("(com.topcoder.netCommon.contestantMessages.request.ErrorReportRequest) [");
        stringBuffer.append("jvmVendor = ");
        stringBuffer.append(this.jvmVendor);
        stringBuffer.append(", ");
        stringBuffer.append("jvmVersion = ");
        stringBuffer.append(this.jvmVersion);
        stringBuffer.append(", ");
        stringBuffer.append("error = ");
        stringBuffer.append(this.error);
        stringBuffer.append(", ");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

