/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.netCommon.contest.round;

import com.topcoder.netCommon.contest.ResultDisplayType;
import com.topcoder.netCommon.contest.round.RoundCustomProperties;
import com.topcoder.netCommon.contest.round.RoundType;
import com.topcoder.netCommon.contest.round.RoundTypeProperties;
import com.topcoder.shared.language.Language;

public class RoundProperties
implements RoundCustomProperties,
RoundTypeProperties {
    private RoundType typeProperties;
    private RoundCustomProperties customProperties;
    private transient Boolean scoredRound;

    public RoundProperties() {
    }

    public RoundProperties(RoundType roundType, RoundCustomProperties roundCustomProperties) {
        this.typeProperties = roundType;
        this.customProperties = roundCustomProperties;
    }

    public boolean allowsPerUserCodingTime() {
        return this.typeProperties.allowsPerUserCodingTime();
    }

    public int getRatingType() {
        return this.typeProperties.getRatingType();
    }

    public boolean hasChallengePhase() {
        return this.typeProperties.hasChallengePhase();
    }

    public boolean hasDivisions() {
        return this.typeProperties.hasDivisions();
    }

    public boolean isVisibleOnlyForRegisteredUsers() {
        return this.typeProperties.isVisibleOnlyForRegisteredUsers();
    }

    public boolean mustStopSystemTestsOnFailure() {
        return this.typeProperties.mustStopSystemTestsOnFailure();
    }

    public boolean useRoomAssignamentProcess() {
        return this.typeProperties.useRoomAssignamentProcess();
    }

    public boolean autoEndContestAfterSystemTests() {
        return this.typeProperties.autoEndContestAfterSystemTests();
    }

    public boolean isSummaryEnabledDuringContest() {
        return this.typeProperties.isSummaryEnabledDuringContest();
    }

    public boolean isCoderHistoryEnabled() {
        return this.typeProperties.isCoderHistoryEnabled();
    }

    public boolean hasRegistrationPhase() {
        return this.typeProperties.hasRegistrationPhase();
    }

    public ResultDisplayType[] getAllowedScoreTypesToShow() {
        if (this.customProperties.getAllowedScoreTypesToShow() == null) {
            return this.typeProperties.getDefaultRoundProperties().getAllowedScoreTypesToShow();
        }
        return this.customProperties.getAllowedScoreTypesToShow();
    }

    public Long getPerUserCodingTime() {
        if (this.customProperties.getPerUserCodingTime() == null) {
            return this.typeProperties.getDefaultRoundProperties().getPerUserCodingTime();
        }
        return this.customProperties.getPerUserCodingTime();
    }

    public Boolean getShowScoresOfOtherCoders() {
        if (this.customProperties.getShowScoresOfOtherCoders() == null) {
            return this.typeProperties.getDefaultRoundProperties().getShowScoresOfOtherCoders();
        }
        return this.customProperties.getShowScoresOfOtherCoders();
    }

    public Language[] getAllowedLanguages() {
        if (this.customProperties.getAllowedLanguages() == null) {
            return this.typeProperties.getDefaultRoundProperties().getAllowedLanguages();
        }
        return this.customProperties.getAllowedLanguages();
    }

    public boolean allowsLanguage(Language language) {
        if (this.customProperties.getAllowedLanguages() == null) {
            return this.typeProperties.getDefaultRoundProperties().allowsLanguage(language);
        }
        return this.customProperties.allowsLanguage(language);
    }

    public Long getCodingLengthOverride() {
        if (this.customProperties.getCodingLengthOverride() == null) {
            return this.typeProperties.getDefaultRoundProperties().getCodingLengthOverride();
        }
        return this.customProperties.getCodingLengthOverride();
    }

    public boolean usesPerUserCodingTime() {
        return this.allowsPerUserCodingTime() && !NO_PER_USER_CODING_TIME.equals(this.getPerUserCodingTime());
    }

    public boolean usesScore() {
        if (this.scoredRound == null) {
            this.scoredRound = this.allowsScoreType(ResultDisplayType.POINTS);
        }
        return this.scoredRound;
    }

    public boolean allowsScoreType(ResultDisplayType resultDisplayType) {
        ResultDisplayType[] resultDisplayTypeArray = this.getAllowedScoreTypesToShow();
        for (int i = 0; i < resultDisplayTypeArray.length; ++i) {
            if (!resultDisplayType.equals(resultDisplayTypeArray[i])) continue;
            return true;
        }
        return false;
    }
}

