/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.net.httptunnel.common.digest;

import com.topcoder.net.httptunnel.common.digest.TokenDigesterException;
import com.topcoder.shared.util.encoding.HexEncoding;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class TokenDigester {
    private final MessageDigest digester;

    public TokenDigester() throws TokenDigesterException {
        try {
            this.digester = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new TokenDigesterException("Could not find algorithm for digest", noSuchAlgorithmException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateDigest(String string, int n, Object object) {
        byte[] byArray;
        MessageDigest messageDigest = this.digester;
        synchronized (messageDigest) {
            this.digester.update(object.toString().getBytes());
            this.digester.update(string.getBytes());
            byArray = this.digester.digest(String.valueOf(n).getBytes());
        }
        return this.toHexString(byArray);
    }

    private String toHexString(byte[] byArray) {
        return HexEncoding.toHexString(byArray);
    }
}

